/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.component.UIMessage;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.component.AjaxContainer;
import org.ajax4jsf.component.AjaxSupport;
import org.ajax4jsf.component.EventValueExpression;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.event.AjaxListener;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.webapp.taglib.MethodExpressionAjaxListener;
import org.richfaces.component.UIRichMessages;
import org.richfaces.event.ValidationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIAjaxValidator
extends UIComponentBase
implements AjaxComponent,
AjaxSupport,
AjaxContainer {
    public static final String COMPONENT_TYPE = "org.richfaces.AjaxValidator";
    public static final String COMPONENT_FAMILY = "org.richfaces.AjaxValidator";
    public static final String BEAN_VALIDATOR_FACET = "org.richfaces.validator.";

    public void setParent(UIComponent parent) {
        super.setParent(parent);
        if (null != parent && parent instanceof EditableValueHolder) {
            this.setParentProperties(parent);
        }
    }

    public void setParentProperties(UIComponent parent) throws FacesException {
        if (!(parent instanceof EditableValueHolder)) {
            throw new FacesException("Parent component must be an EditableValueHolder");
        }
        if (null != this.getEvent()) {
            EventValueExpression binding = new EventValueExpression((AjaxSupport)this);
            parent.setValueExpression(this.getEvent(), (ValueExpression)binding);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event.getComponent() == this) {
            FacesContext context = this.getFacesContext();
            if (event instanceof ValidationEvent) {
                context.renderResponse();
            } else if (event instanceof AjaxEvent) {
                AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
                ajaxContext.setSubmittedRegionClientId(this.getClientId(context));
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        UIComponent parent;
        if (event instanceof ValidationEvent && event.getComponent() == this && (parent = this.getParent()) instanceof UIInput) {
            UIInput input = (UIInput)parent;
            if (input.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
            }
        }
        super.queueEvent(event);
    }

    public String getEventString() {
        StringBuffer buildOnEvent = new StringBuffer();
        String onsubmit = this.getOnsubmit();
        if (null != onsubmit) {
            buildOnEvent.append(onsubmit).append(";");
        }
        buildOnEvent.append(AjaxRendererUtils.buildOnEvent((UIComponent)this, (FacesContext)this.getFacesContext(), (String)this.getEvent(), (boolean)true));
        String script = buildOnEvent.toString();
        return script;
    }

    public UIComponent getSingleComponent() {
        return this.getParent();
    }

    public void encodeAjax(FacesContext context) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        Set renderedAreas = ajaxContext.getAjaxRenderedAreas();
        for (UIComponent message : this.getMessages(context)) {
            if (!message.isRendered()) continue;
            message.encodeAll(context);
            renderedAreas.add(message.getClientId(context));
        }
        AjaxRendererUtils.encodeAreas((FacesContext)context, (UIComponent)this);
    }

    public Set<UIComponent> getMessages(FacesContext context) {
        HashSet<UIComponent> messages = new HashSet<UIComponent>();
        this.findMessages(this.getParent(), (UIComponent)this, messages, false);
        this.findRichMessages(context, (UIComponent)context.getViewRoot(), messages);
        return messages;
    }

    protected void findRichMessages(FacesContext context, UIComponent component, Set<UIComponent> messages) {
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent child = (UIComponent)facetsAndChildren.next();
            if (child instanceof UIRichMessages) {
                UIRichMessages richMessage = (UIRichMessages)child;
                if (null != richMessage.getFor()) continue;
                richMessage.updateMessages(context, this.getParent().getClientId(context));
                messages.add((UIComponent)richMessage);
                continue;
            }
            this.findRichMessages(context, child, messages);
        }
    }

    protected boolean findMessages(UIComponent parent, UIComponent component, Set<UIComponent> messages, boolean found) {
        UIComponent newParent;
        Iterator facetsAndChildren = parent.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent child = (UIComponent)facetsAndChildren.next();
            if (child == component) continue;
            if (child instanceof UIMessage || child instanceof UIMessages) {
                UIComponent message = child;
                Object targetId = message.getAttributes().get("for");
                if (null == targetId || !targetId.equals(this.getParent().getId())) continue;
                messages.add(message);
                found = true;
                continue;
            }
            found |= this.findMessages(child, null, messages, found);
        }
        if (!(found && parent instanceof NamingContainer || component == null || null == (newParent = parent.getParent()))) {
            found = this.findMessages(newParent, parent, messages, found);
        }
        return found;
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public AjaxListener[] getAjaxListeners() {
        return (AjaxListener[])this.getFacesListeners(AjaxListener.class);
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void setAjaxListener(MethodExpression listener) {
        AjaxListener[] ajaxListeners = this.getAjaxListeners();
        for (int i = 0; i < ajaxListeners.length; ++i) {
            MethodExpressionAjaxListener expressionListener;
            AjaxListener ajaxListener = ajaxListeners[i];
            if (!ajaxListener.getClass().equals(MethodExpressionAjaxListener.class) || (expressionListener = (MethodExpressionAjaxListener)ajaxListener).getExpression() == listener) continue;
            this.removeAjaxListener(ajaxListener);
            if (listener != null) break;
            return;
        }
        this.addAjaxListener((AjaxListener)new MethodExpressionAjaxListener(listener));
    }

    public MethodExpression getAjaxListener() {
        AjaxListener[] ajaxListeners = this.getAjaxListeners();
        for (int i = 0; i < ajaxListeners.length; ++i) {
            AjaxListener ajaxListener = ajaxListeners[i];
            if (!ajaxListener.getClass().equals(MethodExpressionAjaxListener.class)) continue;
            MethodExpressionAjaxListener expressionListener = (MethodExpressionAjaxListener)ajaxListener;
            return expressionListener.getExpression();
        }
        return null;
    }
}

