/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.GossipClient;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PING
extends Discovery {
    String gossip_host = null;
    Vector<IpAddress> gossip_hosts = null;
    int gossip_port = 0;
    long gossip_refresh = 20000L;
    GossipClient client;
    int port_range = 1;
    private List<Address> initial_hosts = null;
    int sock_conn_timeout = 1000;
    int sock_read_timeout = 3000;
    protected final Promise<Boolean> discovery_reception = new Promise();
    private long discovery_timeout = 0L;
    public static final String name = "PING";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("gossip_host");
        if (str != null) {
            this.gossip_host = str;
            props.remove("gossip_host");
        }
        if ((str = props.getProperty("gossip_hosts")) != null) {
            try {
                this.gossip_hosts = this.createInitialHosts(str);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
            props.remove("gossip_hosts");
        }
        if ((str = props.getProperty("gossip_port")) != null) {
            this.gossip_port = Integer.parseInt(str);
            props.remove("gossip_port");
        }
        if ((str = props.getProperty("gossip_refresh")) != null) {
            this.gossip_refresh = Long.parseLong(str);
            props.remove("gossip_refresh");
        }
        if ((str = props.getProperty("sock_conn_timeout")) != null) {
            this.sock_conn_timeout = Integer.parseInt(str);
            props.remove("sock_conn_timeout");
        }
        if ((str = props.getProperty("sock_read_timeout")) != null) {
            this.sock_read_timeout = Integer.parseInt(str);
            props.remove("sock_read_timeout");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            if (this.port_range < 1) {
                this.port_range = 1;
            }
            props.remove("port_range");
        }
        if ((str = props.getProperty("discovery_timeout")) != null) {
            this.discovery_timeout = Integer.parseInt(str);
            props.remove("discovery_timeout");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            try {
                this.initial_hosts = new ArrayList<Address>();
                Vector<IpAddress> tmp = this.createInitialHosts(str);
                this.initial_hosts.addAll(tmp);
            }
            catch (UnknownHostException e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"failed constructing initial list of hosts", (Throwable)e);
                }
                return false;
            }
        }
        return super.setProperties(props);
    }

    public int getGossipPort() {
        return this.gossip_port;
    }

    public void setGossipPort(int gossip_port) {
        this.gossip_port = gossip_port;
    }

    public long getGossipRefresh() {
        return this.gossip_refresh;
    }

    public void setGossipRefresh(long gossip_refresh) {
        this.gossip_refresh = gossip_refresh;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.gossip_hosts != null) {
            this.client = new GossipClient(this.gossip_hosts, this.gossip_refresh);
            this.client.setSocketConnectionTimeout(this.sock_conn_timeout);
            this.client.setSocketReadTimeout(this.sock_read_timeout);
        } else if (this.gossip_host != null && this.gossip_port != 0) {
            this.client = new GossipClient(new IpAddress(InetAddress.getByName(this.gossip_host), this.gossip_port), this.gossip_refresh);
            this.client.setSocketConnectionTimeout(this.sock_conn_timeout);
            this.client.setSocketReadTimeout(this.sock_read_timeout);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.client != null) {
            this.client.stop();
        }
        this.discovery_reception.reset();
    }

    @Override
    public void localAddressSet(Address addr) {
        if (this.initial_hosts != null && addr != null && this.initial_hosts.contains(addr)) {
            this.initial_hosts.remove(addr);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[SET_LOCAL_ADDRESS]: removing my own address (" + addr + ") from initial_hosts; initial_hosts=" + this.initial_hosts));
            }
        }
    }

    @Override
    public void handleConnect() {
        if (this.client != null) {
            this.client.register(this.group_addr, this.local_addr);
        }
    }

    @Override
    public void handleDisconnect() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    public void sendGetMembersRequest() {
        if (this.client != null) {
            List<Address> gossip_rsps = this.client.getMembers(this.group_addr);
            if (gossip_rsps == null || gossip_rsps.isEmpty()) {
                return;
            }
            Event view_event = new Event(15, this.makeView(new Vector<Address>(gossip_rsps)));
            this.down_prot.down(view_event);
            if (!gossip_rsps.isEmpty()) {
                for (Address dest : gossip_rsps) {
                    Message msg = new Message(dest, null, null);
                    msg.setFlag((byte)1);
                    msg.putHeader(this.getName(), new PingHeader(1, null));
                    this.down_prot.down(new Event(1, msg));
                }
            }
            Util.sleep(500L);
        } else if (this.initial_hosts != null && !this.initial_hosts.isEmpty()) {
            for (Address addr : this.initial_hosts) {
                Message msg = new Message(addr, null, null);
                msg.setFlag((byte)1);
                msg.putHeader(name, new PingHeader(1, null));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest()));
                }
                this.down_prot.down(new Event(1, msg));
            }
        } else {
            PingHeader hdr = new PingHeader(1, null);
            Message msg = new Message(null);
            msg.setFlag((byte)1);
            msg.putHeader(this.getName(), hdr);
            this.sendMcastDiscoveryRequest(msg);
        }
    }

    @Override
    public Object up(Event evt) {
        Message msg;
        PingHeader hdr;
        if (evt.getType() == 1 && (hdr = (PingHeader)(msg = (Message)evt.getArg()).getHeader(this.getName())) != null && hdr.type == 1 && msg.getSrc().equals(this.local_addr)) {
            this.discovery_reception.setResult(true);
        }
        return super.up(evt);
    }

    void sendMcastDiscoveryRequest(Message discovery_request) {
        this.discovery_reception.reset();
        this.down_prot.down(new Event(1, discovery_request));
        this.waitForDiscoveryRequestReception();
    }

    protected void waitForDiscoveryRequestReception() {
        block3: {
            if (this.discovery_timeout > 0L) {
                try {
                    this.discovery_reception.getResultWithTimeout(this.discovery_timeout);
                }
                catch (TimeoutException e) {
                    if (!this.log.isWarnEnabled()) break block3;
                    this.log.warn((Object)"didn't receive my own discovery request - multicast socket might not be configured correctly");
                }
            }
        }
    }

    private Vector<IpAddress> createInitialHosts(String l) throws UnknownHostException {
        StringTokenizer tok = new StringTokenizer(l, ",");
        Vector<IpAddress> retval = new Vector<IpAddress>();
        while (tok.hasMoreTokens()) {
            try {
                int port;
                String t = tok.nextToken().trim();
                String host = t.substring(0, t.indexOf(91));
                host = host.trim();
                for (int i = port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93))); i < port + this.port_range; ++i) {
                    IpAddress addr = new IpAddress(host, i);
                    retval.add(addr);
                }
            }
            catch (NumberFormatException e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exeption is " + e));
            }
        }
        return retval;
    }
}

