/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.intercept;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.intercept.EventType;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.intercept.SeamInvocationContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.EJB;

public class RootInterceptor
implements Serializable {
    private static final long serialVersionUID = 8041533870186694663L;
    private static final LogProvider log = Logging.getLogProvider(RootInterceptor.class);
    private final InterceptorType type;
    private boolean isSeamComponent;
    private String componentName;
    private List<Object> userInterceptors;
    private transient Component component;
    private static final Constructor CONSTRUCTOR;

    protected RootInterceptor(InterceptorType type) {
        this.type = type;
    }

    protected void init(Component component) {
        this.isSeamComponent = true;
        this.componentName = component.getName();
        this.userInterceptors = component.createUserInterceptors(this.type);
        this.component = component;
    }

    protected void initNonSeamComponent() {
        this.isSeamComponent = false;
    }

    protected void postConstruct(Object bean) {
        if (this.isSeamComponent) {
            try {
                this.getComponent().initialize(bean);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("exception initializing EJB component", e);
            }
        }
    }

    protected void invokeAndHandle(InvocationContext invocation, EventType invocationType) {
        try {
            this.invoke(invocation, invocationType);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("exception in EJB lifecycle callback", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(InvocationContext invocation, EventType invocationType) throws Exception {
        if (!this.isSeamComponent) {
            return invocation.proceed();
        }
        if (Contexts.isEventContextActive() || Contexts.isApplicationContextActive()) {
            return this.createInvocationContext(invocation, invocationType).proceed();
        }
        Lifecycle.beginCall();
        try {
            Object object = this.createInvocationContext(invocation, invocationType).proceed();
            return object;
        }
        finally {
            Lifecycle.endCall();
        }
    }

    private InvocationContext createInvocationContext(InvocationContext invocation, EventType eventType) throws Exception {
        if (this.isProcessInterceptors(invocation.getMethod(), invocation.getTarget())) {
            if (log.isTraceEnabled()) {
                log.trace("intercepted: " + this.getInterceptionMessage(invocation, eventType));
            }
            return this.createSeamInvocationContext(invocation, eventType);
        }
        if (log.isTraceEnabled()) {
            log.trace("not intercepted: " + this.getInterceptionMessage(invocation, eventType));
        }
        return invocation;
    }

    private SeamInvocationContext createSeamInvocationContext(InvocationContext invocation, EventType eventType) throws Exception {
        return EJB.INVOCATION_CONTEXT_AVAILABLE ? this.createEE5SeamInvocationContext(invocation, eventType) : this.createNonEE5SeamInvocationContext(invocation, eventType);
    }

    private SeamInvocationContext createNonEE5SeamInvocationContext(InvocationContext invocation, EventType eventType) {
        return new SeamInvocationContext(invocation, eventType, this.userInterceptors, this.getComponent().getInterceptors(this.type));
    }

    private SeamInvocationContext createEE5SeamInvocationContext(InvocationContext invocation, EventType eventType) {
        try {
            return (SeamInvocationContext)CONSTRUCTOR.newInstance(new Object[]{invocation, eventType, this.userInterceptors, this.getComponent().getInterceptors(this.type)});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getInterceptionMessage(InvocationContext invocation, EventType eventType) {
        return this.getComponent().getName() + '.' + (eventType == EventType.AROUND_INVOKE ? invocation.getMethod().getName() : eventType);
    }

    private boolean isProcessInterceptors(Method method, Object bean) {
        return this.isSeamComponent && this.getComponent().isInterceptionEnabled() && !this.isBypassed(method) && !this.isClearDirtyMethod(method, bean);
    }

    private boolean isBypassed(Method method) {
        return method != null && method.isAnnotationPresent(BypassInterceptors.class);
    }

    private boolean isClearDirtyMethod(Method method, Object bean) {
        return bean instanceof Mutable && method != null && method.getName().equals("clearDirty") && method.getParameterTypes().length == 0;
    }

    protected Component getComponent() {
        if (this.isSeamComponent && this.component == null) {
            this.component = Seam.componentForName(this.componentName);
        }
        return this.component;
    }

    protected boolean isSeamComponent() {
        return this.isSeamComponent;
    }

    protected String getComponentName() {
        return this.componentName;
    }

    static {
        if (EJB.INVOCATION_CONTEXT_AVAILABLE) {
            try {
                Class[] paramTypes = new Class[]{InvocationContext.class, EventType.class, List.class, List.class};
                CONSTRUCTOR = Class.forName("org.jboss.seam.intercept.EE5SeamInvocationContext").getConstructor(paramTypes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            CONSTRUCTOR = null;
        }
    }
}

