/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component.behavior;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.BehaviorListener;
import javax.faces.event.FacesListener;

public class BehaviorBase
implements Behavior,
PartialStateHolder {
    private List<BehaviorListener> listeners;
    private boolean transientFlag = false;
    private boolean initialState = false;

    public void broadcast(BehaviorEvent event) throws AbortProcessingException {
        if (null != this.listeners) {
            for (BehaviorListener listener : this.listeners) {
                if (!event.isAppropriateListener((FacesListener)listener)) continue;
                event.processListener((FacesListener)listener);
            }
        }
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.initialStateMarked()) {
            return null;
        }
        return UIComponentBase.saveAttachedState(context, this.listeners);
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            this.listeners = (List)UIComponentBase.restoreAttachedState(context, state);
            this.clearInitialState();
        }
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }

    protected void addBehaviorListener(BehaviorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<BehaviorListener>();
        }
        this.listeners.add(listener);
        this.clearInitialState();
    }

    protected void removeBehaviorListener(BehaviorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        this.clearInitialState();
    }
}

