/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.renderer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.renderer.AbstractScheduleRenderer;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.FormInfo;

public abstract class AbstractCompactScheduleRenderer
extends AbstractScheduleRenderer
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$schedule$renderer$AbstractCompactScheduleRenderer == null ? (class$org$apache$myfaces$custom$schedule$renderer$AbstractCompactScheduleRenderer = AbstractCompactScheduleRenderer.class$("org.apache.myfaces.custom.schedule.renderer.AbstractCompactScheduleRenderer")) : class$org$apache$myfaces$custom$schedule$renderer$AbstractCompactScheduleRenderer));
    static /* synthetic */ Class class$org$apache$myfaces$custom$schedule$renderer$AbstractCompactScheduleRenderer;

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    protected abstract int getDefaultRowHeight();

    protected abstract String getRowHeightProperty();

    protected int getRowHeight(Map attributes) {
        int rowHeight = 0;
        try {
            rowHeight = Integer.valueOf((String)attributes.get(this.getRowHeightProperty()));
        }
        catch (Exception e) {
            rowHeight = 0;
        }
        if (rowHeight == 0) {
            rowHeight = this.getDefaultRowHeight();
        }
        return rowHeight;
    }

    protected void writeDayCell(FacesContext context, ResponseWriter writer, HtmlSchedule schedule, ScheduleDay day, float cellWidth, int dayOfWeek, int dayOfMonth, boolean isWeekend, boolean isCurrentMonth, int rowspan) throws IOException {
        String clientId = schedule.getClientId(context);
        Map attributes = schedule.getAttributes();
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        String dayHeaderId = clientId + "_header_" + ScheduleUtil.getDateId(day.getDate());
        String dayBodyId = clientId + "_body_" + ScheduleUtil.getDateId(day.getDate());
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("rowspan", (Object)String.valueOf(rowspan), null);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, isCurrentMonth ? "day" : "inactive-day"), null);
        StringBuffer styleBuffer = new StringBuffer();
        int rowHeight = this.getRowHeight(attributes);
        String myRowHeight = "height: ";
        String myContentHeight = "height: ";
        if (rowHeight > 0) {
            if (isWeekend) {
                myRowHeight = myRowHeight + rowHeight / 2 + "px;";
                myContentHeight = myContentHeight + (rowHeight / 2 - 19) + "px;";
            } else {
                myRowHeight = myRowHeight + (rowHeight + 1) + "px;";
                myContentHeight = myContentHeight + (rowHeight + 1 - 18) + "px;";
            }
        } else {
            myRowHeight = myRowHeight + "100%;";
            myContentHeight = myContentHeight + "100%;";
        }
        styleBuffer.append(myRowHeight);
        writer.writeAttribute("style", (Object)(styleBuffer.toString() + " width: " + cellWidth + "%;"), null);
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "day"), null);
        writer.writeAttribute("style", (Object)(styleBuffer.toString() + " width: 100%;"), null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "header"), null);
        writer.writeAttribute("style", (Object)"height: 18px; width: 100%; overflow: hidden", null);
        writer.writeAttribute("id", (Object)dayHeaderId, null);
        if (!schedule.isReadonly() && schedule.isSubmitOnClick()) {
            writer.writeAttribute("onmouseup", (Object)("fireScheduleDateClicked(this, event, '" + formId + "', '" + clientId + "');"), null);
        }
        writer.writeText((Object)this.getDateString(context, (UIComponent)schedule, day.getDate()), null);
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)schedule);
        writer.startElement("td", (UIComponent)schedule);
        writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "content"), null);
        StringBuffer contentStyleBuffer = new StringBuffer();
        contentStyleBuffer.append(myContentHeight);
        contentStyleBuffer.append(" width: 100%;");
        writer.writeAttribute("style", (Object)contentStyleBuffer.toString(), null);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%; overflow: auto; vertical-align: top;", null);
        writer.startElement("div", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"width: 100%; height: 100%; vertical-align: top;", null);
        writer.writeAttribute("id", (Object)dayBodyId, null);
        if (!schedule.isReadonly() && schedule.isSubmitOnClick()) {
            writer.writeAttribute("onmouseup", (Object)("fireScheduleTimeClicked(this, event, '" + formId + "', '" + clientId + "');"), null);
        }
        writer.startElement("table", (UIComponent)schedule);
        writer.writeAttribute("style", (Object)"width: 100%;", null);
        this.writeEntries(context, schedule, day, writer);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("td");
    }

    protected void writeEntries(FacesContext context, HtmlSchedule schedule, ScheduleDay day, ResponseWriter writer) throws IOException {
        ScheduleEntry entry;
        String clientId = schedule.getClientId(context);
        FormInfo parentFormInfo = RendererUtils.findNestingForm((UIComponent)schedule, context);
        String formId = parentFormInfo == null ? null : parentFormInfo.getFormName();
        TreeSet<ScheduleEntry> entrySet = new TreeSet<ScheduleEntry>(comparator);
        Iterator entryIterator = day.iterator();
        while (entryIterator.hasNext()) {
            entry = (ScheduleEntry)entryIterator.next();
            entrySet.add(entry);
        }
        entryIterator = entrySet.iterator();
        while (entryIterator.hasNext()) {
            entry = (ScheduleEntry)entryIterator.next();
            writer.startElement("tr", (UIComponent)schedule);
            writer.startElement("td", (UIComponent)schedule);
            if (this.isSelected(schedule, entry)) {
                writer.writeAttribute("class", (Object)this.getStyleClass((UIComponent)schedule, "selected"), null);
            }
            StringBuffer entryStyle = new StringBuffer();
            entryStyle.append("width: 100%;");
            String entryColor = this.getEntryRenderer((UIComponent)schedule).getColor(context, schedule, entry, this.isSelected(schedule, entry));
            if (this.isSelected(schedule, entry) && entryColor != null) {
                entryStyle.append(" background-color: ");
                entryStyle.append(entryColor);
                entryStyle.append(";");
                entryStyle.append(" border-color: ");
                entryStyle.append(entryColor);
                entryStyle.append(";");
            }
            writer.writeAttribute("style", (Object)entryStyle.toString(), null);
            if (this.showTooltip((UIComponent)schedule)) {
                this.getEntryRenderer((UIComponent)schedule).renderToolTip(context, writer, schedule, entry, this.isSelected(schedule, entry));
            }
            if (!this.isSelected(schedule, entry) && !schedule.isReadonly()) {
                writer.startElement("a", (UIComponent)schedule);
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onmouseup", (Object)("fireEntrySelected('" + formId + "', '" + clientId + "', '" + entry.getId() + "');"), null);
            }
            this.getEntryRenderer((UIComponent)schedule).renderContent(context, writer, schedule, day, entry, true, this.isSelected(schedule, entry));
            if (!this.isSelected(schedule, entry) && !schedule.isReadonly()) {
                writer.endElement("a");
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    private boolean isSelected(HtmlSchedule schedule, ScheduleEntry entry) {
        ScheduleEntry selectedEntry = schedule.getModel().getSelectedEntry();
        if (selectedEntry == null) {
            return false;
        }
        return selectedEntry.getId().equals(entry.getId());
    }

    protected Date determineLastClickedDate(HtmlSchedule schedule, String dateId, String yPos) {
        Calendar cal = GregorianCalendar.getInstance();
        String day = dateId.substring(dateId.lastIndexOf("_") + 1);
        Date date = ScheduleUtil.getDateFromId(day);
        if (date != null) {
            cal.setTime(date);
        }
        cal.set(11, schedule.getVisibleStartHour());
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        log.debug((Object)("last clicked datetime: " + cal.getTime()));
        return cal.getTime();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

