/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.json;

import java.util.AbstractCollection;
import java.util.Iterator;
import org.richfaces.json.JSONAccessor;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONException;

public class JSONCollection
extends AbstractCollection {
    private JSONArray array;

    public JSONCollection() throws JSONException {
        this.array = new JSONArray();
    }

    public JSONCollection(String jsonString) throws JSONException {
        this.array = new JSONArray(jsonString);
    }

    public JSONCollection(JSONArray array) throws JSONException {
        this.array = array;
    }

    public Iterator iterator() {
        return new Iterator(){
            int index = 0;

            public boolean hasNext() {
                return this.index < JSONCollection.this.array.length();
            }

            public Object next() {
                try {
                    return JSONAccessor.unwrapValue(JSONCollection.this.array.get(this.index++));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    throw new RuntimeException();
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.array.length();
    }

    public static void main(String[] args) throws JSONException {
        JSONCollection collection = new JSONCollection("['string', [1, 2, 3]]");
        Object[] objects = collection.toArray();
        for (int i = 0; i < objects.length; ++i) {
            System.out.print(i + "=> ");
            System.out.println(objects[i]);
        }
    }
}

