/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class SeamVariableResolver
extends VariableResolver {
    private static final LogProvider log = Logging.getLogProvider(SeamVariableResolver.class);
    private VariableResolver jsfVariableResolver;

    public SeamVariableResolver(VariableResolver jsfVariableResolver) {
        this.jsfVariableResolver = jsfVariableResolver;
    }

    public Object resolveVariable(FacesContext facesContext, String name) throws EvaluationException {
        if (!Contexts.isApplicationContextActive()) {
            return this.jsfVariableResolver.resolveVariable(facesContext, name);
        }
        name = name.replace('$', '.');
        log.debug("resolving name: " + name);
        Object seamBean = Component.getInstance(name, true);
        if (seamBean == null) {
            Component component = Component.forName(name);
            if (component == null) {
                Object managedBean = this.jsfVariableResolver.resolveVariable(facesContext, name);
                if (managedBean == null) {
                    log.debug("could not resolve name");
                    return Init.instance().getRootNamespace().getChild(name);
                }
                log.debug("resolved name to JSF managed bean");
                return managedBean;
            }
            log.debug("Seam component resolved, but unwrap method returned null");
            return null;
        }
        log.debug("resolved name to Seam component");
        return seamBean;
    }
}

