/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.microcontainer;

import java.io.Serializable;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

@Scope(value=ScopeType.APPLICATION)
public abstract class ControllerNotificationComponent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Logger
    protected Log log;

    @Create
    public void create(Component component) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating notification MC component ...", new Object[0]);
        }
        try {
            this.notifyController(component);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Exception installing ControllerNotificationComponent: " + t);
        }
    }

    protected abstract void notifyController(Component var1) throws Throwable;

    protected abstract void clearNotification() throws Throwable;

    @Destroy
    public void destroy() {
        try {
            this.clearNotification();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Notification MC component destroyed ...", new Object[0]);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Exception while clearing previous notification: " + t), new Object[0]);
        }
    }
}

