/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.ajax4jsf.Messages;
import org.ajax4jsf.util.InputUtils;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectUtils {
    private static final Logger log = RichfacesLogger.APPLICATION.getLogger();

    public static List<SelectItem> getSelectItems(FacesContext context, UIComponent component) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (UIComponent kid : component.getChildren()) {
            String valueClass;
            Object value;
            if (kid instanceof UISelectItem) {
                value = ((UISelectItem)kid).getValue();
                if (value == null) {
                    UISelectItem item = (UISelectItem)kid;
                    list.add(new SelectItem(item.getItemValue(), item.getItemLabel(), item.getItemDescription(), item.isItemDisabled()));
                    continue;
                }
                if (value instanceof SelectItem) {
                    list.add((SelectItem)value);
                    continue;
                }
                valueClass = value != null ? "'" + value.getClass().getName() + "'" : "";
                throw new IllegalArgumentException(Messages.getMessage((String)"INVALID_ATTRIBUTE_VALUE", (Object)valueClass, (Object)"<selectItem>"));
            }
            if (!(kid instanceof UISelectItems) || null == context) continue;
            value = ((UISelectItems)kid).getValue();
            if (value instanceof SelectItem) {
                list.add((SelectItem)value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                SelectItem[] items = (SelectItem[])value;
                list.addAll(Arrays.asList(items));
                continue;
            }
            if (value instanceof Collection) {
                list.addAll((Collection)value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                Set entrySet = map.entrySet();
                for (Map.Entry entry : entrySet) {
                    list.add(new SelectItem(entry.getValue(), entry.getKey().toString(), null));
                }
                continue;
            }
            valueClass = value != null ? "'" + value.getClass().getName() + "'" : "";
            throw new IllegalArgumentException(Messages.getMessage((String)"INVALID_ATTRIBUTE_VALUE", (Object)valueClass, (Object)"<selectItems>"));
        }
        return list;
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany component, String[] submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue == null) {
            throw new NullPointerException("submittedValue");
        }
        ELContext elContext = facesContext.getELContext();
        ValueExpression vb = component.getValueExpression("value");
        Class valueType = null;
        Class<?> arrayComponentType = null;
        if (vb != null && (valueType = vb.getType(elContext)) != null && valueType.isArray()) {
            arrayComponentType = valueType.getComponentType();
        }
        if ((converter = component.getConverter()) == null) {
            if (valueType == null) {
                return submittedValue;
            }
            if (List.class.isAssignableFrom(valueType)) {
                List<String> lst = Arrays.asList(submittedValue);
                return lst;
            }
            if (arrayComponentType == null) {
                throw new IllegalArgumentException(Messages.getMessage((String)"VALUE_BINDING_TYPE_ERROR"));
            }
            if (String.class.equals(arrayComponentType)) {
                return submittedValue;
            }
            if (Object.class.equals(arrayComponentType)) {
                return submittedValue;
            }
            try {
                converter = facesContext.getApplication().createConverter(arrayComponentType);
            }
            catch (FacesException e) {
                log.error(Messages.getMessage((String)"NO_CONVERTER_FOUND_ERROR", (Object)arrayComponentType.getName()), (Throwable)e);
                return submittedValue;
            }
        }
        if (valueType == null) {
            int len = submittedValue.length;
            Object[] convertedValues = (Object[])Array.newInstance(arrayComponentType == null ? Object.class : arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                convertedValues[i] = converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]);
            }
            return convertedValues;
        }
        if (List.class.isAssignableFrom(valueType)) {
            int len = submittedValue.length;
            ArrayList<Object> lst = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                lst.add(converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
            }
            return lst;
        }
        if (arrayComponentType == null) {
            throw new IllegalArgumentException(Messages.getMessage((String)"VALUE_BINDING_TYPE_ERROR"));
        }
        if (arrayComponentType.isPrimitive()) {
            int len = submittedValue.length;
            Object convertedValues = Array.newInstance(arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(convertedValues, i, converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
            }
            return convertedValues;
        }
        int len = submittedValue.length;
        ArrayList<Object> convertedValues = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            convertedValues.add(i, converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]));
        }
        return convertedValues.toArray((Object[])Array.newInstance(arrayComponentType, len));
    }

    public static Object getConvertedUIInputValue(FacesContext facesContext, UIInput component, String submittedValue) throws ConverterException {
        Object convertedValue = null;
        if (InputUtils.EMPTY_STRING.equals(submittedValue)) {
            return null;
        }
        Converter converter = SelectUtils.getConverterForProperty(facesContext, (UIOutput)component, "value");
        convertedValue = converter != null ? converter.getAsObject(facesContext, (UIComponent)component, submittedValue) : submittedValue;
        return convertedValue;
    }

    public static Converter getConverterForProperty(FacesContext facesContext, UIOutput component, String property) {
        Class valueType;
        ValueExpression ve;
        Converter converter = component.getConverter();
        if (converter == null && (ve = component.getValueExpression(property)) != null && (valueType = ve.getType(facesContext.getELContext())) != null && !String.class.equals((Object)valueType) && !Object.class.equals((Object)valueType) && (converter = facesContext.getApplication().createConverter(valueType)) == null) {
            throw new ConverterException(Messages.getMessage((String)"NO_CONVERTER_FOUND_ERROR", (Object)valueType.getName()));
        }
        return converter;
    }
}

