/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.StateHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheManager;
import org.richfaces.context.AttributesContext;
import org.richfaces.context.SingletonsContext;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.CachedResourceImpl;
import org.richfaces.resource.DefaultResourceCodec;
import org.richfaces.resource.ResourceCodec;
import org.richfaces.resource.VersionedResource;
import org.richfaces.util.RequestStateManager;
import org.richfaces.util.Util;
import org.slf4j.Logger;

public class ResourceHandlerImpl
extends ResourceHandler {
    public static final String RICHFACES_RESOURCE_IDENTIFIER = "/rfRes/";
    public static final String HANDLER_START_TIME_ATTRIBUTE = ResourceHandlerImpl.class.getName() + ":StartTime";
    public static final String RESOURCE_CACHE_NAME = ResourceHandlerImpl.class.getName() + ":CACHE";
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private ResourceHandler defaultHandler;
    private Cache cache;
    private static final String RESOURCE_CODEC_ATTRIBUTE_NAME;

    public ResourceHandlerImpl(ResourceHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(MessageFormat.format("Instance of {0} resource handler created", ((Object)((Object)this)).getClass().getName()));
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.initializeCache(facesContext);
        this.markStartTime(facesContext);
    }

    private void initializeCache(FacesContext facesContext) {
        CacheManager cacheManager = CacheManager.getInstance();
        Map envMap = facesContext.getExternalContext().getInitParameterMap();
        cacheManager.createCache(RESOURCE_CACHE_NAME, envMap);
        this.cache = cacheManager.getCache(RESOURCE_CACHE_NAME);
    }

    private void markStartTime(FacesContext facesContext) {
        AttributesContext applicationContext = SingletonsContext.APPLICATION.get(facesContext);
        applicationContext.setAttribute(HANDLER_START_TIME_ATTRIBUTE, new Date());
    }

    protected static void setResourceCodec(ResourceCodec codec) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        ResourceCodec oldCodec = applicationMap.put(RESOURCE_CODEC_ATTRIBUTE_NAME, codec);
        if (oldCodec != null && codec != null && !oldCodec.equals(codec) && facesContext.isProjectStage(ProjectStage.Development)) {
            LOGGER.warn("Resource codec should be typically set once per application lifetime");
        }
    }

    public static ResourceCodec getResourceCodec(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        ResourceCodec resourceCodec = (ResourceCodec)applicationMap.get(RESOURCE_CODEC_ATTRIBUTE_NAME);
        if (resourceCodec == null) {
            resourceCodec = DefaultResourceCodec.getInstance();
        }
        return resourceCodec;
    }

    protected String getResourceKey(FacesContext context) {
        String resourceName = Util.decodeResourceURL(context);
        if (resourceName != null) {
            if (resourceName.startsWith(RICHFACES_RESOURCE_IDENTIFIER)) {
                return resourceName.substring(RICHFACES_RESOURCE_IDENTIFIER.length());
            }
            return null;
        }
        return null;
    }

    protected boolean isThisHandlerResourceRequest(FacesContext context) {
        Boolean resourceRequest = RequestStateManager.BooleanRequestStateVariable.RESOURCE_REQUEST.get(context);
        if (resourceRequest == null) {
            String resourceKey = this.getResourceKey(context);
            resourceRequest = resourceKey != null && resourceKey.length() > 0 ? Boolean.TRUE : Boolean.FALSE;
            RequestStateManager.BooleanRequestStateVariable.RESOURCE_REQUEST.set(context, resourceRequest);
            if (LOGGER.isDebugEnabled() && Boolean.TRUE.equals(resourceRequest)) {
                LOGGER.debug(MessageFormat.format("Resource request detected: {0}", resourceKey));
            }
        }
        return resourceRequest;
    }

    public boolean isResourceRequest(FacesContext context) {
        return this.isThisHandlerResourceRequest(context) || this.defaultHandler.isResourceRequest(context);
    }

    private Resource lookupInCache(FacesContext context, String resourceKey) {
        Resource resource = (Resource)this.cache.get((Object)resourceKey);
        if (LOGGER.isDebugEnabled()) {
            if (resource == null) {
                LOGGER.debug("Resource was not located in cache");
            } else {
                LOGGER.debug("Resource was located in cache");
            }
        }
        return resource;
    }

    private void sendNotModified(FacesContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("User agent has actual resource copy - sending 304 status code");
        }
        context.getExternalContext().setResponseStatus(304);
    }

    private void logResourceProblem(FacesContext context, Throwable throwable, String messagePattern, Object ... arguments) {
        boolean isProductionStage = context.isProjectStage(ProjectStage.Production);
        if (LOGGER.isWarnEnabled() || !isProductionStage && LOGGER.isInfoEnabled()) {
            String formattedMessage = MessageFormat.format(messagePattern, arguments);
            if (throwable != null) {
                LOGGER.warn(formattedMessage, throwable);
            } else if (isProductionStage) {
                LOGGER.info(formattedMessage);
            } else {
                LOGGER.warn(formattedMessage);
            }
        }
    }

    private void logMissingResource(FacesContext context, String resourceData) {
        this.logResourceProblem(context, null, "Resource {0} was not found", resourceData);
    }

    private void sendResourceNotFound(FacesContext context) {
        context.getExternalContext().setResponseStatus(404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext context) throws IOException {
        if (this.isThisHandlerResourceRequest(context)) {
            String resourceKey = this.getResourceKey(context);
            assert (resourceKey != null && resourceKey.length() != 0);
            Resource resource = this.lookupInCache(context, resourceKey);
            if (resource == null) {
                AbstractCacheableResource cacheableResource;
                ResourceCodec resourceCodec = ResourceHandlerImpl.getResourceCodec(context);
                String resourceName = resourceCodec.decodeResourceName(resourceKey);
                if (resourceName == null || resourceName.length() == 0) {
                    this.logMissingResource(context, resourceKey);
                    this.sendResourceNotFound(context);
                    return;
                }
                if (this.isResourceExists(resourceName)) {
                    resource = this.createHandlerDependentResource(resourceName);
                }
                if (resource == null) {
                    this.logMissingResource(context, resourceName);
                    this.sendResourceNotFound(context);
                    return;
                }
                if (resource instanceof VersionedResource) {
                    VersionedResource versionedResource = (VersionedResource)resource;
                    String existingVersion = versionedResource.getVersion();
                    String requestedVersion = resourceCodec.decodeResourceVersion(resourceKey);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(MessageFormat.format("Client requested {0} version of resource, server has {1} version", String.valueOf(requestedVersion), String.valueOf(existingVersion)));
                    }
                    if (existingVersion != null && requestedVersion != null && !existingVersion.equals(requestedVersion)) {
                        this.logResourceProblem(context, null, "Resource {0} of version {1} was not found", resourceName, requestedVersion);
                        this.sendResourceNotFound(context);
                        return;
                    }
                }
                if (resource instanceof StateHolder) {
                    StateHolder stateHolder = (StateHolder)resource;
                    Object decodedData = resourceCodec.decodeResourceData(resourceKey);
                    if (LOGGER.isDebugEnabled()) {
                        if (decodedData != null) {
                            LOGGER.debug("Resource state data succesfully decoded");
                        } else {
                            LOGGER.debug("Resource state data decoded as null");
                        }
                    }
                    if (decodedData != null) {
                        stateHolder.restoreState(context, decodedData);
                    }
                }
                if (resource instanceof AbstractCacheableResource && (cacheableResource = (AbstractCacheableResource)resource).isCacheable(context)) {
                    CachedResourceImpl cachedResource = new CachedResourceImpl();
                    cachedResource.initialize(resource);
                    resource = this.lookupInCache(context, resourceKey);
                    if (resource == null) {
                        Date cacheExpirationDate = cachedResource.getExpired(context);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(new MessageFormat("Storing {0} resource in cache until {1,date,dd MMM yyyy HH:mm:ss zzz}", Locale.US).format(new Object[]{resourceKey, cacheExpirationDate}));
                        }
                        this.cache.put((Object)resourceKey, (Object)cachedResource, cacheExpirationDate);
                        resource = cachedResource;
                    }
                }
            }
            if (resource.userAgentNeedsUpdate(context)) {
                HttpServletRequest httpServletRequest;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("User agent needs resource update, encoding resource");
                }
                ExternalContext externalContext = context.getExternalContext();
                Map headers = resource.getResponseHeaders();
                for (Map.Entry headerEntry : headers.entrySet()) {
                    String headerName = (String)headerEntry.getKey();
                    String headerValue = (String)headerEntry.getValue();
                    if ("content-length".equals(headerName.toLowerCase(Locale.US))) {
                        try {
                            externalContext.setResponseContentLength(Integer.parseInt(headerValue));
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    externalContext.setResponseHeader(headerName, headerValue);
                }
                String contentType = resource.getContentType();
                if (contentType != null) {
                    externalContext.setResponseContentType(contentType);
                }
                if (!"HEAD".equals((httpServletRequest = (HttpServletRequest)externalContext.getRequest()).getMethod())) {
                    InputStream is = resource.getInputStream();
                    OutputStream os = externalContext.getResponseOutputStream();
                    try {
                        Util.copyStreamContent(is, os);
                    }
                    finally {
                        block38: {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    if (!LOGGER.isDebugEnabled()) break block38;
                                    LOGGER.debug(e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resource succesfully encoded");
                }
            } else {
                this.sendNotModified(context);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Passing request to the next resource handler in chain");
            }
            this.defaultHandler.handleResourceRequest(context);
        }
    }

    protected boolean isResourceExists(String resourceName) {
        boolean result = false;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            URL resourceMarkerUrl = contextClassLoader.getResource("META-INF/" + resourceName + ".resource.properties");
            boolean bl = result = resourceMarkerUrl != null;
            if (LOGGER.isDebugEnabled()) {
                if (result) {
                    LOGGER.debug(MessageFormat.format("Marker file for {0} resource found in classpath", resourceName));
                } else {
                    LOGGER.debug(MessageFormat.format("Marker file for {0} resource does not exist", resourceName));
                }
            }
        }
        return result;
    }

    protected Resource createHandlerDependentResource(String resourceName) {
        Resource resource;
        block5: {
            resource = null;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                try {
                    Class<?> resourceClass = Class.forName(resourceName, false, contextClassLoader);
                    if (Resource.class.isAssignableFrom(resourceClass)) {
                        resource = (Resource)resourceClass.newInstance();
                        resource.setResourceName(resourceName);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(MessageFormat.format("Successfully created instance of {0} resource", resourceName));
                        }
                        break block5;
                    }
                    throw new ClassCastException(resourceClass.getName());
                }
                catch (Throwable t) {
                    this.logResourceProblem(FacesContext.getCurrentInstance(), t, "Error creating resource {0}", resourceName);
                }
            }
        }
        return resource;
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource result = null;
        result = resourceName != null && (libraryName == null || libraryName.length() == 0) && this.isResourceExists(resourceName) ? this.createHandlerDependentResource(resourceName) : this.defaultHandler.createResource(resourceName, libraryName, contentType);
        return result;
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public String getRendererTypeForResourceName(String resourceName) {
        return this.defaultHandler.getRendererTypeForResourceName(resourceName);
    }

    public boolean libraryExists(String libraryName) {
        return this.defaultHandler.libraryExists(libraryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Thread thread = Thread.currentThread();
        ClassLoader initialTCCL = thread.getContextClassLoader();
        try {
            ClassLoader systemCL = ClassLoader.getSystemClassLoader();
            thread.setContextClassLoader(systemCL);
            ImageIO.setUseCache(false);
        }
        finally {
            thread.setContextClassLoader(initialTCCL);
        }
        RESOURCE_CODEC_ATTRIBUTE_NAME = ResourceHandlerImpl.class.getName() + ":ResourceCodec";
    }
}

