/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.resource.ResourceContext;
import org.ajax4jsf.framework.resource.ResourceRenderer;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InternetResourceBase
implements InternetResource {
    private static final Log log = LogFactory.getLog((Class)InternetResourceBase.class);
    static final int BUFFER_SIZE = 1024;
    private int contentLength = -1;
    private Date lastModified;
    private Date expired;
    private boolean cacheable = true;
    private boolean sessionAware = true;
    private ResourceRenderer renderer = null;
    private Map customProperties = new HashMap();
    private String key;

    public int getContentLength(ResourceContext resourceContext) {
        return this.contentLength;
    }

    protected void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public Date getExpired(ResourceContext resourceContext) {
        return this.expired;
    }

    public void setExpired(Date expired) {
        this.expired = expired;
    }

    public Date getLastModified(ResourceContext resourceContext) {
        if (null != this.lastModified) {
            return this.lastModified;
        }
        return new Date(System.currentTimeMillis());
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isCacheable(ResourceContext resourceContext) {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public boolean isSessionAware() {
        return this.requireFacesContext();
    }

    public void setSessionAware(boolean sessionAware) {
        this.sessionAware = sessionAware;
    }

    public String getContentType(ResourceContext resourceContext) {
        return this.getRenderer(null).getContentType();
    }

    public ResourceRenderer getRenderer(ResourceContext resourceContext) {
        return this.renderer;
    }

    public void setRenderer(ResourceRenderer renderer) {
        this.renderer = renderer;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUri(FacesContext context, Object data) {
        return InternetResourceBuilder.getInstance().getUri(this, context, this.getDataToStore(context, data));
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        return this.getRenderer(null).getData(this, context, data);
    }

    protected Object restoreData(ResourceContext context) {
        Object data = context.getResourceData();
        if (data instanceof byte[]) {
            byte[] objectArray = (byte[])data;
            data = this.deserializeData(objectArray);
        }
        return data;
    }

    protected Object deserializeData(byte[] objectArray) {
        return objectArray;
    }

    public InputStream getResourceAsStream(ResourceContext context) {
        throw new UnsupportedOperationException(Messages.getMessage(Messages.METHOD_NOT_IMPLEMENTED, "getResourceAsStream"));
    }

    public Object getProperty(Object key) {
        return this.customProperties.get(key);
    }

    public void setProperty(Object key, Object value) {
        this.customProperties.put(key, value);
    }

    public void encode(FacesContext context, Object data) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.ENCODE_HTML_INFO, this.getKey()));
        }
        this.getRenderer(null).encode(this, context, data);
    }

    public void encode(FacesContext context, Object data, Map attributes) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.ENCODE_HTML_INFO_2, this.getKey(), attributes));
        }
        this.getRenderer(null).encodeBegin(this, context, data, attributes);
        this.getRenderer(null).encodeEnd(this, context, data);
    }

    public void encodeBegin(FacesContext context, Object component, Map attrs) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.ENCODE_BEGIN_HTML_INFO, this.getKey(), attrs));
        }
        this.getRenderer(null).encodeBegin(this, context, component, attrs);
    }

    public void encodeEnd(FacesContext context, Object component) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.ENCODE_END_HTML_INFO, this.getKey()));
        }
        this.getRenderer(null).encodeEnd(this, context, component);
    }

    public void send(ResourceContext context) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.SEND_CONTENT_INFO, this.getKey()));
        }
        int total = this.getRenderer(null).send(this, context);
        if (this.isCacheable(null)) {
            this.setContentLength(total);
        }
    }

    public void sendHeaders(ResourceContext context) {
        boolean cached;
        boolean bl = cached = context.isCacheEnabled() && this.isCacheable(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.SET_RESPONSE_HEADERS_INFO, this.getKey()));
        }
        context.setContentType(this.getContentType(null));
        if (this.getContentLength(context) > 0) {
            context.setIntHeader("Content-Length", this.getContentLength(context));
        }
        if (this.getLastModified(null) != null) {
            context.setDateHeader("Last-Modified", this.getLastModified(null).getTime());
        }
        if (cached) {
            Date expired = this.getExpired(context);
            if (expired != null) {
                context.setDateHeader("Expires", expired.getTime());
            } else {
                context.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
                context.setHeader("Cache-control", "max-age=86400");
            }
        } else {
            context.setHeader("Cache-control", "max-age=0, no-store, no-cache");
            context.setHeader("Pragma", "no-cache");
            context.setIntHeader("Expires", 0);
        }
    }

    public boolean requireFacesContext() {
        return this.getRenderer(null).requireFacesContext();
    }
}

