/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.ajax4jsf.ajax.resource.ResourceComponent;
import org.ajax4jsf.framework.resource.InternetResourceBase;
import org.ajax4jsf.framework.resource.ResourceContext;

public class UserResource
extends InternetResourceBase {
    private String contentType;

    public UserResource(boolean cacheable, boolean session, String mime) {
        this.setCacheable(cacheable);
        this.setSessionAware(session);
        this.setContentType(mime);
    }

    public String getContentType(ResourceContext resourceContext) {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Object getDataToStore(FacesContext context, Object data) {
        UriData dataToStore = null;
        if (data instanceof ResourceComponent) {
            ResourceComponent resource = (ResourceComponent)data;
            dataToStore = new UriData();
            dataToStore.value = resource.getValue();
            dataToStore.createContent = UIComponentBase.saveAttachedState((FacesContext)context, (Object)resource.getCreateContent());
            if (data instanceof UIComponent) {
                UIComponent component = (UIComponent)data;
                ValueBinding expires = component.getValueBinding("expires");
                if (null != expires) {
                    dataToStore.expires = UIComponentBase.saveAttachedState((FacesContext)context, (Object)expires);
                }
                ValueBinding lastModified = component.getValueBinding("lastModified");
                if (null != expires) {
                    dataToStore.modified = UIComponentBase.saveAttachedState((FacesContext)context, (Object)lastModified);
                }
            }
        }
        return dataToStore;
    }

    public void send(ResourceContext context) throws IOException {
        UriData data = (UriData)this.restoreData(context);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != data && null != facesContext) {
            ValueBinding binding;
            if (data.expires != null) {
                binding = (ValueBinding)UIComponentBase.restoreAttachedState((FacesContext)facesContext, (Object)data.expires);
                Date expires = (Date)binding.getValue(facesContext);
                context.setDateHeader("Expires", expires.getTime());
            }
            if (data.modified != null) {
                binding = (ValueBinding)UIComponentBase.restoreAttachedState((FacesContext)facesContext, (Object)data.modified);
                Date modified = (Date)binding.getValue(facesContext);
                context.setDateHeader("Last-Modified", modified.getTime());
            }
            OutputStream out = context.getOutputStream();
            MethodBinding send = (MethodBinding)UIComponentBase.restoreAttachedState((FacesContext)facesContext, (Object)data.createContent);
            send.invoke(facesContext, new Object[]{out, data.value});
        }
    }

    public boolean requireFacesContext() {
        return true;
    }

    public static class UriData
    implements Serializable {
        private static final long serialVersionUID = 1258987L;
        private Object value;
        private Object createContent;
        private Object expires;
        private Object modified;
    }
}

