/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Exceptions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.util.Transactions;
import org.jboss.seam.web.AbstractFilter;

@Startup
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.servlet.exceptionFilter")
@Install(precedence=0)
@Intercept(value=InterceptionType.NEVER)
public class ExceptionFilter
extends AbstractFilter {
    private static final LogProvider log = Logging.getLogProvider(ExceptionFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
            this.rollbackTransactionIfNecessary();
        }
        catch (Exception e) {
            log.error("uncaught exception", e);
            if (e instanceof ServletException) {
                log.error("exception root cause", ((ServletException)e).getRootCause());
            }
            this.rollbackTransactionIfNecessary();
            this.endWebRequestAfterException((HttpServletRequest)request, (HttpServletResponse)response, e);
        }
        finally {
            Lifecycle.setPhaseId(null);
        }
    }

    private void endWebRequestAfterException(HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException, IOException {
        log.debug("ending request");
        MockFacesContext facesContext = this.createFacesContext(request, response);
        facesContext.setCurrent();
        Lifecycle.beginExceptionRecovery(facesContext.getExternalContext());
        try {
            Exceptions.instance().handle(e);
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ehe) {
            throw new ServletException((Throwable)ehe);
        }
        finally {
            try {
                Lifecycle.endRequest(facesContext.getExternalContext());
                facesContext.release();
                log.debug("ended request");
            }
            catch (Exception ere) {
                log.error("could not destroy contexts", e);
            }
        }
    }

    private MockFacesContext createFacesContext(HttpServletRequest request, HttpServletResponse response) {
        return new MockFacesContext(new MockExternalContext(this.getServletContext(), request, response), new MockApplication());
    }

    private void rollbackTransactionIfNecessary() {
        try {
            if (Transactions.isTransactionActiveOrMarkedRollback()) {
                log.debug("killing transaction");
                Transactions.getUserTransaction().rollback();
            }
        }
        catch (Exception te) {
            log.error("could not roll back transaction", te);
        }
    }
}

