/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.graphicImage;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import org.jboss.seam.core.Image;
import org.jboss.seam.ui.HTML;
import org.jboss.seam.ui.JSF;
import org.jboss.seam.ui.graphicImage.DynamicImageStore;
import org.jboss.seam.ui.graphicImage.ImageTransform;

public class UIGraphicImage
extends HtmlGraphicImage {
    public static final String FAMILY = "org.jboss.seam.ui.UIGraphicImage";
    private String fileName;

    public String getFamily() {
        return FAMILY;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.fileName};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.fileName = (String)values[1];
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String key = this.getFileName();
        String extension = null;
        Image image = Image.instance();
        image.setInput(this.getValue());
        for (UIComponent cmp : this.getChildren()) {
            if (!(cmp instanceof ImageTransform)) continue;
            ImageTransform imageTransform = (ImageTransform)cmp;
            imageTransform.applyTransform(image, this);
        }
        key = DynamicImageStore.instance().put(new DynamicImageStore.ImageWrapper(image.getImage(), image.getContentType()), key);
        extension = image.getContentType().getExtension();
        writer.startElement("img", (UIComponent)this);
        String url = context.getExternalContext().getRequestContextPath() + "/seam/resource/dynamicImage" + "/" + key + extension;
        writer.writeAttribute("src", (Object)url, "src");
        HTML.renderHTMLAttributes(writer, (UIComponent)this, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        writer.endElement("img");
    }

    public String getFileName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        ValueBinding vb = this.getValueBinding("fileName");
        return vb == null ? null : JSF.getStringValue(this.getFacesContext(), vb);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected Renderer getRenderer(FacesContext context) {
        return null;
    }

    public boolean getRendersChildren() {
        return true;
    }
}

