/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreViewPhase
extends Phase {
    private static final String WEBAPP_ERROR_PAGE_MARKER = "javax.servlet.error.message";
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private WebConfiguration webConfig;

    @Override
    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    @Override
    public void doPhase(FacesContext context, Lifecycle lifecycle, ListIterator<PhaseListener> listeners) {
        Util.getViewHandler((FacesContext)context).initView(context);
        super.doPhase(context, lifecycle, listeners);
    }

    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        boolean isPostBack;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RestoreViewPhase");
        }
        if (null == facesContext) {
            throw new FacesException(MessageUtils.getExceptionMessageString((String)"com.sun.faces.NULL_CONTEXT_ERROR", (Object[])new Object[0]));
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a pre created view in FacesContext");
            }
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            UIViewRoot root = facesContext.getViewRoot();
            final PostRestoreStateEvent event = new PostRestoreStateEvent((UIComponent)root);
            try {
                root.visitTree(VisitContext.createVisitContext((FacesContext)facesContext), new VisitCallback(){

                    public VisitResult visit(VisitContext context, UIComponent target) {
                        event.setComponent(target);
                        target.processEvent((ComponentSystemEvent)event);
                        return VisitResult.ACCEPT;
                    }
                });
            }
            catch (AbortProcessingException e) {
                facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)new ExceptionQueuedEventContext(facesContext, (Throwable)e));
            }
            if (!facesContext.isPostback()) {
                facesContext.renderResponse();
            }
            return;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String viewId = (String)requestMap.get("javax.servlet.include.path_info");
        if (viewId == null) {
            viewId = facesContext.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null) {
            viewId = facesContext.getExternalContext().getRequestServletPath();
        }
        if (viewId == null) {
            throw new FacesException(MessageUtils.getExceptionMessageString((String)"com.sun.faces.NULL_REQUEST_VIEW_ERROR", (Object[])new Object[0]));
        }
        ViewHandler viewHandler = Util.getViewHandler((FacesContext)facesContext);
        boolean bl = isPostBack = facesContext.isPostback() && !RestoreViewPhase.isErrorPage(facesContext);
        if (isPostBack) {
            facesContext.setProcessingEvents(false);
            viewRoot = viewHandler.restoreView(facesContext, viewId);
            if (viewRoot == null) {
                if (this.is11CompatEnabled(facesContext)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Postback: recreating a view for " + viewId);
                    }
                    viewRoot = viewHandler.createView(facesContext, viewId);
                    facesContext.renderResponse();
                } else {
                    Object[] params = new Object[]{viewId};
                    throw new ViewExpiredException(MessageUtils.getExceptionMessageString((String)"com.sun.faces.RESTORE_VIEW_ERROR", (Object[])params), viewId);
                }
            }
            facesContext.setViewRoot(viewRoot);
            facesContext.setProcessingEvents(true);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Postback: restored view for " + viewId);
            }
        } else {
            ViewDeclarationLanguage vdl;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("New request: creating a view for " + viewId);
            }
            if ((vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId)) != null) {
                Collection params;
                ViewMetadata metadata = vdl.getViewMetadata(facesContext, viewId);
                if (metadata != null && (params = ViewMetadata.getViewParameters((UIViewRoot)(viewRoot = metadata.createMetadataView(facesContext)))).isEmpty()) {
                    facesContext.renderResponse();
                }
            } else {
                facesContext.renderResponse();
            }
            if (null == viewRoot) {
                viewRoot = Util.getViewHandler((FacesContext)facesContext).createView(facesContext, viewId);
            }
            facesContext.setViewRoot(viewRoot);
            assert (null != viewRoot);
            facesContext.getApplication().publishEvent(facesContext, PostAddToViewEvent.class, (Object)viewRoot);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RestoreViewPhase");
        }
    }

    private static boolean isErrorPage(FacesContext context) {
        return context.getExternalContext().getRequestMap().get(WEBAPP_ERROR_PAGE_MARKER) != null;
    }

    private WebConfiguration getWebConfig(FacesContext context) {
        if (this.webConfig == null) {
            this.webConfig = WebConfiguration.getInstance(context.getExternalContext());
        }
        return this.webConfig;
    }

    private boolean is11CompatEnabled(FacesContext context) {
        return this.getWebConfig(context).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableRestoreView11Compatibility);
    }
}

