if (!window.DW) {
	window.DW = {};
}

if (!window.Richfaces) {
	window.Richfaces = {};
}

sizeA = 4;
sizeB = 40;

ModalPanel = Class.create();

{
	var searchString = "MSIE";
	var agent = navigator.userAgent;
	var idx = agent.indexOf(searchString);
	if (idx != -1) {
		var versIdx = agent.indexOf(";", idx);
		var versString;
		
		if (versIdx != -1) {
			versString = agent.substring(idx + searchString.length, versIdx);
		} else {
			versString = agent.substring(idx + searchString.length);
		}
	
		if (parseFloat(versString) < 7) {
			ModalPanel.disableSelects = true;
		}
	}
}

ModalPanel.Context = Class.create();
ModalPanel.Context.prototype = {
	initialize: function(modalPanel) {
		this.cdiv = modalPanel.cdiv;
		this.isPositionFixed = Richfaces.getComputedStyle(this.cdiv, "position") == "fixed";
	},
	
	left: function(offset) {
		return offset;
	}, 

	top: function(offset) {
		return offset;
	},
	
	width: function() {
		return this.cdiv.offsetWidth;
	},
	
	height: function() {
		return this.cdiv.offsetHeight;
	}
}

	function getSizeElement() {
		var element;
		if (document.compatMode=='CSS1Compat') {
			element = document.documentElement;
		} else {
			element = document.body; 
		}

		return element;
	}


ModalPanel.prototype = {
	initialize: function(id, options) {
		this.id = $(id);
		
		this.options = options;
		
		this.baseZIndex = this.options.zindex ? this.options.zindex : 100;
		
		this.minWidth = Math.max(this.options.minWidth, 2*sizeA + 2);  
		this.minHeight = Math.max(this.options.minHeight, 2*sizeA + 2);  
		
		this.div = $(id + "Div");
		this.cursorDiv = $(id + "CursorDiv");
		this.iframe = $(id + "IFrame");
		this.cdiv = $(id + "CDiv");
		
		this.context = new ModalPanel.Context(this);
		
		this.iframe.onload = this.initIframe.bind(this.iframe);

		this.borders = new Array();

		if (this.options.resizeable) {
			this.borders.push(new ModalPanel.Border(id + "ResizerNWU", this, "NW-resize", ModalPanel.Sizer.NWU));
			this.borders.push(new ModalPanel.Border(id + "ResizerN", this, "N-resize", ModalPanel.Sizer.N));
			this.borders.push(new ModalPanel.Border(id + "ResizerNEU", this, "NE-resize", ModalPanel.Sizer.NEU));
			this.borders.push(new ModalPanel.Border(id + "ResizerNEL", this, "NE-resize", ModalPanel.Sizer.NEL));
			this.borders.push(new ModalPanel.Border(id + "ResizerE", this, "E-resize", ModalPanel.Sizer.E));
			this.borders.push(new ModalPanel.Border(id + "ResizerSEU", this, "SE-resize", ModalPanel.Sizer.SEU));
			this.borders.push(new ModalPanel.Border(id + "ResizerSEL", this, "SE-resize", ModalPanel.Sizer.SEL));
			this.borders.push(new ModalPanel.Border(id + "ResizerS", this, "S-resize", ModalPanel.Sizer.S));
			this.borders.push(new ModalPanel.Border(id + "ResizerSWL", this, "SW-resize", ModalPanel.Sizer.SWL));
			this.borders.push(new ModalPanel.Border(id + "ResizerSWU", this, "SW-resize", ModalPanel.Sizer.SWU));
			this.borders.push(new ModalPanel.Border(id + "ResizerW", this, "W-resize", ModalPanel.Sizer.W));
			this.borders.push(new ModalPanel.Border(id + "ResizerNWL", this, "NW-resize", ModalPanel.Sizer.NWL));
		}
		
		if (this.options.moveable && $(id + "Header")) {
			this.header = new ModalPanel.Border(id + "Header", this, "move", ModalPanel.Header);
		}
			
		this.id.modalPanel = this;

		if (this.div.style.setExpression) 
			if (ModalPanel.disableSelects /* IE 6 */ || Richfaces.getComputedStyle(this.div, "position") != "fixed" /* IE again, not in strict mode*/)
		
		{
			this.div.style.position = "absolute";
			this.cursorDiv.style.position = "absolute";

			//that is to apply filter
			this.div.style.width = "1px";
			this.div.style.height = "1px";
			this.cursorDiv.style.width = "1px";
			this.cursorDiv.style.height = "1px";


			//this.iframe.style.position = "absolute";
			this.cdiv.style.position = "absolute";

			this.cdiv.mpUseExpr = true;
		}
	},

	initIframe : function() {
		if (this.contentWindow) {
			Element.setStyle(this.contentWindow.document.body, { "margin" : "0px 0px 0px 0px" });
		} else {
			//TODO opera etc.
			
		}
		
		if("transparent" == Element.getStyle(document.body, "background-color")) {
			this.allowTransparency = true;
		}

		//this.style.opacity = "0.5";
		//this.style.filter='progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=50)';
		//var iframeBodyStyle = this.contentWindow.document.body.style;
		//iframeBodyStyle.backgroundColor = "#d0d0d0";
		//iframeBodyStyle.filter = "alpha(opacity=50)";
		//iframeBodyStyle.opacity = "0.5";
		//iframeBodyStyle.zIndex = "99";
	},
	
	traverseSelects: function(enable) {
		if (!ModalPanel.disableSelects) {
			return ;
		}
		
		var selects = document.getElementsByTagName("SELECT");
		
		for (var i = 0; i < selects.length; i++) {
			var elt = selects[i];
			
			if (enable) {
				if (elt._mdwDisabled) {
					elt._mdwDisabled = undefined;
				} else {
					elt.disabled = false;				
				}
			} else {
				if (elt.disabled) {
					elt._mdwDisabled = true;
				} else {
					elt.disabled = true;
				}
			}
		}
	},

	setLeft: function(pos) {
		if (this.cdiv.mpUseExpr) {
			this.cdiv.mpLeft = pos;
		} else {
			this.cdiv.style.left = pos + "px";
		}
	},
	
	setTop: function(pos) {
		if (this.cdiv.mpUseExpr) {
			this.cdiv.mpTop = pos;
		} else {
			this.cdiv.style.top = pos + "px";
		}
	},

	show: function(opts) {
		var options = {};
		
		if (!this.cdiv.mpSet) {
			Object.extend(options, this.options);
		}

		if (opts) {
			Object.extend(options, opts);
		} 
		
		if (options.width) {
			if (this.minWidth > options.width) {
				options.width = this.minWidth;
			}

			this.cdiv.style.width = options.width + 'px';
		}

		if (options.height) {
			if (this.minHeight > options.height) {
				options.height = this.minHeight; 
			}

			this.cdiv.style.height = options.height + 'px';
		}

		if (options.left) {
			var _left;
			if (options.left != "auto") {
				_left = parseInt(options.left, 10);
			} else {
				var cw = getSizeElement().clientWidth;
				if (RichFaces.navigatorType() == "OPERA")
				 	_left = (cw - this.cdiv.style.width.replace("px", "")) / 2;
				 else
					_left = (cw - Richfaces.getComputedStyleSize(this.cdiv, "width")) / 2;

			}

			this.setLeft(_left);
		}
		
		if (options.top) {
			var _top;
			if (options.top != "auto") {
				_top = parseInt(options.top, 10);
			} else {
				var cw = getSizeElement().clientHeight;
				_top = (cw - Richfaces.getComputedStyleSize(this.cdiv, "height")) / 2;
			}
			
			this.setTop(_top);
		}

		this.cdiv.mpSet = true;
		
		//Element.setStyle(this.dialogWindow.document.body, { "margin" : "0px 0px 0px 0px" });
		//if("transparent" == Element.getStyle(document.body, "background-color")) {
		//	this.iframe.allowTransparency = true;
		//}
		

		this.traverseSelects();

		//this.shape.init(this.cdiv, this.options);

		if (this.div.style.position == "absolute") 
		{
			//IE workaround implemented here - sometimes IE uses client (0,0) as left top corner of window, sometimes (2,2)
			//this behaviour differs between 6-th and 7-th version in the same mode, so we add extra pixels to width & height 
			//and then move DIV to left and top to prevent scroll bars as DIV is larger than client area
			var we = "getSizeElement().clientWidth + /**/ getSizeElement().clientLeft + /**/\"px\"";
			var he = "getSizeElement().clientHeight + /**/ getSizeElement().clientTop + /**/\"px\"";
			this.div.style.setExpression("width", we);
			this.div.style.setExpression("height", he);

			this.cursorDiv.style.setExpression("width", we);
			this.cursorDiv.style.setExpression("height", he);

			var le = "-Position.cumulativeOffset(this.parentNode)[0] + getSizeElement().scrollLeft /* + getSizeElement().clientLeft - getSizeElement().clientLeft*/ + \"px\"";
			var te = "-Position.cumulativeOffset(this.parentNode)[1] + getSizeElement().scrollTop /* + getSizeElement().clientTop - getSizeElement().clientTop*/ + \"px\"";
			
			this.div.style.setExpression("left", le);
			this.div.style.setExpression("top", te);

			this.cursorDiv.style.setExpression("left", le);
			this.cursorDiv.style.setExpression("top", te);


			var leftExpr = "(this.mpLeft || 0) + -Position.cumulativeOffset(this.parentNode)[0] + getSizeElement().scrollLeft + getSizeElement().clientLeft + \"px\"";
			var topExpr = "(this.mpTop || 0) + -Position.cumulativeOffset(this.parentNode)[1] + getSizeElement().scrollTop + getSizeElement().clientTop + \"px\"";

			//this.iframe.style.setExpression("left", leftExpr);
			//this.iframe.style.setExpression("top", topExpr);

			this.cdiv.style.setExpression("left", leftExpr);
			this.cdiv.style.setExpression("top", topExpr);

			
			/* That's how we output debug info - DOM inspector rulez */
			/*
			document.body.setExpression("_clientLeft", "getSizeElement().clientLeft");
			document.body.setExpression("_clientTop", "getSizeElement().clientTop");
			document.body.setExpression("_scrollLeft", "getSizeElement().scrollLeft");
			document.body.setExpression("_scrollTop", "getSizeElement().scrollTop");
			*/
			/* */
		}

		this.id.style.visibility = "hidden";

		Element.show(this.id);

		for (var k = 0; k < this.borders.length; k++ ) {
			this.borders[k].doPosition();
		}
		
		if (this.header) {
			this.header.doPosition();
		}
		
		this.id.style.visibility = "";
	},
	
	startDrag: function(border) {
		for (var k = 0; k < this.borders.length; k++ ) {
			//this.borders[k].hide();
		}
	},

	endDrag: function(border) {
		for (var k = 0; k < this.borders.length; k++ ) {
			//this.borders[k].show();
			this.borders[k].doPosition();
		}
	},
	
	hide: function() {
		this.traverseSelects(true);

		if (this.div.style.removeExpression) {
			this.div.style.removeExpression("width");
			this.div.style.removeExpression("height");

			this.div.style.removeExpression("left");
			this.div.style.removeExpression("top");

			this.cursorDiv.style.removeExpression("width");
			this.cursorDiv.style.removeExpression("height");

			this.cursorDiv.style.removeExpression("left");
			this.cursorDiv.style.removeExpression("top");

			//this.iframe.style.removeExpression("left");
			//this.iframe.style.removeExpression("top");

			this.cdiv.style.removeExpression("left");
			this.cdiv.style.removeExpression("top");
		}

		Element.hide(this.id);
	},
	
	doResizeOrMove: function(diff) {
		var vetoes = {};
		var cssHash = {};
		
		var vetoeChange = false;
		var newSize = Richfaces.getComputedStyleSize(this.cdiv, "width");
		
		var oldSize = newSize;
		newSize += diff.deltaWidth || 0;
		
		if (newSize >= this.minWidth) {
			if (diff.deltaWidth) {
				cssHash.width = newSize + 'px';
			}
		} else {
			if (diff.deltaWidth) {
				cssHash.width = this.minWidth + 'px';
			
				vetoes.vx = oldSize - this.minWidth;
			}
			
			vetoes.x = true;
		}

		if (vetoes.vx && diff.deltaX) {
			diff.deltaX = -vetoes.vx;
		}
					
		if (diff.deltaX && (vetoes.vx || !vetoes.x)) {
			if (vetoes.vx) {
				diff.deltaX = vetoes.vx;
			}
			var newPos;
			if (this.cdiv.mpUseExpr) {
				newPos = this.cdiv.mpLeft || 0;
				newPos += diff.deltaX;
				
				this.cdiv.mpLeft = newPos;
				//this.iframe.mpLeft = newPos;
			} else {
				newPos = Richfaces.getComputedStyleSize(this.cdiv, "left");
				newPos += diff.deltaX;
				cssHash.left = newPos + 'px';
			}
		}			

		var newSize = Richfaces.getComputedStyleSize(this.cdiv, "height");
		var oldSize = newSize;
		newSize += diff.deltaHeight || 0;
			
		if (newSize >= this.minHeight) {
			if (diff.deltaHeight) {
				cssHash.height = newSize + 'px';
			}
		} else {
			if (diff.deltaHeight) {
				cssHash.height = this.minHeight + 'px';

				vetoes.vy = oldSize - this.minHeight;
			}
			
			vetoes.y = true;
		}

		if (vetoes.vy && diff.deltaY) {
			diff.deltaY = -vetoes.vy;
		}
					
		if (diff.deltaY && (vetoes.vy || !vetoes.y)) {
			if (vetoes.vy) {
				diff.deltaY = vetoes.vy;
			}

			var newPos;
			if (this.cdiv.mpUseExpr) {
				newPos = this.cdiv.mpTop || 0;
				newPos += diff.deltaY;
				
				this.cdiv.mpTop = newPos;
				//this.iframe.mpTop = newPos;
			} else {
				newPos = Richfaces.getComputedStyleSize(this.cdiv, "top");
				newPos += diff.deltaY;
				cssHash.top = newPos + 'px';
			}
		}			

		Element.setStyle(this.cdiv, cssHash);	
		//Element.setStyle(this.iframe, cssHash);	

		var w = this.cdiv.offsetWidth;
		var h = this.cdiv.offsetHeight;

		this.context.reduced = null;

		if (w <= 2*sizeB) {
			this.context.reduced = {};
			this.context.reduced.w = w;
		}

		if (h <= 2*sizeB) {
			if (!this.context.reduced) {
				this.context.reduced = {};
			}
			
			this.context.reduced.h = h;
		}

		if (this.header) {
			this.header.doPosition();
		}

		return vetoes;
	}
}

Richfaces.showModalPanel = function (id, opts) {
	var panel = $(id);
	if (panel && panel.modalPanel)
		panel.modalPanel.show(opts);
}

Richfaces.hideModalPanel = function (id) {
	var panel = $(id);
	if (panel && panel.modalPanel)
		panel.modalPanel.hide();
}
