package org.jboss.eap.util.xp.patch.stream.manager;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class StatusManagerAction extends ManagerAction {
    public StatusManagerAction(ManagerStatus status) {
        super(status, false);
    }

    @Override
    public ManagerState getToManagerState() {
        return null;
    }

    @Override
    public ManagerCommand getCommand() {
        return ManagerCommand.STATUS;
    }

    @Override
    public void doExecute() throws Exception {
        switch (status.getManagerState()) {
            case CLEAN:
                System.out.println(ManagerLogger.LOGGER.installationStatusClean());
                break;
            case INCONSISTENT:
                System.out.println(ManagerLogger.LOGGER.installationStatusInconsistent());
                break;
            case INSTALLED:
                System.out.println(ManagerLogger.LOGGER.installationStatusInstalled(ManagerLogger.LOGGER.xpSupportPolicy()));
                break;
        }
        System.out.println();
        System.out.println(ManagerLogger.LOGGER.installationStatusAvailableCommands(status.getAvailableCommands()));
    }
}
