package org.jboss.eap.util.xp.patch.stream.manager;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class ManagerPatchApplyAction extends ManagerAction {
    private final Path patch;
    private final ServerWrapper serverWrapper;

    public ManagerPatchApplyAction(ManagerStatus managerStatus, ServerWrapper serverWrapper, Path patch) {
        super(ManagerCommand.PATCH_APPLY, managerStatus, null, true);
        this.patch = patch;
        this.serverWrapper = serverWrapper;
    }

    @Override
    void doExecute() throws Exception {
        PatchXml.Validator xml = PatchXml.parse(PatchXml.findPatchXmlInZip(patch));
        if (xml.isXpPatch()) {
            String patchStream = xml.getPatchStreamName();
            if (status.getManagerState() != ManagerState.INSTALLED) {
                throw ManagerLogger.LOGGER.patchApplyForXPPatchCanOnlyBeAppliedOncePatchStreamIsEnabled(patchStream);
            }
            ManagerManifestConfig.XPConfig config = ManagerManifestConfig.INSTANCE.getCurrentXpConfig();
            Set<String> currentStreams = new HashSet<>(config.getPatchStreamNames());
            if (!currentStreams.contains(patchStream)) {
                throw ManagerLogger.LOGGER.patchApplyForWrongXPPatchStream(patchStream, config.getPatchStreamNames());
            }
        }

        try {
            serverWrapper.start();
            serverWrapper.applyPatch(patch);
        } finally {
            serverWrapper.stop();
        }
    }
}
