package org.jboss.eap.util.xp.patch.stream.manager;

import java.nio.file.Path;
import java.util.List;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class RemoveManagerAction extends ManagerAction {
    private final List<FileSet> removeFileSets;
    private final Path jbossHome;
    private final ServerWrapper serverWrapper;

    private RemoveManagerAction(ManagerStatus status, ServerWrapper serverWrapper, boolean supportPolicyAccepted, List<FileSet> removeFileSets, Path jbossHome) {
        super(ManagerCommand.REMOVE, status, ManagerState.CLEAN, supportPolicyAccepted);
        this.removeFileSets = removeFileSets;
        this.jbossHome = jbossHome;
        if (status.getManagerState() == ManagerState.INSTALLED) {
            this.serverWrapper = serverWrapper;
        } else {
            this.serverWrapper = null;
        }
    }

    static RemoveManagerAction create(ManagerStatus status, ServerWrapper serverWrapper, boolean supportPolicyAccepted, Path jbossHome) {
        return new RemoveManagerAction(status, serverWrapper, supportPolicyAccepted, status.getFileSet(), jbossHome);
    }

    @Override
    void doExecute() throws Exception {
        RemoveUtils removeUtils = new RemoveUtils(serverWrapper, jbossHome);
        ManagerState state = status.getManagerState();
        try {
            if (status.getManagerState() == ManagerState.INSTALLED) {
                // Only do the 'proper' rolling back of patches when we are removing an install
                removeUtils.rollbackPatchStreamPatches(removeFileSets);
            }
        } catch (Exception e) {
            System.err.println(ManagerLogger.LOGGER.errorRemovingPatches());
            e.printStackTrace();
        }
        removeUtils.removeFiles(removeFileSets);
        if (state != ManagerState.OLD_INSTALLED) {
            System.out.println(ManagerLogger.LOGGER.successfullyRemovedExpansionPack());
        } else {
            System.out.println(ManagerLogger.LOGGER.successfullyRemovedBackedUpFiles());
        }
    }
}
