package org.jboss.eap.util.xp.patch.stream.manager;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
enum ManagerCommand {
    HELP("help", true),
    STATUS("status", true),
    SETUP("setup", false),
    REMOVE("remove", false),
    UPGRADE("upgrade", false),
    PATCH_APPLY("patch-apply", false);

    private final String name;
    private final boolean alwaysAvailable;

    ManagerCommand(String name, boolean alwaysAvailable) {
        this.name = name;
        this.alwaysAvailable = alwaysAvailable;
    }

    boolean isAlwaysAvailable() {
        return  alwaysAvailable;
    }

    public String toString() {
        return name;
    }

    static ManagerCommand fromString(String cmd) {
        return Enum.valueOf(ManagerCommand.class, cmd.toUpperCase().replace("-", "_"));
    }
}
