/*
 * Copyright The WildFly Authors
 * SPDX-License-Identifier: Apache-2.0
 */
package org.wildfly.test.integration.observability.setuptask;

import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.as.test.shared.observability.setuptasks.AbstractSetupTask;
import org.jboss.dmr.ModelNode;

public class PrometheusSetupTask extends AbstractSetupTask {
    public static final String PROMETHEUS_CONTEXT = "/prometheus";
    public static final ModelNode SYSPROP_PROMETHEUS_CONTEXT = Operations.createAddress("system-property", "org.jboss.eap.xp.micrometer.prometheus.context");
    public static final ModelNode SYSPROP_SECURITY_ENABLED = Operations.createAddress("system-property", "org.jboss.eap.xp.micrometer.prometheus.security-enabled");


    @Override
    public void setup(final ManagementClient managementClient, String containerId) throws Exception {

        ModelNode addOp = Operations.createAddOperation(SYSPROP_PROMETHEUS_CONTEXT);
        addOp.get("value").set(PROMETHEUS_CONTEXT);
        executeOp(managementClient, addOp);

        addOp = Operations.createAddOperation(SYSPROP_SECURITY_ENABLED);
        addOp.get("value").set("false");
        executeOp(managementClient, addOp);

        ServerReload.executeReloadAndWaitForCompletion(managementClient);
    }

    @Override
    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        if (Operations.isSuccessfulOutcome(executeRead(managementClient, SYSPROP_PROMETHEUS_CONTEXT))) {
            executeOp(managementClient, Operations.createRemoveOperation(SYSPROP_PROMETHEUS_CONTEXT));
        }
        if (Operations.isSuccessfulOutcome(executeRead(managementClient, SYSPROP_SECURITY_ENABLED))) {
            executeOp(managementClient, Operations.createRemoveOperation(SYSPROP_SECURITY_ENABLED));
        }

        ServerReload.executeReloadAndWaitForCompletion(managementClient);
    }
}
