/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.MarshalException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.socket.OpenConnectionChecker;
import org.jboss.remoting.transport.socket.ServerAddress;
import org.jboss.remoting.transport.socket.SocketWrapper;
import org.jboss.util.propertyeditor.PropertyEditors;

public class MicroSocketClientInvoker
extends RemoteClientInvoker {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$socket$MicroSocketClientInvoker == null ? (class$org$jboss$remoting$transport$socket$MicroSocketClientInvoker = MicroSocketClientInvoker.class$("org.jboss.remoting.transport.socket.MicroSocketClientInvoker")) : class$org$jboss$remoting$transport$socket$MicroSocketClientInvoker));
    public static final String TCP_NODELAY_FLAG = "enableTcpNoDelay";
    public static final String MAX_POOL_SIZE_FLAG = "clientMaxPoolSize";
    public static final String CLIENT_SOCKET_CLASS_FLAG = "clientSocketClass";
    public static final boolean TCP_NODELAY_DEFAULT = false;
    public static final int MAX_RETRIES = 30;
    public static final int MAX_CALL_RETRIES = 3;
    public static final int MAX_POOL_SIZE = 50;
    private static boolean trace = log.isTraceEnabled();
    static int counter = 0;
    protected static final Map connectionPools = new HashMap();
    public static long getSocketTime = 0L;
    public static long readTime = 0L;
    public static long writeTime = 0L;
    public static long serializeTime = 0L;
    public static long deserializeTime = 0L;
    private Constructor clientSocketConstructor = null;
    private boolean reuseAddress = true;
    protected InetAddress addr;
    protected int port;
    private volatile boolean bailOut;
    protected boolean shouldCheckConnection = false;
    protected boolean enableTcpNoDelay = false;
    protected String clientSocketClassName = (class$org$jboss$remoting$transport$socket$ClientSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ClientSocketWrapper = MicroSocketClientInvoker.class$("org.jboss.remoting.transport.socket.ClientSocketWrapper")) : class$org$jboss$remoting$transport$socket$ClientSocketWrapper).getName();
    protected Class clientSocketClass = null;
    protected int numberOfRetries = 30;
    protected int numberOfCallRetries = 3;
    protected int maxPoolSize = 50;
    protected LinkedList pool = null;
    protected ServerAddress address;
    public long usedPooled = 0L;
    public Object usedPoolLock = new Object();
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$MicroSocketClientInvoker;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ClientSocketWrapper;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool(ServerAddress sa) {
        try {
            LinkedList thepool = (LinkedList)connectionPools.get(sa);
            if (thepool == null) {
                return;
            }
            LinkedList linkedList = thepool;
            synchronized (linkedList) {
                int size = thepool.size();
                for (int i = 0; i < size; ++i) {
                    SocketWrapper socketWrapper = (SocketWrapper)thepool.removeFirst();
                    try {
                        socketWrapper.close();
                        socketWrapper = null;
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception ex) {
            log.debug((Object)"Failure", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPools() {
        Map map = connectionPools;
        synchronized (map) {
            Iterator i = connectionPools.keySet().iterator();
            while (i.hasNext()) {
                ServerAddress sa = (ServerAddress)i.next();
                if (trace) {
                    log.trace((Object)("clearing pool for " + sa));
                }
                MicroSocketClientInvoker.clearPool(sa);
                i.remove();
            }
        }
    }

    public MicroSocketClientInvoker(InvokerLocator locator) {
        this(locator, null);
    }

    public MicroSocketClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        try {
            this.setup();
        }
        catch (Exception ex) {
            log.error((Object)("Error setting up " + this), (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
        log.debug((Object)(this + " constructed"));
    }

    public boolean checkingConnection() {
        return this.shouldCheckConnection;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuse) {
        this.reuseAddress = reuse;
    }

    public synchronized void disconnect() {
        log.debug((Object)(this + " disconnecting ..."));
        this.bailOut = true;
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flushConnectionPool() {
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            while (this.pool != null) {
                if (this.pool.size() <= 0) return;
                SocketWrapper socketWrapper = (SocketWrapper)this.pool.removeFirst();
                try {
                    socketWrapper.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Failed to close socket wrapper", (Throwable)e);
                }
            }
            return;
        }
    }

    public void setNumberOfCallRetries(int numberOfCallRetries) {
        this.numberOfCallRetries = numberOfCallRetries < 1 ? 3 : numberOfCallRetries;
    }

    public int getNumberOfCallRetries() {
        return this.numberOfCallRetries;
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries < 1 ? 30 : numberOfRetries;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public String getServerHostName() throws Exception {
        return this.address.address;
    }

    protected void setup() throws Exception {
        this.addr = InetAddress.getByName(this.locator.getHost());
        this.port = this.locator.getPort();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.configuration);
        PropertyEditors.mapJavaBeanProperties((Object)this, (Properties)props, (boolean)false);
        this.configureParameters();
        this.address = this.createServerAddress();
    }

    protected void configureParameters() {
        String value;
        Map params = this.configuration;
        if (params == null) {
            return;
        }
        Object val = params.get(TCP_NODELAY_FLAG);
        if (val != null) {
            try {
                this.enableTcpNoDelay = Boolean.valueOf((String)val);
                log.debug((Object)(this + " setting enableTcpNoDelay to " + this.enableTcpNoDelay));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + TCP_NODELAY_FLAG + " value of " + val + " to a boolean value."));
            }
        }
        if ((val = params.get(MAX_POOL_SIZE_FLAG)) != null) {
            try {
                this.maxPoolSize = Integer.valueOf((String)val);
                log.debug((Object)(this + " setting maxPoolSize to " + this.maxPoolSize));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + MAX_POOL_SIZE_FLAG + " value of " + val + " to a int value"));
            }
        }
        if ((val = params.get(CLIENT_SOCKET_CLASS_FLAG)) != null && (value = (String)val).length() > 0) {
            this.clientSocketClassName = value;
            log.debug((Object)(this + " setting client socket wrapper class name to " + this.clientSocketClassName));
        }
        if ((val = params.get("socket.check_connection")) != null && ((String)val).length() > 0) {
            value = (String)val;
            this.shouldCheckConnection = Boolean.valueOf(value);
            log.debug((Object)(this + " setting shouldCheckConnection to " + this.shouldCheckConnection));
        } else if (Version.getDefaultVersion() == 1) {
            this.shouldCheckConnection = true;
            log.debug((Object)(this + " setting shouldCheckConnection to " + this.shouldCheckConnection));
        }
    }

    protected ServerAddress createServerAddress() {
        return new ServerAddress(this.addr.getHostAddress(), this.port, this.enableTcpNoDelay, -1);
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    protected synchronized void handleConnect() throws ConnectionFailedException {
        this.initPool();
    }

    protected synchronized void handleDisconnect() {
        MicroSocketClientInvoker.clearPools();
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object transport(String sessionID, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        int retryCount;
        long start = System.currentTimeMillis();
        SocketWrapper socketWrapper = null;
        Object response = null;
        boolean oneway = false;
        int tempTimeout = -1;
        int savedTimeout = -1;
        if (metadata != null) {
            String tempTimeoutString;
            Object val = metadata.get("oneway");
            if (val != null && val instanceof String && Boolean.valueOf((String)val).booleanValue()) {
                oneway = true;
            }
            if ((tempTimeoutString = (String)metadata.get("timeout")) != null) {
                try {
                    tempTimeout = Integer.valueOf(tempTimeoutString);
                    log.debug((Object)(this + " setting timeout to " + tempTimeout + " for this invocation"));
                }
                catch (Exception e) {
                    log.warn((Object)(this + " could not convert " + "timeout" + " value of " + tempTimeoutString + " to an integer value."));
                }
            }
        }
        SocketException sockEx = null;
        for (retryCount = 0; retryCount < this.numberOfCallRetries; ++retryCount) {
            int timeLeft = -1;
            if (0 < tempTimeout && (timeLeft = (int)((long)tempTimeout - (System.currentTimeMillis() - start))) <= 0) break;
            try {
                socketWrapper = this.getConnection(marshaller, unmarshaller, timeLeft);
            }
            catch (Exception e) {
                throw new CannotConnectException("Can not get connection to server. Problem establishing socket connection for " + this.locator, e);
            }
            if (tempTimeout >= 0) {
                savedTimeout = socketWrapper.getTimeout();
                socketWrapper.setTimeout((int)((long)tempTimeout - (System.currentTimeMillis() - start)));
            }
            long end = System.currentTimeMillis() - start;
            getSocketTime += end;
            try {
                int version = Version.getDefaultVersion();
                boolean performVersioning = Version.performVersioning();
                OutputStream outputStream = socketWrapper.getOutputStream();
                if (performVersioning) {
                    this.writeVersion(outputStream, version);
                }
                this.versionedWrite(outputStream, marshaller, invocation, version);
                end = System.currentTimeMillis() - start;
                writeTime += end;
                start = System.currentTimeMillis();
                if (oneway) {
                    if (trace) {
                        log.trace((Object)(this + " sent oneway invocation, so not waiting for response, returning null"));
                    }
                } else {
                    InputStream inputStream = socketWrapper.getInputStream();
                    if (performVersioning) {
                        version = this.readVersion(inputStream);
                        if (version == -1) {
                            throw new SocketException("end of file");
                        }
                        if (version == 254) {
                            log.info((Object)"Received version 254: treating as end of file");
                            throw new SocketException("end of file");
                        }
                    }
                    response = this.versionedRead(inputStream, unmarshaller, version);
                }
                end = System.currentTimeMillis() - start;
                readTime += end;
                if (tempTimeout < 0) break;
                socketWrapper.setTimeout(savedTimeout);
                break;
            }
            catch (SocketException sex) {
                block44: {
                    log.debug((Object)(this + " got SocketException " + sex));
                    try {
                        socketWrapper.close();
                        Object performVersioning = this.usedPoolLock;
                        synchronized (performVersioning) {
                            --this.usedPooled;
                        }
                    }
                    catch (Exception ex2) {
                        if (!trace) break block44;
                        log.trace((Object)(this + " couldn't successfully close its socketWrapper"), (Throwable)ex2);
                    }
                }
                if (retryCount == this.numberOfCallRetries - 2) {
                    this.flushConnectionPool();
                }
                sockEx = sex;
                continue;
            }
            catch (Exception ex) {
                log.debug((Object)(this + " got exception " + ex));
                try {
                    socketWrapper.close();
                    Object ex2 = this.usedPoolLock;
                    synchronized (ex2) {
                        --this.usedPooled;
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                return this.handleException(ex, socketWrapper);
            }
        }
        if (retryCount >= this.numberOfCallRetries) {
            this.handleException(sockEx, socketWrapper);
        }
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() < this.maxPoolSize) {
                this.pool.add(socketWrapper);
                Object end = this.usedPoolLock;
                synchronized (end) {
                    --this.usedPooled;
                }
                if (trace) {
                    log.trace((Object)(this + " returned " + socketWrapper + " to pool"));
                }
            } else {
                if (trace) {
                    log.trace((Object)(this + "'s pool is full, will close the connection"));
                }
                try {
                    socketWrapper.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        if (trace && !oneway) {
            log.trace((Object)(this + " received response " + response));
        }
        return response;
    }

    protected Object handleException(Exception ex, SocketWrapper socketWrapper) throws ClassNotFoundException, MarshalException {
        log.error((Object)(this + " got marshalling exception, exiting ..."), (Throwable)ex);
        if (ex instanceof ClassNotFoundException) {
            log.error((Object)"Error loading classes from remote call result.", (Throwable)ex);
            throw (ClassNotFoundException)ex;
        }
        throw new MarshalException("Failed to communicate. Problem during marshalling/unmarshalling.", ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPool() {
        Map map = connectionPools;
        synchronized (map) {
            this.pool = (LinkedList)connectionPools.get(this.address);
            if (this.pool == null) {
                this.pool = new LinkedList();
                connectionPools.put(this.address, this.pool);
                log.debug((Object)(this + " added new pool (" + this.pool + ") as " + this.address));
            } else {
                log.debug((Object)(this + " using pool (" + this.pool + ") already defined for " + this.address));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketWrapper getConnection(Marshaller marshaller, UnMarshaller unmarshaller, int timeAllowed) throws Exception {
        SocketWrapper pooled = null;
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.numberOfRetries; ++i) {
            if (this.bailOut) {
                log.debug((Object)(this + " has been concurrently disconnected, " + "bailing out from trying to create a new connection"));
                break;
            }
            int timeRemaining = -1;
            if (0 <= timeAllowed && (timeRemaining = (int)((long)timeAllowed - (System.currentTimeMillis() - start))) <= 0) break;
            LinkedList linkedList = this.pool;
            synchronized (linkedList) {
                if (this.pool.size() > 0) {
                    pooled = this.getPooledConnection();
                    if (trace) {
                        log.trace((Object)(this + " reusing pooled connection: " + pooled));
                    }
                }
            }
            boolean retry = false;
            Object object = this.usedPoolLock;
            synchronized (object) {
                if (pooled != null) {
                    ++this.usedPooled;
                    if (trace) {
                        log.trace((Object)(this + " got a socket, usedPooled: " + this.usedPooled));
                    }
                    break;
                }
                if (this.usedPooled < (long)this.maxPoolSize) {
                    if (trace) {
                        log.trace((Object)(this + " getting a socket, usedPooled: " + this.usedPooled));
                    }
                    ++this.usedPooled;
                } else {
                    retry = true;
                    if (trace) {
                        log.trace((Object)(this + " will try again to get a socket"));
                    }
                }
            }
            if (retry) {
                Thread.sleep(1000L);
                continue;
            }
            Socket socket = null;
            long timestamp = System.currentTimeMillis();
            try {
                if (trace) {
                    log.trace((Object)(this + " creating socket " + counter++ + ", attempt " + (i + 1)));
                }
                socket = this.createSocket(this.address.address, this.address.port, timeRemaining);
                if (trace) {
                    log.trace((Object)(this + " created socket: " + socket));
                }
            }
            catch (Exception ex) {
                log.debug((Object)(this + " got Exception " + ex + ", creation attempt took " + (System.currentTimeMillis() - timestamp) + " ms"));
                Object object2 = this.usedPoolLock;
                synchronized (object2) {
                    --this.usedPooled;
                }
                if (i + 1 < this.numberOfRetries) {
                    Thread.sleep(1L);
                    continue;
                }
                throw ex;
            }
            socket.setTcpNoDelay(this.address.enableTcpNoDelay);
            HashMap<String, Serializable> metadata = this.getLocator().getParameters();
            metadata = metadata == null ? new HashMap<String, Serializable>(2) : new HashMap(metadata);
            metadata.put("marshaller", marshaller);
            metadata.put("unmarshaller", unmarshaller);
            if (timeAllowed > 0) {
                timeRemaining = (int)((long)timeAllowed - (System.currentTimeMillis() - start));
                if (timeRemaining <= 0) break;
                metadata.put("temptimeout", new Integer(timeRemaining));
            }
            pooled = this.createClientSocket(socket, this.address.timeout, metadata);
            break;
        }
        if (pooled == null) {
            throw new SocketException("Can not obtain client socket connection from pool. Have waited " + (System.currentTimeMillis() - start) + " milliseconds for available connection (" + this.usedPooled + "in use)");
        }
        return pooled;
    }

    protected SocketWrapper createClientSocket(Socket socket, int timeout, Map metadata) throws Exception {
        if (this.clientSocketConstructor == null) {
            if (this.clientSocketClass == null) {
                this.clientSocketClass = ClassLoaderUtility.loadClass(this.clientSocketClassName, this.getClass());
            }
            Class[] args = new Class[]{class$java$net$Socket == null ? (class$java$net$Socket = MicroSocketClientInvoker.class$("java.net.Socket")) : class$java$net$Socket, class$java$util$Map == null ? (class$java$util$Map = MicroSocketClientInvoker.class$("java.util.Map")) : class$java$util$Map, class$java$lang$Integer == null ? (class$java$lang$Integer = MicroSocketClientInvoker.class$("java.lang.Integer")) : class$java$lang$Integer};
            this.clientSocketConstructor = this.clientSocketClass.getConstructor(args);
        }
        SocketWrapper clientSocketWrapper = null;
        clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(socket, metadata, new Integer(timeout));
        return clientSocketWrapper;
    }

    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        Socket s = new Socket();
        s.setReuseAddress(this.getReuseAddress());
        InetSocketAddress inetAddr = new InetSocketAddress(address, port);
        s.connect(inetAddr);
        return s;
    }

    protected SocketWrapper getPooledConnection() {
        SocketWrapper socketWrapper = null;
        while (this.pool.size() > 0) {
            socketWrapper = (SocketWrapper)this.pool.removeFirst();
            try {
                if (socketWrapper == null) continue;
                if (socketWrapper instanceof OpenConnectionChecker) {
                    ((OpenConnectionChecker)((Object)socketWrapper)).checkOpenConnection();
                }
                if (this.shouldCheckConnection) {
                    socketWrapper.checkConnection();
                    return socketWrapper;
                }
                return socketWrapper;
            }
            catch (Exception ex) {
                if (trace) {
                    log.trace((Object)(this + " couldn't reuse connection from pool"));
                }
                try {
                    socketWrapper.close();
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to close socket wrapper", (Throwable)e);
                }
            }
        }
        return null;
    }

    private Object versionedRead(InputStream inputStream, UnMarshaller unmarshaller, int version) throws IOException, ClassNotFoundException {
        switch (version) {
            case 1: 
            case 2: 
            case 22: {
                if (trace) {
                    log.trace((Object)(this + " reading response from unmarshaller"));
                }
                if (unmarshaller instanceof VersionedUnMarshaller) {
                    return ((VersionedUnMarshaller)unmarshaller).read(inputStream, null, version);
                }
                return unmarshaller.read(inputStream, null);
            }
        }
        throw new IOException("Can not read data for version " + version + ". " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
    }

    private void versionedWrite(OutputStream outputStream, Marshaller marshaller, Object invocation, int version) throws IOException {
        switch (version) {
            case 1: 
            case 2: 
            case 22: {
                if (trace) {
                    log.trace((Object)(this + " writing invocation to marshaller"));
                }
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(invocation, outputStream, version);
                } else {
                    marshaller.write(invocation, outputStream);
                }
                if (trace) {
                    log.trace((Object)(this + " done writing invocation to marshaller"));
                }
                return;
            }
        }
        throw new IOException("Can not write data for version " + version + ".  " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
    }

    private int readVersion(InputStream inputStream) throws IOException {
        if (trace) {
            log.trace((Object)(this + " reading version from input stream"));
        }
        int version = inputStream.read();
        if (trace) {
            log.trace((Object)(this + " read version " + version + " from input stream"));
        }
        return version;
    }

    private void writeVersion(OutputStream outputStream, int version) throws IOException {
        if (trace) {
            log.trace((Object)(this + " writing version " + version + " on output stream"));
        }
        outputStream.write(version);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

