/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperElement;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperThread;
import com.arjuna.ats.internal.arjuna.template.OrderedList;
import com.arjuna.ats.internal.arjuna.template.OrderedListIterator;

public class TransactionReaper {
    public static final String NORMAL = "NORMAL";
    public static final String DYNAMIC = "DYNAMIC";
    public static final long defaultCheckPeriod = 120000L;
    private OrderedList _list = new OrderedList();
    private long _checkPeriod = 0L;
    private static TransactionReaper _theReaper = null;
    private static ReaperThread _reaperThread = null;
    private static boolean _dynamic = false;
    private static long _lifetime = 0L;

    public TransactionReaper(long checkPeriod) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 1L, "TransactionReaper::TransactionReaper ( " + checkPeriod + " )");
        }
        this._checkPeriod = checkPeriod;
        if (this._list == null) {
            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.coordinator.TransactionReaper_1");
            }
            throw new OutOfMemoryError();
        }
    }

    public void finalize() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(2L, 4L, 1L, "TransactionReaper.finalize ()");
        }
        this._list = null;
    }

    public final long checkingPeriod() {
        return this._checkPeriod;
    }

    public final boolean check(long timeout) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::check ( " + timeout + " )");
        }
        if (this._list.size() == 0L) {
            return true;
        }
        OrderedListIterator iter = new OrderedListIterator(this._list);
        ReaperElement e = null;
        e = (ReaperElement)iter.iterate();
        if (e != null) {
            if (tsLogger.arjLoggerI18N.debugAllowed()) {
                tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_2", new Object[]{Long.toString(e._absoluteTimeout)});
            }
            if (timeout < e._absoluteTimeout) {
                iter = null;
                return true;
            }
        }
        iter = null;
        if (e != null) {
            if (e._control.running()) {
                boolean problem = false;
                try {
                    if (e._control.cancel() == 4) {
                        if (tsLogger.arjLoggerI18N.debugAllowed()) {
                            tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_3", new Object[]{e._control.get_uid()});
                        }
                    } else {
                        problem = true;
                    }
                }
                catch (Exception ex2) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_4", new Object[]{e._control});
                    }
                    problem = true;
                }
                if (problem) {
                    boolean error = false;
                    boolean printDebug = tsLogger.arjLoggerI18N.isWarnEnabled();
                    try {
                        error = !e._control.preventCommit();
                    }
                    catch (Exception ex3) {
                        error = true;
                    }
                    if (error || printDebug) {
                        if (error) {
                            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_5", new Object[]{e._control});
                            }
                        } else if (tsLogger.arjLoggerI18N.debugAllowed()) {
                            tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_3", new Object[]{e._control});
                        }
                    }
                }
            }
            this._list.remove(e);
        }
        System.gc();
        return true;
    }

    public final long numberOfTransactions() {
        return this._list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean insert(Reapable control, int timeout) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::insert ( " + control + ", " + timeout + " )");
        }
        if (timeout == 0) {
            return true;
        }
        _lifetime += (long)timeout;
        if ((long)timeout < this._checkPeriod || this._checkPeriod == Long.MAX_VALUE) {
            this._checkPeriod = timeout * 1000;
            _reaperThread.interrupt();
        }
        ReaperElement e = new ReaperElement(control, timeout);
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            if (this._list.insert(e)) {
                return true;
            }
            e = null;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(Object control) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::remove ( " + control + " )");
        }
        if (control == null) {
            return false;
        }
        boolean result = false;
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            ReaperElement e = null;
            OrderedListIterator iter = new OrderedListIterator(this._list);
            boolean found = false;
            if (!found && (e = (ReaperElement)iter.iterate()) != null) {
                try {
                    found = e._control.equals(control);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            iter = null;
            if (found) {
                result = this._list.remove(e);
                e = null;
            }
        }
        return result;
    }

    public final int getTimeout(Object control) {
        if (this._list.size() == 0L || control == null) {
            if (tsLogger.arjLogger.debugAllowed()) {
                tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::getTimeout for " + control + " returning 0");
            }
            return 0;
        }
        ReaperElement e = null;
        OrderedListIterator iter = new OrderedListIterator(this._list);
        while ((e = (ReaperElement)iter.iterate()) != null) {
            try {
                if (!e._control.equals(control)) continue;
                iter = null;
                if (tsLogger.arjLoggerI18N.debugAllowed()) {
                    tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_6", new Object[]{control, Integer.toString(e._timeout)});
                }
                return e._timeout;
            }
            catch (Exception e2) {
                // empty catch block
                break;
            }
        }
        if (tsLogger.arjLoggerI18N.debugAllowed()) {
            tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_6", new Object[]{control, "0"});
        }
        return 0;
    }

    public static synchronized TransactionReaper create(long checkPeriod) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::create ( " + checkPeriod + " )");
        }
        if (_theReaper == null) {
            String mode = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperMode");
            if (mode != null && mode.compareTo(DYNAMIC) == 0) {
                _dynamic = true;
            }
            if (!_dynamic) {
                String timeoutEnv = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperTimeout");
                if (timeoutEnv != null) {
                    Long l = null;
                    try {
                        l = new Long(timeoutEnv);
                        checkPeriod = l;
                        l = null;
                    }
                    catch (NumberFormatException e) {
                        tsLogger.arjLogger.warn("TransactionReaper::create - " + e);
                    }
                }
            } else {
                checkPeriod = Long.MAX_VALUE;
            }
            _theReaper = new TransactionReaper(checkPeriod);
            _reaperThread = new ReaperThread(_theReaper);
            _reaperThread.setDaemon(true);
            _reaperThread.start();
        }
        return _theReaper;
    }

    public static TransactionReaper create() {
        return TransactionReaper.create(120000L);
    }

    public static TransactionReaper transactionReaper() {
        return TransactionReaper.transactionReaper(false);
    }

    public static synchronized TransactionReaper transactionReaper(boolean createReaper) {
        if (createReaper) {
            return TransactionReaper.create();
        }
        return _theReaper;
    }

    public static final long transactionLifetime() {
        return _lifetime;
    }

    static final void reset() {
        _theReaper = null;
    }
}

