/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.jta.transaction.jts.jca.TxImporter;
import com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.TransactionImple;
import com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.coordinator.ServerTransaction;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.IOException;
import java.util.Stack;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XATerminatorImple
implements XATerminator {
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            TransactionImple tx2 = TxImporter.getImportedTransaction(xid);
            if (tx2 == null) {
                throw new XAException(-5);
            }
            if (onePhase) {
                tx2.doOnePhaseCommit();
            } else {
                tx2.doCommit();
            }
            TxImporter.removeImportedTransaction(xid);
        }
        catch (XAException ex) {
            TxImporter.removeImportedTransaction(xid);
            throw ex;
        }
        catch (HeuristicRollbackException ex) {
            throw new XAException(6);
        }
        catch (HeuristicMixedException ex) {
            throw new XAException(5);
        }
        catch (SystemException ex) {
            TxImporter.removeImportedTransaction(xid);
            throw new XAException(-3);
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            TransactionImple tx2 = TxImporter.getImportedTransaction(xid);
            if (tx2 == null) {
                throw new XAException(-5);
            }
            tx2.doForget();
        }
        catch (Exception ex) {
            throw new XAException(-3);
        }
        finally {
            TxImporter.removeImportedTransaction(xid);
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            TransactionImple tx2 = TxImporter.getImportedTransaction(xid);
            if (tx2 == null) {
                throw new XAException(-5);
            }
            switch (tx2.doPrepare()) {
                case 2: {
                    TxImporter.removeImportedTransaction(xid);
                    return 3;
                }
                case 1: {
                    TxImporter.removeImportedTransaction(xid);
                    throw new XAException(100);
                }
                case 0: {
                    return 0;
                }
            }
            throw new XAException(104);
        }
        catch (SystemException ex) {
            throw new XAException(-7);
        }
        catch (XAException ex) {
            throw ex;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        Xid[] indoubt;
        block12: {
            switch (flag) {
                case 0x1000000: {
                    break;
                }
                case 0x800000: {
                    return null;
                }
                default: {
                    throw new XAException(-6);
                }
            }
            indoubt = null;
            try {
                ObjectStore objStore = new ObjectStore(TxControl.getActionStoreType());
                InputObjectState states = null;
                if (!objStore.allObjUids(ServerTransaction.getType(), states) || states == null) break block12;
                Stack<Uid> values = new Stack<Uid>();
                boolean finished = false;
                do {
                    Uid uid = new Uid(Uid.nullUid());
                    try {
                        uid.unpack(states);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        finished = true;
                    }
                    if (uid.notEquals(Uid.nullUid())) {
                        values.push(uid);
                        continue;
                    }
                    finished = true;
                } while (!finished);
                if (values.size() > 0) {
                    int index = 0;
                    indoubt = new Xid[values.size()];
                    while (!values.empty()) {
                        Uid id = (Uid)values.pop();
                        indoubt[index] = new XidImple(id);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return indoubt;
    }

    public void rollback(Xid xid) throws XAException {
        try {
            TransactionImple tx2 = TxImporter.getImportedTransaction(xid);
            if (tx2 == null) {
                throw new XAException(-5);
            }
            tx2.doRollback();
            TxImporter.removeImportedTransaction(xid);
        }
        catch (XAException ex) {
            TxImporter.removeImportedTransaction(xid);
            throw ex;
        }
        catch (HeuristicCommitException ex) {
            throw new XAException(7);
        }
        catch (HeuristicMixedException ex) {
            throw new XAException(5);
        }
        catch (SystemException ex) {
            TxImporter.removeImportedTransaction(xid);
            throw new XAException(-3);
        }
    }
}

