/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.xml.sax.Attributes;

public class AllBinding
extends ModelGroupBinding {
    private static final Logger log = Logger.getLogger(AllBinding.class);
    private Map elements = Collections.EMPTY_MAP;

    public AllBinding(SchemaBinding schema) {
        super(schema);
    }

    public ElementBinding getArrayItem() {
        return null;
    }

    public void addParticle(ParticleBinding particle) {
        if (!(particle.getTerm() instanceof ElementBinding)) {
            throw new JBossXBRuntimeException("Model group all may contain only elements!");
        }
        ElementBinding element = (ElementBinding)particle.getTerm();
        switch (this.elements.size()) {
            case 0: {
                this.elements = Collections.singletonMap(element.getQName(), particle);
                break;
            }
            case 1: {
                this.elements = new HashMap(this.elements);
            }
            default: {
                this.elements.put(element.getQName(), particle);
            }
        }
        super.addParticle(particle);
    }

    public Collection getParticles() {
        return Collections.unmodifiableCollection(this.elements.values());
    }

    public ModelGroupBinding.Cursor newCursor(ParticleBinding particle) {
        return new ModelGroupBinding.Cursor(particle){
            private ParticleBinding curParticle;
            private int occurence;

            public ParticleBinding getCurrentParticle() {
                if (this.curParticle == null) {
                    throw new JBossXBRuntimeException("The cursor in all group has not been positioned yet!");
                }
                return this.curParticle;
            }

            public ElementBinding getElement() {
                return (ElementBinding)this.getCurrentParticle().getTerm();
            }

            public void endElement(QName qName) {
                if (this.curParticle == null || !this.getElement().getQName().equals(qName)) {
                    throw new JBossXBRuntimeException("Failed to process endElement for " + qName + " since the current element is " + (this.curParticle == null ? null : this.getElement().getQName()));
                }
            }

            public int getOccurence() {
                return this.occurence;
            }

            protected List startElement(QName qName, Attributes atts, Set passedGroups, List groupStack, boolean required) {
                ParticleBinding particle = (ParticleBinding)AllBinding.this.elements.get(qName);
                if (particle != null) {
                    if (this.curParticle == particle) {
                        ++this.occurence;
                    } else {
                        this.curParticle = particle;
                        this.occurence = 1;
                    }
                    groupStack = this.addItem(groupStack, this);
                } else {
                    log.warn("Element " + qName + " not found in " + AllBinding.this.elements.keySet());
                }
                return groupStack;
            }

            protected ElementBinding getElement(QName qName, Attributes atts, Set passedGroups, boolean ignoreWildcards) {
                ParticleBinding particle = (ParticleBinding)AllBinding.this.elements.get(qName);
                return particle == null ? null : (ElementBinding)particle.getTerm();
            }
        };
    }

    protected boolean mayStartWith(QName qName, Set set) {
        return this.elements.containsKey(qName);
    }
}

