/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.encoding.simpletype;

public class EncoderUtils {
    public static boolean needsCollapsing(String str) {
        int len = str.length();
        int spanLen = 0;
        for (int idx = 0; idx < len; ++idx) {
            if (Character.isWhitespace(str.charAt(idx))) {
                ++spanLen;
                continue;
            }
            if (spanLen <= 0) continue;
            if (spanLen == idx) {
                return true;
            }
            if (str.charAt(idx - spanLen) != ' ') {
                return true;
            }
            if (spanLen > 1) {
                return true;
            }
            spanLen = 0;
        }
        return spanLen > 0;
    }

    public static String collapseWhitespace(String str) {
        if (!EncoderUtils.needsCollapsing(str)) {
            return str;
        }
        int len = str.length();
        char[] buf = new char[len];
        str.getChars(0, len, buf, 0);
        int leadingWSLen = 0;
        int trailingWSLen = 0;
        int spanLen = 0;
        for (int idx = 0; idx < len; ++idx) {
            if (Character.isWhitespace(buf[idx])) {
                ++spanLen;
                continue;
            }
            if (spanLen <= 0) continue;
            if (spanLen == idx) {
                leadingWSLen = spanLen;
            } else {
                int firstWSIdx = idx - spanLen;
                buf[firstWSIdx] = 32;
                if (spanLen > 1) {
                    System.arraycopy(buf, idx, buf, firstWSIdx + 1, len - idx);
                    len -= spanLen - 1;
                    idx = firstWSIdx + 1;
                }
            }
            spanLen = 0;
        }
        if (spanLen > 0) {
            trailingWSLen = spanLen;
        }
        return new String(buf, leadingWSLen, len - leadingWSLen - trailingWSLen);
    }

    public static String removeWhitespace(String str) {
        int idx;
        int len = str.length();
        StringBuffer buf = new StringBuffer();
        int firstNonWS = 0;
        for (idx = 0; idx < len; ++idx) {
            if (!Character.isWhitespace(str.charAt(idx))) continue;
            if (firstNonWS < idx) {
                buf.append(str.substring(firstNonWS, idx));
            }
            firstNonWS = idx + 1;
        }
        if (firstNonWS < idx) {
            buf.append(str.substring(firstNonWS, idx));
        }
        return buf.toString();
    }
}

