/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.application;

import com.icesoft.faces.application.ProductInfo;
import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMResponseWriter;
import com.icesoft.faces.env.CommonEnvironmentResponse;
import com.icesoft.faces.webapp.parser.JspPageToDocument;
import com.icesoft.faces.webapp.parser.Parser;
import com.icesoft.faces.webapp.xmlhttp.BlockingServlet;
import com.icesoft.util.SeamUtilities;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.RenderResponse;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class D2DViewHandler
extends ViewHandler {
    protected static Log log = LogFactory.getLog((Class)D2DViewHandler.class);
    private static final String CURRENT_VIEW_ROOT = "javax.faces.webapp.CURRENT_VIEW_ROOT";
    private static final String DELEGATE_NONIFACE = "com.icesoft.faces.delegateNonIface";
    private static final String ACTION_URL_SUFFIX = "com.icesoft.faces.actionURLSuffix";
    private static final String RELOAD_INTERVAL = "com.icesoft.faces.reloadInterval";
    private static final String DO_JSF_STATE_MANAGEMENT = "com.icesoft.faces.doJSFStateManagement";
    private static final String LAST_LOADED_KEY = "_lastLoaded";
    private static final String LAST_CHECKED_KEY = "_lastChecked";
    public static final String DOM_CONTEXT_TABLE = "com.icesoft.faces.sessionAuxiliaryData";
    public static final String CHAR_ENCODING = "UTF-8";
    public static final String HTML_CONTENT_TYPE = "text/html;charset=UTF-8";
    private String actionURLSuffix;
    protected boolean delegateNonIface = false;
    protected boolean delegateNonIfaceDefault = false;
    protected boolean jsfStateManagement;
    protected long reloadInterval;
    protected long reloadIntervalDefault = 2L;
    private boolean parametersInitialized = false;
    protected Parser parser;
    private ViewHandler delegate;

    public D2DViewHandler() {
    }

    public D2DViewHandler(ViewHandler delegate) {
        this.delegate = delegate;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        ResponseWriter responseWriter;
        this.initializeParameters(context);
        if (this.delegateView(viewToRender.getViewId())) {
            this.delegate.renderView(context, viewToRender);
            return;
        }
        if (null == this.parser) {
            this.parser = new Parser(((Object)((Object)this)).getClass().getResourceAsStream("serializedTagToComponentMapFull.ser"));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderView(FC,UIVR)  BEFORE  renderResponse  viewToRender.getViewId(): " + viewToRender.getViewId()));
        }
        this.renderResponse(context);
        if (log.isTraceEnabled()) {
            log.trace((Object)"renderView(FC,UIVR)  AFTER   renderResponse");
        }
        if ((responseWriter = context.getResponseWriter()) instanceof DOMResponseWriter) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"renderView(FC,UIVR)  BEFORE  domWriter");
            }
            DOMResponseWriter domWriter = (DOMResponseWriter)responseWriter;
            domWriter.writeDOM();
            if (log.isTraceEnabled()) {
                log.trace((Object)"renderView(FC,UIVR)  AFTER   domWriter");
            }
        }
        if (this.jsfStateManagement) {
            StateManager stateMgr = context.getApplication().getStateManager();
            stateMgr.saveSerializedView(context);
        }
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        this.initializeParameters(context);
        if (this.delegateView(viewId)) {
            return this.delegate.createView(context, viewId);
        }
        UIViewRoot root = new UIViewRoot();
        root.setRenderKitId("HTML_BASIC");
        Map contextServletTable = D2DViewHandler.getContextServletTable(context);
        if (null == viewId) {
            root.setViewId("default");
            context.setViewRoot(root);
            contextServletTable.put("com.icesoft.domResponseViewRoot", root);
            Locale locale = this.calculateLocale(context);
            root.setLocale(locale);
            return root;
        }
        root.setViewId(viewId);
        context.setViewRoot(root);
        contextServletTable.put("com.icesoft.domResponseViewRoot", root);
        return root;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        this.initializeParameters(context);
        if (this.delegateView(viewId)) {
            return this.delegate.restoreView(context, viewId);
        }
        UIViewRoot currentRoot = context.getViewRoot();
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext instanceof BridgeExternalContext) {
            BridgeExternalContext bridgeExternalContext = (BridgeExternalContext)externalContext;
            bridgeExternalContext.setRequestServletPath(viewId);
            if (null != externalContext.getRequestPathInfo()) {
                bridgeExternalContext.setRequestPathInfo(viewId);
            }
            if (SeamUtilities.isSeamEnvironment()) {
                if (bridgeExternalContext.getRequestParameterMap().remove("com.icesoft.faces.shortcutLifecycle") != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Seam Keyword shortcut found, new ViewRoot");
                    }
                    return null;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No Seam Keyword shortcut found");
                }
            }
        }
        if (null != currentRoot && D2DViewHandler.mungeViewId(viewId).equals(D2DViewHandler.mungeViewId(currentRoot.getViewId()))) {
            this.purgeSeamContexts(context, currentRoot);
            return currentRoot;
        }
        Map contextServletTable = D2DViewHandler.getContextServletTable(context);
        if (contextServletTable.containsKey("com.icesoft.domResponseContexts")) {
            Map domResponseContexts = (Map)contextServletTable.get("com.icesoft.domResponseContexts");
        } else {
            HashMap domResponseContexts = new HashMap();
            contextServletTable.put("com.icesoft.domResponseContexts", domResponseContexts);
        }
        UIViewRoot root = null;
        root = (UIViewRoot)contextServletTable.get("com.icesoft.domResponseViewRoot");
        if (null == root || null == viewId || D2DViewHandler.mungeViewId(viewId).equals(D2DViewHandler.mungeViewId(root.getViewId()))) {
            // empty if block
        }
        if (SeamUtilities.isSeamEnvironment()) {
            this.purgeSeamContexts(context, root);
        }
        return root;
    }

    private void purgeSeamContexts(FacesContext context, UIViewRoot root) {
        if (root == null) {
            return;
        }
        if (context.getExternalContext().getRequestMap().remove("com.icesoft.faces.removeSeamContexts") != null) {
            String key = SeamUtilities.getPageContextKey();
            Object o = root.getAttributes().remove(key);
            log.debug((Object)("Removed Seam PageContext from Request: " + (o != null)));
        }
    }

    private static Map getContextServletTables(FacesContext context) {
        Map contextTable;
        String treeKey;
        Map sessionMap = D2DViewHandler.getSessionMap(context);
        String viewNumber = "-";
        if (context instanceof BridgeFacesContext) {
            viewNumber = ((BridgeFacesContext)context).getViewNumber();
        }
        if (sessionMap.containsKey(treeKey = viewNumber + "/" + DOM_CONTEXT_TABLE)) {
            contextTable = (Map)sessionMap.get(treeKey);
        } else {
            contextTable = new HashMap();
            sessionMap.put(treeKey, contextTable);
        }
        return contextTable;
    }

    public static Map getContextServletTable(FacesContext context) {
        String servletRequestPath;
        Map domContextTables = D2DViewHandler.getContextServletTables(context);
        if (domContextTables.containsKey(servletRequestPath = D2DViewHandler.getServletRequestPath(context))) {
            return (Map)domContextTables.get(servletRequestPath);
        }
        HashMap domContextTable = new HashMap();
        domContextTables.put(servletRequestPath, domContextTable);
        return domContextTable;
    }

    public static String getServletRequestPath(FacesContext context) {
        if (Beans.isDesignTime()) {
            return context.getViewRoot().getViewId();
        }
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext instanceof BridgeExternalContext) {
            String uri = ((BridgeExternalContext)externalContext).getRequestURI();
            if (null == uri) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Failing over to default request path");
                }
                uri = "default";
            }
            return uri;
        }
        return externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
    }

    public static String getServletRequestPath(ExternalContext externalContext, String viewId) {
        if (externalContext == null) {
            throw new IllegalStateException("ExternalContext is null");
        }
        return externalContext.getRequestContextPath() + viewId;
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (this.delegateView(viewId)) {
            return this.delegate.getActionURL(context, viewId);
        }
        if (viewId.indexOf("://") >= 0) {
            return viewId;
        }
        if (viewId.charAt(0) != '/') {
            throw new IllegalArgumentException("viewId " + viewId + "does not begin with '/'");
        }
        if (null != this.actionURLSuffix) {
            viewId = viewId.substring(0, viewId.lastIndexOf(".")) + this.actionURLSuffix;
        }
        return context.getExternalContext().getRequestContextPath() + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        if (path.startsWith("/")) {
            return context.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    protected long getTimeAttribute(UIComponent root, String key) {
        Long timeLong = (Long)root.getAttributes().get(key);
        long time = null == timeLong ? 0L : timeLong;
        return time;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void renderResponse(FacesContext context) throws IOException {
        UIViewRoot root = context.getViewRoot();
        String viewId = root.getViewId();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Rendering " + root + " with " + root.getChildCount() + " children"));
        }
        this.clearSession(context);
        this.createResponseWriter(context);
        boolean reloadView = false;
        URLConnection viewConnection = null;
        if (root.getChildCount() == 0 || this.reloadInterval > -1L) {
            if (viewId.startsWith("/faces")) {
                viewId = viewId.substring(6);
            }
            if (viewId.endsWith(".jpg") || viewId.endsWith(".gif") || viewId.endsWith(".png")) {
                context.getExternalContext().dispatch(viewId);
                return;
            }
            try {
                void var6_8;
                URL uRL = context.getExternalContext().getResource(viewId);
                if (null == uRL) {
                    if (viewId.endsWith(".faces")) {
                        viewId = D2DViewHandler.truncate(".faces", viewId);
                    } else if (viewId.endsWith(".jsf")) {
                        viewId = D2DViewHandler.truncate(".jsf", viewId);
                    } else if (viewId.endsWith(".iface")) {
                        viewId = D2DViewHandler.truncate(".iface", viewId);
                    } else if (viewId.endsWith(".jsp")) {
                        viewId = D2DViewHandler.truncate(".jsp", viewId);
                    }
                    viewId = viewId + ".jspx";
                    URL uRL2 = context.getExternalContext().getResource(viewId);
                }
                if (null == var6_8) {
                    if (viewId.endsWith(".jspx")) {
                        viewId = D2DViewHandler.truncate(".jspx", viewId) + ".jsp";
                    }
                    URL uRL3 = context.getExternalContext().getResource(viewId);
                }
                long currentTime = System.currentTimeMillis();
                long lastLoaded = this.getTimeAttribute((UIComponent)root, LAST_LOADED_KEY);
                long lastChecked = this.getTimeAttribute((UIComponent)root, LAST_CHECKED_KEY);
                long lastModified = 0L;
                if (currentTime > lastChecked + this.reloadInterval) {
                    void var6_10;
                    viewConnection = var6_10.openConnection();
                    lastModified = viewConnection.getLastModified();
                    root.getAttributes().put(LAST_CHECKED_KEY, new Long(currentTime));
                    if (lastModified > lastLoaded) {
                        reloadView = true;
                    }
                }
            }
            catch (Exception exception) {
                throw new FacesException("Can't find stream for " + viewId, (Throwable)exception);
            }
        }
        if (reloadView) {
            Object var6_12 = null;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(viewConnection.getInputStream(), CHAR_ENCODING);
                if (null == inputStreamReader) {
                    throw new NullPointerException();
                }
                if (viewId.endsWith(".jsp")) {
                    Reader reader = JspPageToDocument.transform(inputStreamReader);
                } else if (viewId.endsWith(".jspx")) {
                    Reader reader = JspPageToDocument.preprocessJspDocument(inputStreamReader);
                }
            }
            catch (Throwable e) {
                throw new FacesException("Can't read stream for " + viewId, e);
            }
            try {
                void var6_16;
                context.getExternalContext().getRequestMap().remove(CURRENT_VIEW_ROOT);
                this.parser.parse((Reader)var6_16, context);
                root.getAttributes().put(LAST_LOADED_KEY, new Long(System.currentTimeMillis()));
                ExternalContext externalContext = context.getExternalContext();
                if (!(externalContext instanceof BridgeExternalContext)) return;
                BridgeExternalContext bridgeExternalContext = (BridgeExternalContext)externalContext;
                if (BlockingServlet.standardRequestScope) {
                    bridgeExternalContext.clearRequestMap();
                    return;
                }
                bridgeExternalContext.resetRequestMap();
                return;
            }
            catch (Throwable e) {
                throw new FacesException("Can't parse stream for " + viewId + " " + e.getMessage(), e);
            }
        }
        this.renderResponse(context, (UIComponent)root);
        this.tracePrintComponentTree(context);
    }

    protected void renderResponse(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                this.renderResponse(context, (UIComponent)kids.next());
            }
        }
        component.encodeEnd(context);
        if (component instanceof UIData) {
            UIComponent stateHolder = component;
            stateHolder.restoreState(context, stateHolder.saveState(context));
        }
    }

    protected void tracePrintComponentTree(FacesContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"tracePrintComponentTree() vvvvvv");
            this.tracePrintComponentTree((UIComponent)context.getViewRoot(), context, 0);
            log.trace((Object)"tracePrintComponentTree() ^^^^^^");
        }
    }

    private void tracePrintComponentTree(UIComponent component, FacesContext context, int levels) {
        boolean hasKids;
        StringBuffer prefix = new StringBuffer(64);
        for (int i = 0; i < levels; ++i) {
            prefix.append("  ");
        }
        prefix.append("<");
        String compStr = component.toString();
        StringBuffer open = new StringBuffer(512);
        open.append(prefix);
        open.append(compStr);
        boolean bl = hasKids = component.getChildCount() > 0;
        if (!hasKids) {
            open.append("/");
        }
        open.append(">");
        if (hasKids) {
            open.append(" kids: ");
            open.append(Integer.toString(component.getChildCount()));
        }
        log.trace((Object)open);
        if (hasKids) {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                this.tracePrintComponentTree((UIComponent)kids.next(), context, levels + 1);
            }
            StringBuffer close = new StringBuffer(512);
            close.append(prefix);
            close.append("/");
            close.append(compStr);
            close.append(">");
            log.trace((Object)close);
        }
    }

    protected void clearSession(FacesContext context) {
        Map contextServletTable = D2DViewHandler.getContextServletTable(context);
        contextServletTable.remove("com.icesoft.domResponseContexts");
        contextServletTable.remove("com.icesoft.domResponseViewRoot");
        contextServletTable.remove("com.icesoft.domResponseDocument");
        contextServletTable.remove("com.icesoft.domResponseContextModNodes");
    }

    protected void createResponseWriter(FacesContext context) throws IOException {
        Object obj = context.getExternalContext().getResponse();
        Writer writer = null;
        if (obj != null) {
            if (obj instanceof CommonEnvironmentResponse) {
                CommonEnvironmentResponse response = (CommonEnvironmentResponse)obj;
                response.setContentType(HTML_CONTENT_TYPE);
                try {
                    writer = new OutputStreamWriter(response.getStream(), CHAR_ENCODING);
                }
                catch (IllegalStateException e) {
                    writer = response.getWriter();
                }
            } else if (obj instanceof ServletResponse) {
                ServletResponse response = (ServletResponse)obj;
                response.setContentType(HTML_CONTENT_TYPE);
                writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), CHAR_ENCODING);
            } else if (obj instanceof RenderResponse) {
                RenderResponse response = (RenderResponse)obj;
                response.setContentType(HTML_CONTENT_TYPE);
                writer = new OutputStreamWriter(response.getPortletOutputStream(), CHAR_ENCODING);
            } else {
                throw new FacesException("unknown type of response: " + obj);
            }
        }
        context.setResponseWriter((ResponseWriter)new DOMResponseWriter(writer, HTML_CONTENT_TYPE, CHAR_ENCODING));
    }

    private static Map getSessionMap(FacesContext context) {
        Map sessionMap;
        if (null == context) {
            context = FacesContext.getCurrentInstance();
        }
        if (null == (sessionMap = context.getExternalContext().getSessionMap())) {
            context.getExternalContext().getSession(true);
            sessionMap = context.getExternalContext().getSessionMap();
        }
        return sessionMap;
    }

    public void writeState(FacesContext context) throws IOException {
        if (this.delegateView(context.getViewRoot().getViewId())) {
            this.delegate.writeState(context);
        }
    }

    public Locale calculateLocale(FacesContext context) {
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            Iterator supportedLocales = context.getApplication().getSupportedLocales();
            while (supportedLocales.hasNext()) {
                Locale supportedLocale = (Locale)supportedLocales.next();
                if (!locale.getLanguage().equals(supportedLocale.getLanguage())) continue;
                if (null == supportedLocale.getCountry() || "".equals(supportedLocale.getCountry())) {
                    return supportedLocale;
                }
                if (!locale.equals(supportedLocale)) continue;
                return supportedLocale;
            }
        }
        Locale defaultLocale = context.getApplication().getDefaultLocale();
        return null == defaultLocale ? Locale.getDefault() : defaultLocale;
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.delegate.calculateRenderKitId(context);
    }

    public static boolean isValueReference(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value.indexOf("#{") != -1 && value.indexOf("#{") < value.indexOf(125);
    }

    public static UIComponent findComponent(String clientId, UIComponent base) {
        if (clientId == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            throw new NullPointerException();
        }
        String delimeter = String.valueOf(':');
        if (clientId.startsWith(delimeter)) {
            while (base.getParent() != null) {
                base = base.getParent();
            }
            clientId = clientId.substring(1);
        } else {
            while (base.getParent() != null && !(base instanceof NamingContainer)) {
                base = base.getParent();
            }
        }
        String id = null;
        UIComponent result = null;
        while (clientId.length() > 0) {
            int separator = clientId.indexOf(58);
            if (base instanceof UIData) {
                if (separator >= 0) {
                    clientId = clientId.substring(separator + 1);
                }
                separator = clientId.indexOf(58);
            }
            if (separator >= 0) {
                id = clientId.substring(0, separator);
                clientId = clientId.substring(separator + 1);
            } else {
                id = clientId;
                clientId = "";
            }
            result = D2DViewHandler.findComponent(base, id);
            if (result == null || clientId.length() == 0) break;
            if (!(result instanceof NamingContainer)) continue;
            result = D2DViewHandler.findComponent(clientId, result);
            break;
        }
        return result;
    }

    private static String truncate(String remove, String input) {
        return input.substring(0, input.length() - remove.length());
    }

    public void setActionURLSuffix(String param) {
        this.actionURLSuffix = param;
    }

    public void setDelegateNonIface(String param) {
        this.delegateNonIface = D2DViewHandler.getStringAsBoolean(param, this.delegateNonIfaceDefault);
    }

    public void setReloadInterval(String param) {
        this.reloadInterval = D2DViewHandler.getStringAsLong(param, this.reloadIntervalDefault);
        if (-1L != this.reloadInterval) {
            this.reloadInterval *= 1000L;
        }
    }

    private static boolean getStringAsBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no")) {
            return false;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        return defaultValue;
    }

    private static long getStringAsLong(String param, long defaultValue) {
        long value;
        block3: {
            if (param == null) {
                return defaultValue;
            }
            value = defaultValue;
            try {
                value = Long.parseLong(param);
            }
            catch (NumberFormatException e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)("Unable to parse string as long " + param));
            }
        }
        return value;
    }

    private boolean delegateView(String viewId) {
        Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        if ("persistent".equals(requestMap.get("servletkey"))) {
            return false;
        }
        if (this.delegateNonIface) {
            return !viewId.endsWith(".iface");
        }
        return false;
    }

    private void initializeParameters(FacesContext context) {
        if (this.parametersInitialized) {
            return;
        }
        ExternalContext externalContext = context.getExternalContext();
        this.setDelegateNonIface(externalContext.getInitParameter(DELEGATE_NONIFACE));
        this.setActionURLSuffix(externalContext.getInitParameter(ACTION_URL_SUFFIX));
        this.setReloadInterval(externalContext.getInitParameter(RELOAD_INTERVAL));
        this.jsfStateManagement = Boolean.valueOf(externalContext.getInitParameter(DO_JSF_STATE_MANAGEMENT));
        if (!this.jsfStateManagement) {
            log.debug((Object)"JSF State Management not provided");
        }
        this.parametersInitialized = true;
    }

    private static String mungeViewId(String viewId) {
        String defaultSuffix = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        String suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
        int dot = viewId.lastIndexOf(46);
        if (dot == -1) {
            log.error((Object)("Assumed extension mapping, but there is no extension in " + viewId));
        } else {
            viewId = viewId.substring(0, dot) + suffix;
        }
        return viewId;
    }

    private static UIComponent findComponent(UIComponent uiComponent, String componentId) {
        UIComponent component = null;
        UIComponent child = null;
        if (componentId.equals(uiComponent.getId())) {
            return uiComponent;
        }
        Iterator children = uiComponent.getFacetsAndChildren();
        while (children.hasNext() && component == null) {
            child = (UIComponent)children.next();
            if (!(child instanceof NamingContainer)) {
                component = D2DViewHandler.findComponent(child, componentId);
                if (component == null) continue;
                break;
            }
            if (!componentId.endsWith(child.getId())) continue;
            component = child;
            break;
        }
        return component;
    }

    static {
        if (log.isInfoEnabled()) {
            log.info((Object)new ProductInfo().toString());
        }
    }
}

