/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.OnDemandRenderer;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntervalRenderer
extends OnDemandRenderer
implements Runnable {
    private static Log log = LogFactory.getLog((Class)IntervalRenderer.class);
    private long interval = 60000L;
    private boolean isStarted = false;
    private ScheduledFuture future;

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void requestRender() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        ScheduledThreadPoolExecutor scheduleService = this.renderManager.getScheduledService();
        this.future = scheduleService.scheduleAtFixedRate((Runnable)this, this.interval, this.interval, TimeUnit.MILLISECONDS);
        if (log.isDebugEnabled()) {
            log.debug((Object)("interval render started: interval is " + this.interval + " ms"));
        }
    }

    public void requestStop() {
        super.requestStop();
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(false);
        }
        this.isStarted = false;
    }

    public void run() {
        super.requestRender();
    }

    public void dispose() {
        super.dispose();
        this.future = null;
    }
}

