/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.message.properties;

import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;

public class MessagePropertyTest
extends PTPTestCase {
    static /* synthetic */ Class class$org$objectweb$jtests$jms$conform$message$properties$MessagePropertyTest;

    public void testSetObjectProperty_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setObjectProperty("prop", new Vector());
            MessagePropertyTest.fail((String)"\ufffd3.5.5 An attempt to use any other class [than Boolean, Byte,...,String] must throw a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException e) {
        }
        catch (JMSException e) {
            MessagePropertyTest.fail((String)("Should throw a javax.jms.MessageFormatException, not a " + (Object)((Object)e)));
        }
    }

    public void testSetObjectProperty_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setObjectProperty("pi", (Object)new Float(3.14159f));
            MessagePropertyTest.assertEquals((float)3.14159f, (float)message.getFloatProperty("pi"), (float)0.0f);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetObjectProperty() {
        try {
            Message message = this.senderSession.createMessage();
            MessagePropertyTest.assertEquals((String)"\ufffd3.5.5 A null value is returned [by the getObjectProperty method] if a property by the specified name does not exits.\n", null, (Object)message.getObjectProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetStringProperty() {
        try {
            Message message = this.senderSession.createMessage();
            MessagePropertyTest.assertEquals((String)"\ufffd3.5.5 A null value is returned [by the getStringProperty method] if a property by the specified name does not exits.\n", null, (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetDoubleProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getDoubleProperty("prop");
            MessagePropertyTest.fail((String)"Should raise a NullPointerException.\n");
        }
        catch (NullPointerException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetFloatProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getFloatProperty("prop");
            MessagePropertyTest.fail((String)"Should raise a NullPointerException.\n");
        }
        catch (NullPointerException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetLongProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getLongProperty("prop");
            MessagePropertyTest.fail((String)"Should raise a NumberFormatException.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetIntProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getIntProperty("prop");
            MessagePropertyTest.fail((String)"Should raise a NumberFormatException.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetShortProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getShortProperty("prop");
            MessagePropertyTest.fail((String)"Should raise a NumberFormatException.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetByteProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getByteProperty("prop");
            MessagePropertyTest.fail((String)"Should raise a NumberFormatException.\n");
        }
        catch (NumberFormatException e) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetBooleanProperty() {
        try {
            Message message = this.senderSession.createMessage();
            MessagePropertyTest.assertEquals((boolean)false, (boolean)message.getBooleanProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetPropertyNames() {
        try {
            Message message = this.senderSession.createMessage();
            message.setJMSCorrelationID("foo");
            Enumeration enumeration = message.getPropertyNames();
            MessagePropertyTest.assertTrue((String)"\ufffd3.5.6 The getPropertyNames method does not return the names of the JMS standard header field [e.g. JMSCorrelationID].\n", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testPropertyIteration() {
        try {
            Message message = this.senderSession.createMessage();
            Enumeration enumeration = message.getPropertyNames();
            MessagePropertyTest.assertTrue((String)"No property yet defined.\n", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
            message.setDoubleProperty("pi", 3.14159);
            enumeration = message.getPropertyNames();
            MessagePropertyTest.assertEquals((String)"One property defined of name 'pi'.\n", (String)"pi", (String)((String)enumeration.nextElement()));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testClearProperties_2() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("foo");
            message.clearProperties();
            MessagePropertyTest.assertEquals((String)"\ufffd3.5.7 Clearing a message's  property entries does not clear the value of its body.\n", (String)"foo", (String)message.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testClearProperties_1() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setStringProperty("prop", "foo");
            message.clearProperties();
            MessagePropertyTest.assertEquals((String)"\ufffd3.5.7 A message's properties are deleted by the clearProperties method.\n", null, (String)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$objectweb$jtests$jms$conform$message$properties$MessagePropertyTest == null ? (class$org$objectweb$jtests$jms$conform$message$properties$MessagePropertyTest = MessagePropertyTest.class$("org.objectweb.jtests.jms.conform.message.properties.MessagePropertyTest")) : class$org$objectweb$jtests$jms$conform$message$properties$MessagePropertyTest);
    }

    public MessagePropertyTest(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

