/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxrpc.handler.ClientHandlerChain;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerRegistryImpl
implements HandlerRegistry {
    private static Logger log = Logger.getLogger(HandlerRegistryImpl.class);
    private Map<QName, HandlerChain> handlerChains = new HashMap<QName, HandlerChain>();
    private Map<QName, List<HandlerInfo>> handlerInfos = new HashMap<QName, List<HandlerInfo>>();
    private ServiceMetaData serviceMetaData;

    public HandlerRegistryImpl(ServiceMetaData serviceMetaData) {
        this.serviceMetaData = serviceMetaData;
    }

    public List getHandlerChain(QName portName) {
        List<HandlerInfo> list = this.handlerInfos.get(portName);
        if (list == null) {
            list = new ArrayList<HandlerInfo>();
        }
        return new ArrayList<HandlerInfo>(list);
    }

    public void setHandlerChain(QName portName, List chain) {
        this.registerClientHandlerChain(portName, chain, null);
    }

    HandlerChain getHandlerChainInstance(QName portName) {
        HandlerChain handlerChain = this.handlerChains.get(portName);
        return handlerChain;
    }

    void registerClientHandlerChain(QName portName, List<HandlerInfo> infos, Set<String> roles) {
        ClientHandlerChain chain = new ClientHandlerChain((List)infos, (Set)roles);
        this.handlerChains.put(portName, chain);
        this.handlerInfos.put(portName, infos);
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw new IllegalStateException("Cannot obtain endpoint meta data for: " + portName);
        }
        epMetaData.clearHandlers();
        for (HandlerInfo info : infos) {
            HandlerMetaDataJAXRPC handler = new HandlerMetaDataJAXRPC(HandlerMetaData.HandlerType.ENDPOINT);
            handler.setEndpointMetaData(epMetaData);
            handler.setHandlerClassName(info.getHandlerClass().getName());
            handler.setSoapRoles(roles);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add handler to: " + portName + handler));
            }
            epMetaData.addHandler(handler);
        }
    }
}

