/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.PageMasterReference;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;

public class RepeatablePageMasterReference
extends PageMasterReference
implements SubSequenceSpecifier {
    private static final int INFINITE = -1;
    private int maximumRepeats;
    private int numberConsumed = 0;

    public static FObj.Maker maker() {
        return new Maker();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RepeatablePageMasterReference(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (this.getProperty("master-reference") != null) {
            this.masterName = this.getProperty("master-reference").getString();
            if (!parent.getName().equals("fo:page-sequence-master")) throw new FOPException("A fo:repeatable-page-master-reference must be child of fo:page-sequence-master, not " + parent.getName(), systemId, line, column);
            PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)parent;
            pageSequenceMaster.addSubsequenceSpecifier(this);
        } else {
            this.log.warn("A fo:repeatable-page-master-reference does not have a master-reference and so is being ignored");
        }
        String mr = this.getProperty("maximum-repeats").getString();
        if (mr.equals("no-limit")) {
            this.maximumRepeats = -1;
            return;
        }
        try {
            this.maximumRepeats = Integer.parseInt(mr);
            if (this.maximumRepeats >= 0) return;
            this.log.debug("negative maximum-repeats: " + this.maximumRepeats);
            this.maximumRepeats = 0;
            return;
        }
        catch (NumberFormatException nfe) {
            throw new FOPException("Invalid number '" + mr + "'for 'maximum-repeats' property", systemId, line, column);
        }
    }

    public String getName() {
        return "fo:repeatable-page-master-reference";
    }

    public String getNextPageMasterName(boolean isOddPage, boolean isFirstPage, boolean isEmptyPage) {
        if (this.maximumRepeats != -1) {
            if (this.numberConsumed < this.maximumRepeats) {
                ++this.numberConsumed;
            } else {
                return null;
            }
        }
        return this.getMasterName();
    }

    public void reset() {
        this.numberConsumed = 0;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new RepeatablePageMasterReference(parent, propertyList, systemId, line, column);
        }
    }
}

