/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.detection.multicast;

import java.util.Date;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.transport.Connector;

public class SimpleDetectorServer {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;

    public void setupDetector() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MulticastDetector detector = new MulticastDetector();
        server.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
        detector.start();
        SimpleDetectorServer.println("MulticastDetector has been created and is listening for new NetworkRegistries to come online");
    }

    public void setupServer(String locatorURI) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        SimpleDetectorServer.println("Starting remoting server with locator uri of: " + locatorURI);
        Connector connector = new Connector();
        connector.setInvokerLocator(locator.getLocatorURI());
        connector.create();
        SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
        connector.addInvocationHandler("sample", invocationHandler);
        SimpleDetectorServer.println("Added our invocation handler; we are now ready to begin accepting messages from clients");
        connector.start();
    }

    public static void main(String[] args) {
        String prop = System.getProperty("args");
        if (prop != null) {
            try {
                transport = prop.substring(0, prop.indexOf("-"));
                port = Integer.parseInt(prop.substring(prop.indexOf("-") + 1));
            }
            catch (NumberFormatException nfe) {
                SimpleDetectorServer.println("INVALID ARGUMENTS: Bad port from property args: " + prop);
                System.exit(1);
            }
            catch (Exception e) {
                SimpleDetectorServer.println("INVALID ARGUMENTS: -Dargs property must be in the form '{socket|rmi}-{port#}': " + prop);
                System.exit(1);
            }
        }
        if (args != null && args.length != 0) {
            if (args.length == 2) {
                transport = args[0];
                port = Integer.parseInt(args[1]);
            } else {
                SimpleDetectorServer.println("INVALID ARGUMENTS: Usage: " + SimpleDetectorServer.class.getName() + " [rmi|socket <port>]");
                System.exit(1);
            }
        }
        SimpleDetectorServer.println("Starting JBoss/Remoting server... to stop this server, kill it manually via Control-C");
        String locatorURI = transport + "://" + host + ":" + port;
        SimpleDetectorServer.println("This server's endpoint will be: " + locatorURI);
        SimpleDetectorServer server = new SimpleDetectorServer();
        try {
            server.setupDetector();
            server.setupServer(locatorURI);
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SimpleDetectorServer.println("Stopping JBoss/Remoting server");
            return;
        }
    }

    public static void println(String msg) {
        System.out.println(new Date() + ": [SERVER]: " + msg);
    }

    public static class SampleInvocationHandler
    implements ServerInvocationHandler {
        public Object invoke(InvocationRequest invocation) throws Throwable {
            String msg = invocation.getParameter().toString();
            SimpleDetectorServer.println("RECEIVED A CLIENT MESSAGE: " + msg);
            String response = "Server received your message that said [" + msg + "]";
            if (msg.indexOf("Welcome") > -1) {
                response = "Received your welcome message.  Thank you!";
            }
            SimpleDetectorServer.println("Returning the following message back to the client: " + response);
            return response;
        }

        public void addListener(InvokerCallbackHandler callbackHandler) {
        }

        public void removeListener(InvokerCallbackHandler callbackHandler) {
        }

        public void setMBeanServer(MBeanServer server) {
        }

        public void setInvoker(ServerInvoker invoker) {
        }
    }
}

