/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.CommonAST;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Node;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.Lcs;
import de.hunsicker.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

final class JavadocPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new JavadocPrinter();
    private static final String DELIMETER = "|";
    private static final AST EMPTY_NODE = new CommonAST();
    private static final int NONE = 0;
    private static final int DESCRIPTION = 1;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String KEY_TAG_REMOVE_OBSOLETE = "TAG_REMOVE_OBSOLETE";
    private static final String KEY_TAG_ADD_MISSING = "TAG_ADD_MISSING";
    private static final String KEY_TAG_MISSPELLED_NAME = "TAG_MISSPELLED_NAME";
    private static final String KEY_GENERATE_COMMENT = "GENERATE_COMMENT";
    private static final String TAG_OPARA = "<p>";
    private static final String TAG_CPARA = "</p>";
    private static Pattern _pattern;
    private ThreadLocal _matcher = new ThreadLocal(){

        protected Object initialValue() {
            return new Perl5Matcher();
        }
    };
    private ThreadLocal _stringBreaker = new ThreadLocal(){

        protected Object initialValue() {
            return new BreakIterator();
        }
    };

    private JavadocPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) {
        throw new UnsupportedOperationException("use print(AST, AST, NodeWriter) instead");
    }

    public void print(AST node, AST comment, NodeWriter out) throws IOException {
        if ("<GENERATED_JAVADOC_COMMENT>".equals(comment.getText())) {
            String[] lines = StringHelper.split(comment.getFirstChild().getText(), DELIMETER);
            if (lines.length > 0) {
                out.state.args[0] = out.getFilename();
                out.state.args[1] = new Integer(out.line);
                out.state.args[2] = new Integer(out.getIndentLength() + 1);
                int i = 0;
                int size = lines.length - 1;
                while (i < size) {
                    out.print(lines[i], 6);
                    out.printNewline();
                    ++i;
                }
                out.print(lines[lines.length - 1], 6);
                Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.INFO, KEY_GENERATE_COMMENT, out.state.args, null);
            }
        } else if (!settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE, false)) {
            String[] lines = StringHelper.split(comment.getText(), out.originalLineSeparator);
            int i = 0;
            int size = lines.length - 1;
            while (i < size) {
                out.print(lines[i], 6);
                out.printNewline();
                ++i;
            }
            out.print(lines[lines.length - 1], 6);
        } else {
            out.print(this.getTopString(node.getType()), 6);
            String bottomText = this.getBottomString(node.getType());
            String asterix = bottomText.substring(0, bottomText.indexOf(42) + 1);
            asterix = this.getAsterix();
            AST firstTag = this.printDescriptionSection(node, comment, asterix, out);
            if (firstTag != EMPTY_NODE || settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS, false)) {
                this.printTagSection(node, comment, firstTag, asterix, out);
            }
            out.print(bottomText, 6);
        }
    }

    static List getValidTypeNames(AST node, int type) {
        switch (type) {
            case 24: {
                switch (node.getType()) {
                    case 12: 
                    case 13: {
                        break;
                    }
                    default: {
                        return Collections.EMPTY_LIST;
                    }
                }
                ArrayList<String> names = new ArrayList<String>(4);
                AST child = JavaNodeHelper.getFirstChild(node, type).getFirstChild();
                while (child != null) {
                    switch (child.getType()) {
                        case 25: {
                            names.add(JavaNodeHelper.getFirstChild(child, 68).getText());
                        }
                    }
                    child = child.getNextSibling();
                }
                return names;
            }
            case 90: {
                final ArrayList<String> names = new ArrayList<String>(3);
                AST exceptions = JavaNodeHelper.getFirstChild(node, type);
                if (exceptions != null) {
                    AST child = exceptions.getFirstChild();
                    while (child != null) {
                        switch (child.getType()) {
                            case 68: {
                                names.add(child.getText());
                            }
                        }
                        child = child.getNextSibling();
                    }
                }
                TreeWalker walker = new TreeWalker(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    public void visit(AST node) {
                        switch (node.getType()) {
                            case 102: {
                                switch (node.getFirstChild().getFirstChild().getType()) {
                                    case 146: {
                                        String name = node.getFirstChild().getFirstChild().getFirstChild().getText();
                                        JavaNode slist = ((JavaNode)node).getParent();
                                        if (JavadocPrinter.isEnclosedWithTry((JavaNode)node) || names.contains(name)) return;
                                        names.add(name);
                                    }
                                }
                                return;
                            }
                        }
                    }
                };
                walker.walk(node);
                return names;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static boolean isEnclosedWithTry(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 12: 
            case 13: {
                return false;
            }
            case 105: {
                AST next = parent.getFirstChild().getNextSibling();
                if (next != null) {
                    switch (next.getType()) {
                        case 106: {
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        switch (parent.getType()) {
            case 106: 
            case 107: {
                return JavadocPrinter.isEnclosedWithTry(parent.getParent());
            }
        }
        return JavadocPrinter.isEnclosedWithTry(parent);
    }

    private String getAsterix() {
        int asterix;
        String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, " * @param $paramType$ DOCUMENT ME!");
        int description = StringHelper.indexOfNonWhitespace(text, (asterix = text.indexOf(42)) + 1);
        if (description > -1) {
            return text.substring(0, description);
        }
        if (asterix > -1) {
            return text.substring(0, asterix + 1);
        }
        return AbstractPrinter.EMPTY_STRING;
    }

    private String getBottomString(int type) {
        switch (type) {
            case 13: {
                return settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM, " */");
            }
            case 12: {
                return settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM, " */");
            }
            case 14: {
                return " */";
            }
            case 18: {
                String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.lastIndexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(offset + 1);
                }
                return " */";
            }
            case 19: {
                String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.lastIndexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(offset + 1);
                }
                return " */";
            }
        }
        return " */";
    }

    private int getEmptySlotCount(List list) {
        int empty = 0;
        int i = 0;
        int size = list.size();
        while (i < size) {
            if (list.get(i) == null) {
                ++empty;
            }
            ++i;
        }
        return empty;
    }

    private String getMatch(String string, List list) {
        if (string == null) {
            return null;
        }
        if (list.contains(string)) {
            return string;
        }
        Lcs lcs = new Lcs();
        int i = 0;
        int size = list.size();
        while (i < size) {
            String tag = (String)list.get(i);
            lcs.init(string, tag);
            double similarity = lcs.getPercentage();
            if (similarity > 75.0) {
                return tag;
            }
            ++i;
        }
        return null;
    }

    private int getNextEmptySlot(List list) {
        int result = -1;
        int i = 0;
        int size = list.size();
        while (i < size) {
            if (list.get(i) == null) {
                return i;
            }
            ++i;
        }
        return result;
    }

    private int getParamCount(AST node) {
        int count = 0;
        AST param = JavaNodeHelper.getFirstChild(node, 24).getFirstChild();
        while (param != null) {
            ++count;
            param = param.getNextSibling();
        }
        return count;
    }

    private String getTagTemplateText(AST node, String typeName, int type, Environment environment) {
        switch (type) {
            case 18: {
                switch (node.getType()) {
                    case 13: {
                        String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, " * @param $paramType$ DOCUMENT ME!");
                    }
                    case 12: {
                        String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM, " * @param $paramType$ DOCUMENT ME!");
                        int offset = text.indexOf(42);
                        environment.set(Environment.Variable.TYPE_PARAM.getName(), typeName);
                        if (offset > -1) {
                            text = text.substring(offset + 1).trim();
                        }
                        text = environment.interpolate(text);
                        environment.unset(Environment.Variable.TYPE_PARAM.getName());
                        return text;
                    }
                }
                throw new IllegalArgumentException("invalid node type to add @param tag -- " + node);
            }
            case 16: 
            case 17: {
                switch (node.getType()) {
                    case 13: {
                        String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!");
                    }
                    case 12: {
                        String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!");
                        int offset = text.indexOf(42);
                        environment.set(Environment.Variable.TYPE_EXCEPTION.getName(), typeName);
                        if (offset > -1) {
                            text = text.substring(offset + 1).trim();
                        }
                        text = environment.interpolate(text);
                        environment.unset(Environment.Variable.TYPE_EXCEPTION.getName());
                        return text;
                    }
                }
                throw new IllegalArgumentException("invalid node type to add @throws tag -- " + node);
            }
            case 19: {
                switch (node.getType()) {
                    case 13: {
                        String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_RETURN, " * @return DOCUMENT ME!");
                        int offset = text.indexOf(42);
                        if (offset > -1) {
                            text = text.substring(offset + 1).trim();
                        }
                        return text;
                    }
                }
                throw new IllegalArgumentException("invalid node type to add @return tag -- " + node);
            }
        }
        return AbstractPrinter.EMPTY_STRING;
    }

    private String getTopString(int type) {
        switch (type) {
            case 13: {
                String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_TOP, "/**| * DOCUMENT ME!");
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return text;
            }
            case 12: {
                String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_TOP, "/**| * Creates a new $objectType$ object.");
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return text;
            }
            case 14: {
                return "/**";
            }
            case 18: {
                String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return "/**";
            }
            case 19: {
                String text = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return "/**";
            }
        }
        return "/**";
    }

    private boolean isValidNode(AST node) {
        switch (node.getType()) {
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                return true;
            }
            case 14: {
                return !JavaNodeHelper.isLocalVariable(node);
            }
        }
        return false;
    }

    private AST checkReturnTag(AST node, AST returnNode, NodeWriter out) {
        boolean needTag = false;
        AST child = node.getFirstChild();
        block3: while (child != null) {
            switch (child.getType()) {
                case 17: {
                    if (child.getFirstChild().getType() != 59) {
                        needTag = true;
                        break block3;
                    }
                }
                default: {
                    child = child.getNextSibling();
                }
            }
        }
        if (returnNode != null) {
            if (!needTag) {
                out.state.args[0] = out.getFilename();
                out.state.args[1] = new Integer(out.line);
                out.state.args[2] = new Integer(out.column);
                out.state.args[3] = "@return";
                out.state.args[4] = new Integer(((Node)returnNode).getStartLine());
                returnNode = null;
                Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_REMOVE_OBSOLETE, out.state.args, null);
            }
        } else if (needTag) {
            returnNode = this.createTag(node, 19, null, out.environment);
        }
        return returnNode;
    }

    private void checkTags(AST node, List tags, int type, String asterix, int last, NodeWriter out) {
        switch (node.getType()) {
            case 13: {
                if (!JavaNodeHelper.isAbstractMethod(node)) break;
                return;
            }
        }
        switch (type) {
            case 90: {
                if (settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS_THROWS, false)) break;
                return;
            }
        }
        List validNames = JavadocPrinter.getValidTypeNames(node, type);
        ArrayList validNamesCopy = new ArrayList(validNames);
        int capacity = (int)((double)tags.size() * 1.3);
        HashMap<String, AST> correct = new HashMap<String, AST>(capacity);
        ArrayList<AST> wrongOrObsolete = new ArrayList<AST>(capacity);
        int i = 0;
        int size = tags.size();
        while (i < size) {
            AST tag = (AST)tags.get(i);
            if (tag.getFirstChild() != null) {
                String description = tag.getFirstChild().getText().trim();
                String name = null;
                int offset = -1;
                offset = description.indexOf(32);
                name = offset > -1 ? description.substring(0, offset) : description;
                if (validNamesCopy.contains(name)) {
                    correct.put(name, tag);
                    validNamesCopy.remove(name);
                } else {
                    wrongOrObsolete.add(tag);
                }
            } else {
                switch (tag.getType()) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 20: {
                        wrongOrObsolete.add(tag);
                    }
                }
            }
            ++i;
        }
        ArrayList<Object> result = new ArrayList<Object>(validNames);
        Collections.fill(result, null);
        Iterator i2 = correct.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry entry = i2.next();
            result.set(validNames.indexOf(entry.getKey()), entry.getValue());
        }
        if (validNames.size() != tags.size()) {
            int i3 = 0;
            int size2 = wrongOrObsolete.size();
            while (i3 < size2) {
                int next = this.getNextEmptySlot(result);
                if (next == -1) {
                    int j = i3;
                    int s = wrongOrObsolete.size();
                    while (j < s) {
                        AST tag = (AST)wrongOrObsolete.get(j);
                        out.state.args[0] = out.getFilename();
                        out.state.args[1] = new Integer(out.line);
                        out.state.args[2] = new Integer(out.column);
                        out.state.args[3] = tag.getText();
                        out.state.args[4] = new Integer(((Node)tag).getStartLine());
                        out.state.args[5] = tag;
                        Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_REMOVE_OBSOLETE, out.state.args, null);
                        ++j;
                    }
                    break;
                }
                AST tag = (AST)wrongOrObsolete.get(i3);
                this.correctTagName(tag, validNames, next, asterix, last, out);
                result.set(next, tag);
                ++i3;
            }
            int emptySlots = validNames.size() - this.getEmptySlotCount(result);
            if (emptySlots < validNames.size()) {
                int i4 = emptySlots;
                int size3 = validNames.size();
                while (i4 < size3) {
                    int next = this.getNextEmptySlot(result);
                    String name = (String)validNames.get(next);
                    AST tag = null;
                    String tagName = null;
                    switch (type) {
                        case 24: {
                            tag = this.createTag(node, 18, name, out.environment);
                            result.set(next, tag);
                            tagName = "@param";
                            break;
                        }
                        case 90: {
                            tag = this.createTag(node, 16, name, out.environment);
                            result.set(next, tag);
                            tagName = "@throws";
                        }
                    }
                    out.state.args[0] = out.getFilename();
                    out.state.args[1] = new Integer(out.line + next + (this.shouldHaveNewlineBefore(tag, last) ? 1 : 0));
                    out.state.args[2] = new Integer(out.getIndentLength() + asterix.length() + 1);
                    out.state.args[3] = tagName;
                    out.state.args[4] = name;
                    Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_ADD_MISSING, out.state.args, null);
                    ++i4;
                }
            }
            tags.clear();
            tags.addAll(result);
        } else {
            ArrayList c = new ArrayList(correct.values());
            int i5 = 0;
            int size4 = result.size();
            while (i5 < size4) {
                AST tag = (AST)result.get(i5);
                if (tag == null || tag.getFirstChild() == null) {
                    AST wrongTag = (AST)wrongOrObsolete.remove(0);
                    this.correctTagName(wrongTag, validNames, i5, asterix, last, out);
                    tag = wrongTag;
                }
                tags.set(i5, tag);
                ++i5;
            }
        }
    }

    private int correctTagName(AST wrongTag, List validNames, int index, String asterix, int last, NodeWriter out) {
        AST child = wrongTag.getFirstChild();
        if (child != null) {
            String text = child.getText().trim();
            String oldName = null;
            int offset = -1;
            offset = text.indexOf(32);
            if (offset > -1) {
                oldName = text.substring(0, offset);
            } else {
                oldName = text;
                offset = text.length();
            }
            String match = this.getMatch(oldName, validNames);
            String newName = null;
            if (match != null) {
                newName = match;
                index = validNames.indexOf(match);
            } else {
                newName = (String)validNames.get(index);
            }
            out.state.args[0] = out.getFilename();
            out.state.args[1] = new Integer(out.line + index + (this.shouldHaveNewlineBefore(wrongTag, last) ? 1 : 0));
            out.state.args[2] = new Integer(out.getIndentLength() + asterix.length() + 1);
            out.state.args[3] = oldName;
            out.state.args[4] = newName;
            Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_MISSPELLED_NAME, out.state.args, null);
            text = " " + newName + text.substring(offset);
            child.setText(text);
        } else {
            String newName = (String)validNames.get(index);
            String text = " " + newName;
            Node c = new Node(40, text);
            wrongTag.setFirstChild(c);
        }
        return index;
    }

    private AST createTag(AST node, int type, String typeName, Environment environment) {
        Node tag = new Node(type, AbstractPrinter.EMPTY_STRING);
        if (typeName != null) {
            Node para = new Node(40, this.getTagTemplateText(node, typeName, type, environment));
            tag.setFirstChild(para);
        } else {
            Node description = new Node(40, this.getTagTemplateText(node, null, type, environment));
            tag.setFirstChild(description);
        }
        return tag;
    }

    private boolean hasInheritDoc(AST comment) {
        AST child = comment.getFirstChild();
        if (child != null) {
            switch (child.getType()) {
                case 28: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private String mergeChildren(AST node) {
        StringBuffer buf = new StringBuffer(150);
        AST child = node;
        while (child != null) {
            switch (child.getType()) {
                case 57: 
                case 59: 
                case 61: 
                case 75: 
                case 84: 
                case 86: 
                case 88: 
                case 90: 
                case 92: 
                case 94: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 120: 
                case 122: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild()));
                    break;
                }
                case 63: 
                case 65: 
                case 67: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild()));
                    buf.append(" ");
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    buf.append("{");
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild()));
                    buf.append("}");
                    break;
                }
                case 77: {
                    throw new IllegalStateException("<pre> tag not supported within tag description");
                }
                default: {
                    buf.append(child.getText());
                }
            }
            child = child.getNextSibling();
        }
        return buf.toString();
    }

    private void printBlockquote(AST node, String asterix, NodeWriter out) throws IOException {
        out.print(asterix, 40);
        out.print(node.getText(), 75);
        out.printNewline();
        this.printContent(node.getFirstChild(), asterix, out);
        out.print(asterix, 40);
        out.print("</blockquote>", 76);
        out.printNewline();
    }

    private void printComment(AST node, String asterix, NodeWriter out) throws IOException {
        String[] lines = this.split(node.getText(), Integer.MAX_VALUE, true);
        this.printCommentLines(lines, asterix, out, true);
    }

    private void printCommentLines(String[] lines, String asterix, NodeWriter out) throws IOException {
        this.printCommentLines(lines, asterix, out, false);
    }

    private void printCommentLines(String[] lines, String asterix, NodeWriter out, boolean trim) throws IOException {
        if (trim) {
            int i = 0;
            while (i < lines.length) {
                if (asterix != null) {
                    out.print(asterix, 40);
                }
                out.print(lines[i].trim(), 40);
                out.printNewline();
                ++i;
            }
        } else {
            int i = 0;
            while (i < lines.length) {
                if (asterix != null) {
                    out.print(asterix, 40);
                }
                out.print(lines[i], 40);
                out.printNewline();
                ++i;
            }
        }
    }

    private AST printContent(AST node, String asterix, NodeWriter out) throws IOException {
        AST next = EMPTY_NODE;
        AST child = node;
        block12: while (child != null) {
            block13: while (true) {
                switch (child.getType()) {
                    case 39: {
                        this.printComment(child, asterix, out);
                        break block13;
                    }
                    case 7: 
                    case 8: 
                    case 36: 
                    case 37: 
                    case 40: 
                    case 84: 
                    case 86: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 94: 
                    case 96: 
                    case 98: 
                    case 100: 
                    case 102: 
                    case 104: 
                    case 106: 
                    case 108: 
                    case 110: 
                    case 112: 
                    case 114: 
                    case 116: 
                    case 118: 
                    case 120: 
                    case 122: 
                    case 124: {
                        child = this.printText(child, asterix, out);
                        continue block13;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        child = this.printText(child, asterix, out);
                        continue block13;
                    }
                    case 55: {
                        this.printParagraph(child, asterix, out);
                        break block13;
                    }
                    case 75: {
                        this.printBlockquote(child, asterix, out);
                        break block13;
                    }
                    case 35: {
                        out.print(asterix, 40);
                        out.print(child.getText(), 35);
                        out.printNewline();
                        break block13;
                    }
                    case 41: 
                    case 43: 
                    case 45: 
                    case 47: 
                    case 49: 
                    case 51: {
                        this.printHeading(child, asterix, out);
                        break block13;
                    }
                    case 78: {
                        this.printTable(child, asterix, out);
                        break block13;
                    }
                    case 77: {
                        this.printPreformatted(child, asterix, out);
                        break block13;
                    }
                    case 57: 
                    case 59: 
                    case 61: {
                        this.printList(child, asterix, out);
                        break block13;
                    }
                    default: {
                        next = child;
                        break block12;
                    }
                }
                break;
            }
            child = child.getNextSibling();
        }
        return next;
    }

    private AST printDescriptionSection(AST node, AST comment, String asterix, NodeWriter out) throws IOException {
        switch (node.getType()) {
            case 14: {
                if (!settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_FIELDS_SHORT, true) || !this.printSingleLineDescription(node, comment, out)) break;
                return EMPTY_NODE;
            }
        }
        out.printNewline();
        return this.printContent(comment.getFirstChild(), asterix, out);
    }

    private void printHeading(AST node, String asterix, NodeWriter out) throws IOException {
        String[] lines = this.split(node.getText(), Integer.MAX_VALUE, false);
        this.printCommentLines(lines, asterix, out);
        out.last = 42;
    }

    private void printList(AST node, String asterix, NodeWriter out) throws IOException {
        out.print(asterix, 40);
        out.printNewline();
        out.print(asterix, 6);
        out.print(node.getText(), node.getType());
        out.printNewline();
        AST child = node.getFirstChild();
        while (child != null) {
            this.printListItem(child, asterix, out);
            if (child.getNextSibling() != null) {
                out.printNewline();
            }
            child = child.getNextSibling();
        }
        out.print(asterix, 40);
        switch (node.getType()) {
            case 57: {
                out.print("</ul>", 58);
                break;
            }
            case 59: {
                out.print("</ol>", 60);
                break;
            }
            case 61: {
                out.print("</dl>", 62);
            }
        }
        out.printNewline();
        if (node.getNextSibling() != null) {
            out.print(asterix, 6);
            out.printNewline();
        }
    }

    private void printListItem(AST node, String asterix, NodeWriter out) throws IOException {
        switch (node.getType()) {
            case 63: {
                out.print(asterix, 40);
                out.print("<li>", 63);
                out.printNewline();
                this.printContent(node.getFirstChild(), asterix, out);
                out.print(asterix, 40);
                out.print("</li>", 64);
                break;
            }
            case 65: {
                out.print(asterix, 40);
                out.print("<dt>", 65);
                out.printNewline();
                this.printContent(node.getFirstChild(), asterix, out);
                out.print(asterix, 40);
                out.print("</dt>", 66);
                break;
            }
            case 67: {
                out.print(asterix, 40);
                out.print("<dd>", 67);
                out.printNewline();
                this.printContent(node.getFirstChild(), asterix, out);
                out.print(asterix, 40);
                out.print("</dd>", 68);
            }
        }
    }

    private void printNewlineBefore(AST tag, int last, String asterix, NodeWriter out) throws IOException {
        if (this.shouldHaveNewlineBefore(tag, last)) {
            out.print(StringHelper.trimTrailing(asterix), 40);
            out.printNewline();
        }
    }

    private void printParagraph(AST node, String asterix, NodeWriter out) throws IOException {
        switch (out.last) {
            case 35: 
            case 40: 
            case 42: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 76: 
            case 77: 
            case 79: {
                out.print(asterix, 40);
                out.printNewline();
            }
        }
        out.print(asterix, 40);
        out.print(node.getText(), 55);
        if (node.getFirstChild() != null) {
            out.printNewline();
            AST child = node.getFirstChild();
            block10: while (child != null) {
                block11: while (true) {
                    switch (child.getType()) {
                        case 7: 
                        case 8: 
                        case 36: 
                        case 37: 
                        case 40: 
                        case 84: 
                        case 86: 
                        case 88: 
                        case 90: 
                        case 92: 
                        case 94: 
                        case 96: 
                        case 98: 
                        case 100: 
                        case 102: 
                        case 104: 
                        case 106: 
                        case 108: 
                        case 110: 
                        case 112: 
                        case 114: 
                        case 116: 
                        case 118: 
                        case 120: 
                        case 122: 
                        case 124: {
                            child = this.printText(child, asterix, out);
                            continue block11;
                        }
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: {
                            out.print("{", 7);
                            child = this.printText(child, asterix, out);
                            out.print("}", 8);
                            continue block11;
                        }
                        case 75: {
                            this.printBlockquote(child, asterix, out);
                            break block11;
                        }
                        case 77: {
                            this.printPreformatted(child, asterix, out);
                            break block11;
                        }
                        case 57: 
                        case 59: 
                        case 61: {
                            this.printList(child, asterix, out);
                            break block11;
                        }
                        default: {
                            break block10;
                        }
                    }
                    break;
                }
                child = child.getNextSibling();
            }
            out.print(asterix, 40);
            out.print(TAG_CPARA, 56);
        } else {
            out.print(TAG_CPARA, 56);
        }
        out.printNewline();
    }

    private void printPreformatted(AST node, String asterix, NodeWriter out) throws IOException {
        String[] lines = this.split(node.getText(), out.originalLineSeparator, '*');
        this.printCommentLines(lines, asterix, out);
        out.last = 77;
    }

    private int printReturnTag(AST tag, String asterix, int maxWidth, boolean added, int last, NodeWriter out) throws IOException {
        if (tag != null) {
            if (added) {
                out.state.args[0] = out.getFilename();
                out.state.args[1] = new Integer(out.line + (this.shouldHaveNewlineBefore(tag, last) ? 1 : 0));
                out.state.args[2] = new Integer(out.getIndentLength() + asterix.length() + 1);
                out.state.args[3] = "@return";
                out.state.args[4] = AbstractPrinter.EMPTY_STRING;
                Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_ADD_MISSING, out.state.args, null);
            }
            return this.printTag(tag, asterix, maxWidth, last, out);
        }
        return last;
    }

    private boolean printSingleLineDescription(AST node, AST comment, NodeWriter out) throws IOException {
        StringBuffer buf = new StringBuffer();
        int maxwidth = settings.getInt(ConventionKeys.LINE_LENGTH, 80) - 3 - out.getIndentLength();
        AST child = comment.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 32: 
                case 55: {
                    return false;
                }
                case 7: 
                case 8: 
                case 36: 
                case 37: 
                case 40: 
                case 124: {
                    buf.append(child.getText());
                    break;
                }
                case 84: 
                case 86: 
                case 88: 
                case 90: 
                case 92: 
                case 94: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 120: 
                case 122: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild()));
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    buf.append("{");
                    buf.append(child.getText());
                    AST part = child.getFirstChild();
                    while (part != null) {
                        buf.append(part.getText());
                        part = part.getNextSibling();
                    }
                    buf.append("}");
                }
            }
            if (buf.length() > maxwidth) {
                return false;
            }
            child = child.getNextSibling();
        }
        if (buf.length() < maxwidth) {
            out.print(" ", 6);
            out.print(buf.toString().trim(), 6);
            return true;
        }
        return false;
    }

    private void printTable(AST node, String asterix, NodeWriter out) throws IOException {
        out.print(asterix, 40);
        out.printNewline();
        out.print(asterix, 40);
        out.print(node.getText(), 78);
        out.printNewline();
        AST row = node.getFirstChild();
        while (row != null) {
            this.printTableRow(row, asterix, out);
            row = row.getNextSibling();
        }
        out.print(asterix, 40);
        out.print("</table>", 79);
        out.printNewline();
    }

    private void printTableData(AST node, String asterix, NodeWriter out) throws IOException {
        out.print(node.getText(), 11);
        out.printNewline();
        if (node.getFirstChild() != null) {
            this.printContent(node.getFirstChild(), asterix, out);
        }
        switch (node.getType()) {
            case 9: {
                out.print(asterix, 40);
                out.print("</th>", 10);
                break;
            }
            case 11: {
                out.print(asterix, 40);
                out.print("</td>", 12);
            }
        }
    }

    private void printTableRow(AST node, String asterix, NodeWriter out) throws IOException {
        out.print(asterix, 40);
        out.print(node.getText(), 82);
        AST cell = node.getFirstChild();
        while (cell != null) {
            this.printTableData(cell, asterix, out);
            cell = cell.getNextSibling();
        }
        out.print("</tr>", 83);
        out.printNewline();
    }

    private int printTag(AST tag, String asterix, int maxwidth, int last, NodeWriter out) throws IOException {
        if (tag != null) {
            this.printNewlineBefore(tag, last, asterix, out);
            out.print(asterix, 6);
            String ident = tag.getText();
            out.print(ident, 6);
            switch (tag.getType()) {
                case 25: {
                    AST child = tag.getFirstChild();
                    if (child == null) break;
                    String text = child.getText();
                    if (text.startsWith(" ") || text.startsWith("<")) {
                        out.print(" ", 6);
                    }
                    String description = this.mergeChildren(child);
                    out.print(description.trim(), 6);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 24: {
                    this.printTagDescription(tag.getFirstChild(), ident, asterix, maxwidth, true, out);
                    break;
                }
                default: {
                    this.printTagDescription(tag.getFirstChild(), ident, asterix, maxwidth, false, out);
                }
            }
            out.printNewline();
            return tag.getType();
        }
        return last;
    }

    private void printTagDescription(AST child, String name, String asterix, int maxwidth, boolean normalize, NodeWriter out) throws IOException {
        if (child != null) {
            MatchResult result;
            PatternMatcher matcher;
            if (child.getText().startsWith(" ") || child.getText().startsWith("<")) {
                out.print(" ", 6);
            }
            String description = this.mergeChildren(child);
            if (normalize && !description.startsWith("@") && (matcher = (PatternMatcher)this._matcher.get()).matches(description, _pattern) && (result = matcher.getMatch()).group(1) != null) {
                StringBuffer buf = new StringBuffer(description.length());
                buf.append(result.group(1));
                buf.append(" ");
                buf.append(result.group(2));
                description = buf.toString();
            }
            int length = name.length();
            String[] lines = this.split(description, maxwidth - length - 1, true);
            int i = 0;
            int size = lines.length - 1;
            while (i < size) {
                out.print(lines[i], 6);
                out.printNewline();
                out.print(asterix, 6);
                out.print(out.getString(length + 1), 153);
                ++i;
            }
            out.print(lines[lines.length - 1], 6);
        }
    }

    private void printTagSection(AST node, AST comment, AST firstTag, String asterix, NodeWriter out) throws IOException {
        ArrayList<AST> parameterTags = Collections.EMPTY_LIST;
        AST serialTag = null;
        AST serialDataTag = null;
        ArrayList<AST> serialFieldsTags = Collections.EMPTY_LIST;
        AST sinceTag = null;
        ArrayList<AST> seesTags = Collections.EMPTY_LIST;
        AST versionTag = null;
        ArrayList<AST> customTags = Collections.EMPTY_LIST;
        ArrayList<AST> authorTags = Collections.EMPTY_LIST;
        AST deprecatedTag = null;
        AST returnTag = null;
        ArrayList<AST> exceptionTags = Collections.EMPTY_LIST;
        boolean checkTags = settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS, false);
        if (checkTags) {
            checkTags = this.shouldCheckTags(node, comment);
        }
        AST tag = firstTag;
        while (tag != null) {
            switch (tag.getType()) {
                case 18: {
                    if (parameterTags.isEmpty()) {
                        parameterTags = new ArrayList<AST>(4);
                    }
                    parameterTags.add(tag);
                    break;
                }
                case 22: {
                    serialTag = tag;
                    break;
                }
                case 23: {
                    serialDataTag = tag;
                    break;
                }
                case 24: {
                    if (serialFieldsTags.isEmpty()) {
                        serialFieldsTags = new ArrayList<AST>(4);
                    }
                    serialFieldsTags.add(tag);
                    break;
                }
                case 21: {
                    sinceTag = tag;
                    break;
                }
                case 20: {
                    if (seesTags.isEmpty()) {
                        seesTags = new ArrayList<AST>(4);
                    }
                    seesTags.add(tag);
                    if (!checkTags || tag.getNextSibling() != null || tag != firstTag) break;
                    checkTags = false;
                    break;
                }
                case 25: {
                    versionTag = tag;
                    break;
                }
                case 15: {
                    deprecatedTag = tag;
                    break;
                }
                case 14: {
                    if (authorTags.isEmpty()) {
                        authorTags = new ArrayList<AST>(4);
                    }
                    authorTags.add(tag);
                    break;
                }
                case 19: {
                    returnTag = tag;
                    break;
                }
                case 16: 
                case 17: {
                    if (exceptionTags.isEmpty()) {
                        exceptionTags = new ArrayList<AST>(4);
                    }
                    exceptionTags.add(tag);
                    break;
                }
                case 13: 
                case 32: {
                    if (customTags.isEmpty()) {
                        customTags = new ArrayList<AST>(5);
                    }
                    customTags.add(tag);
                }
            }
            tag = tag.getNextSibling();
        }
        int maxwidth = settings.getInt(ConventionKeys.LINE_LENGTH, 80) - out.getIndentLength() - 3;
        int last = 0;
        if (comment.getFirstChild() != firstTag) {
            last = 1;
        } else if (checkTags) {
            out.print(asterix, 40);
            out.print("DOCUMENT ME!", 40);
            out.printNewline();
            last = 1;
        }
        boolean returnTagAdded = false;
        boolean checkParameterTags = false;
        boolean checkThrowsTags = false;
        switch (node.getType()) {
            case 18: 
            case 19: {
                last = this.printTags(authorTags, asterix, maxwidth, last, out);
                last = this.printTag(versionTag, asterix, maxwidth, last, out);
                last = this.printTag(serialTag, asterix, maxwidth, last, out);
                break;
            }
            case 14: {
                last = this.printTag(serialTag, asterix, maxwidth, last, out);
                last = this.printTags(serialFieldsTags, asterix, maxwidth, last, out);
                break;
            }
            case 13: {
                if (checkTags) {
                    boolean tagPresent = returnTag != null;
                    returnTag = this.checkReturnTag(node, returnTag, out);
                    returnTagAdded = !tagPresent && returnTag != null;
                }
            }
            case 12: {
                last = this.printTag(serialDataTag, asterix, maxwidth, last, out);
                if (this.getParamCount(node) > 0) {
                    if (checkTags) {
                        if (parameterTags.isEmpty()) {
                            parameterTags = new ArrayList(5);
                        }
                        checkParameterTags = true;
                    }
                    last = checkParameterTags ? this.printTags(parameterTags, asterix, maxwidth, node, 24, last, out) : this.printTags(parameterTags, asterix, maxwidth, last, out);
                }
                switch (node.getType()) {
                    case 13: {
                        last = this.printReturnTag(returnTag, asterix, maxwidth, returnTagAdded, last, out);
                    }
                }
                if (checkTags) {
                    if (exceptionTags.isEmpty()) {
                        exceptionTags = new ArrayList();
                    }
                    checkThrowsTags = true;
                }
                last = checkThrowsTags ? this.printTags(exceptionTags, asterix, maxwidth, node, 90, last, out) : this.printTags(exceptionTags, asterix, maxwidth, last, out);
            }
        }
        last = this.printTags(customTags, asterix, maxwidth, last, out);
        last = this.printTags(seesTags, asterix, maxwidth, last, out);
        last = this.printTag(sinceTag, asterix, maxwidth, last, out);
        last = this.printTag(deprecatedTag, asterix, maxwidth, last, out);
    }

    private int printTags(List tags, String asterix, int maxwidth, AST node, int tagType, int last, NodeWriter out) throws IOException {
        if (tagType != -1) {
            this.checkTags(node, tags, tagType, asterix, last, out);
        }
        return this.printTags(tags, asterix, maxwidth, last, out);
    }

    private int printTags(List tags, String asterix, int maxwidth, int last, NodeWriter out) throws IOException {
        int i = 0;
        int size = tags.size();
        while (i < size) {
            last = this.printTag((AST)tags.get(i), asterix, maxwidth, last, out);
            ++i;
        }
        return last;
    }

    private AST printText(AST node, String asterix, NodeWriter out) throws IOException {
        StringBuffer buf = new StringBuffer(200);
        AST next = EMPTY_NODE;
        AST child = node;
        block9: while (child != null) {
            switch (child.getType()) {
                case 39: {
                    this.printComment(child, asterix, out);
                    break;
                }
                case 7: 
                case 8: 
                case 36: 
                case 37: 
                case 40: 
                case 124: {
                    buf.append(child.getText());
                    break;
                }
                case 84: 
                case 86: 
                case 88: 
                case 90: 
                case 92: 
                case 94: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 120: 
                case 122: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild()));
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    buf.append("{");
                    buf.append(child.getText());
                    AST part = child.getFirstChild();
                    while (part != null) {
                        switch (part.getType()) {
                            case 120: {
                                buf.append(' ');
                            }
                        }
                        buf.append(part.getText());
                        part = part.getNextSibling();
                    }
                    buf.append("}");
                    break;
                }
                default: {
                    next = child;
                    break block9;
                }
            }
            child = child.getNextSibling();
        }
        if (buf.length() > 0) {
            int maxwidth = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
            this.printCommentLines(this.split(buf.toString().trim(), maxwidth - out.getIndentLength() - 3, true), asterix, out);
        }
        return next;
    }

    private boolean shouldCheckTags(AST node, AST comment) {
        return this.isValidNode(node) && !this.hasInheritDoc(comment);
    }

    private boolean shouldHaveNewlineBefore(AST tag, int last) {
        boolean result = false;
        block0 : switch (last) {
            case 1: {
                result = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                switch (tag.getType()) {
                    case 16: 
                    case 17: {
                        switch (last) {
                            case 16: 
                            case 17: {
                                break block0;
                            }
                        }
                        result = true;
                        break block0;
                    }
                    case 25: {
                        break block0;
                    }
                    case 13: 
                    case 14: 
                    case 18: 
                    case 32: {
                        if (last == tag.getType()) break block0;
                        result = true;
                        break block0;
                    }
                    case 19: {
                        result = true;
                        break block0;
                    }
                    case 20: {
                        if (last == tag.getType()) break block0;
                        result = true;
                        break block0;
                    }
                    default: {
                        switch (last) {
                            case 14: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 25: {
                                result = true;
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private String[] split(String str, String delim, char character) {
        if (character > '\uffffffff') {
            String line;
            int startOffset = 0;
            int endOffset = -1;
            int sepLength = delim.length();
            ArrayList<String> lines = new ArrayList<String>(15);
            while ((endOffset = str.indexOf(delim, startOffset)) > -1) {
                line = str.substring(startOffset, endOffset);
                lines.add(this.trimLeadingWhitespace(line, character));
                startOffset = endOffset + sepLength;
            }
            if (startOffset > 0) {
                line = this.trimLeadingWhitespace(str.substring(startOffset), character);
                lines.add(line);
            } else {
                lines.add(this.trimLeadingWhitespace(str, character));
            }
            return lines.toArray(EMPTY_STRING_ARRAY);
        }
        return StringHelper.split(str, delim);
    }

    private String[] split(String str, int width, boolean trim) {
        ArrayList<String> lines = new ArrayList<String>();
        if (trim) {
            str = str.trim();
        }
        if (str.length() < width) {
            lines.add(str);
        } else {
            BreakIterator iterator = (BreakIterator)this._stringBreaker.get();
            try {
                iterator.setText(str);
                int lineStart = 0;
                int nextStart = iterator.next();
                int prevStart = 0;
                block5: while (true) {
                    if (nextStart - lineStart < width && nextStart != -10) {
                        prevStart = nextStart;
                        nextStart = iterator.next();
                        switch (iterator._type) {
                            case 2: {
                                prevStart = nextStart + 4;
                                break;
                            }
                            default: {
                                continue block5;
                            }
                        }
                    }
                    if (prevStart == 0) {
                        prevStart = nextStart;
                    }
                    if (nextStart == -10) {
                        if (prevStart - lineStart + (str.length() - prevStart) < width) {
                            lines.add(str.substring(lineStart, str.length()).trim());
                        } else if (prevStart > 0 && prevStart != -10) {
                            if (trim) {
                                lines.add(str.substring(lineStart, prevStart).trim());
                                lines.add(str.substring(prevStart).trim());
                            } else {
                                lines.add(str.substring(lineStart, prevStart));
                                lines.add(str.substring(prevStart));
                            }
                        } else if (trim) {
                            lines.add(str.substring(lineStart).trim());
                        } else {
                            lines.add(str.substring(lineStart));
                        }
                        prevStart = str.length();
                    } else if (trim) {
                        lines.add(str.substring(lineStart, prevStart).trim());
                    } else {
                        lines.add(str.substring(lineStart, prevStart));
                    }
                    lineStart = prevStart;
                    prevStart = 0;
                    if (lineStart >= str.length()) break;
                }
                Object var10_9 = null;
                iterator.reset();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                iterator.reset();
                throw throwable;
            }
        }
        return lines.toArray(new String[0]);
    }

    private String trimLeadingWhitespace(String str, char character) {
        int off = StringHelper.indexOfNonWhitespace(str);
        if (off > -1 && str.charAt(off) == character) {
            return str.substring(off + 1);
        }
        return str;
    }

    static {
        try {
            _pattern = new Perl5Compiler().compile("(?: )*([a-zA-z0-9_.]*)\\s*(.*)", 32768);
        }
        catch (MalformedPatternException malformedPatternException) {
            // empty catch block
        }
    }

    private static class BreakIterator {
        private static final int WHITESPACE = 1;
        private static final int BREAK = 2;
        public static final int DONE = -10;
        private static final String TAG_BREAK = "<br>";
        private static final String TAG_BREAK_WELL = "<br/>";
        private String _text;
        private int _end = -1;
        private int _pos = -1;
        private int _type;

        public int getBreakType() {
            return this._type;
        }

        public void setText(String text) {
            this._text = text;
        }

        public int next() {
            this._type = 1;
            this._pos = this._text.indexOf(32, this._end + 1);
            if (this._pos > -1) {
                int br;
                int tab = this._text.indexOf(9, this._end + 1);
                if (tab > -1 && tab < this._pos) {
                    this._pos = tab;
                }
                if ((br = this._text.indexOf(TAG_BREAK, this._end + 1)) == -1) {
                    br = this._text.indexOf(TAG_BREAK_WELL, this._end + 1);
                }
                if (br > -1 && br < this._pos) {
                    this._pos = br;
                    this._type = 2;
                }
            }
            if (this._pos == -1) {
                return -10;
            }
            this._end = this._pos;
            return this._pos;
        }

        public void reset() {
            this._text = null;
            this._end = -1;
            this._pos = -1;
        }
    }
}

