/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.CurrentStyle;
import com.icesoft.faces.renderkit.ApplicationBaseLocator;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class FormRenderer
extends DomBasicRenderer {
    public static final String COMMAND_LINK_HIDDEN_FIELD = "command_link_hidden_field";
    private static final String COMMAND_LINK_HIDDEN_FIELDS_KEY = "com.icesoft.faces.FormRequiredHidden";
    public static final String FOCUS_HIDDEN_FIELD = "focus_hidden_field";
    public static final String ICE_FACES_ID_HIDDEN_FIELD = "icefacesID";
    public static final String VIEWNUMBER_HIDDEN_FIELD = "viewNumber";
    private static final Log log = LogFactory.getLog((Class)FormRenderer.class);
    static final String jsfSetFunction = " function jsfSet(id,value) {  Packages.com.icesoft.faces.webapp.dombrowser.JavaScriptBridge.decodeSubmittedValue(id,value);  } ";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        this.validateParameters(facesContext, uiComponent, UIForm.class);
        UIForm uiForm = (UIForm)uiComponent;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String formClientId = uiForm.getClientId(facesContext);
        if (requestParameterMap.containsKey(formClientId) || uiComponent.getAttributes().containsKey("fileUploaded")) {
            uiForm.setSubmitted(true);
        } else {
            uiForm.setSubmitted(false);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element root;
        this.validateParameters(facesContext, uiComponent, UIForm.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            String acceptcharset;
            root = domContext.createElement("form");
            String includeServletPath = (String)facesContext.getExternalContext().getRequestMap().get("javax.servlet.include.servlet_path");
            if (includeServletPath != null) {
                Element d2dJSElement = domContext.getDocument().createElement("script");
                String base = ApplicationBaseLocator.locate(facesContext);
                d2dJSElement.setAttribute("src", base + "xmlhttp/icefaces-d2d.js");
                d2dJSElement.setAttribute("type", "text/javascript");
                root.appendChild(d2dJSElement);
            }
            domContext.setRootNode(root);
            String formClientId = uiComponent.getClientId(facesContext);
            root.setAttribute("id", formClientId);
            root.setAttribute("method", "post");
            String action = null;
            action = "iceSubmit('" + formClientId + "');";
            root.setAttribute("action", action);
            String styleClass = (String)uiComponent.getAttributes().get("styleClass");
            if (styleClass != null) {
                root.setAttribute("class", styleClass);
            }
            if ((acceptcharset = (String)uiComponent.getAttributes().get("acceptcharset")) != null) {
                root.setAttribute("accept-charset", acceptcharset);
            }
            Element formHiddenField = domContext.createElement("input");
            formHiddenField.setAttribute("type", "hidden");
            formHiddenField.setAttribute("name", formClientId);
            formHiddenField.setAttribute("value", formClientId);
            root.appendChild(formHiddenField);
            Element cssUpdateField = domContext.createElement("input");
            cssUpdateField.setAttribute("type", "hidden");
            cssUpdateField.setAttribute("name", CurrentStyle.CSS_UPDATE_FIELD);
            cssUpdateField.setAttribute("value", "");
            root.appendChild(cssUpdateField);
            if (!domContext.isStreamWriting()) {
                Element viewNumberElement = domContext.createElement("input");
                viewNumberElement.setAttribute("type", "hidden");
                viewNumberElement.setAttribute("name", VIEWNUMBER_HIDDEN_FIELD);
                viewNumberElement.setAttribute("value", ((BridgeFacesContext)facesContext).getViewNumber());
                root.appendChild(viewNumberElement);
                Element icefacesIDElement = domContext.createElement("input");
                icefacesIDElement.setAttribute("type", "hidden");
                icefacesIDElement.setAttribute("name", ICE_FACES_ID_HIDDEN_FIELD);
                icefacesIDElement.setAttribute("value", ((BridgeFacesContext)facesContext).getIceFacesId());
                root.appendChild(icefacesIDElement);
            }
        }
        root = (Element)domContext.getRootNode();
        String conversationId = SeamUtilities.getSeamConversationId();
        if (conversationId != null) {
            String conversationParamName = SeamUtilities.getConversationIdParameterName();
            Element conversationIDElement = domContext.createElement("input");
            if (log.isTraceEnabled()) {
                log.trace((Object)("Embedding Seam Param - name: " + conversationParamName + ", value: " + conversationId));
            }
            conversationIDElement.setAttribute("type", "hidden");
            conversationIDElement.setAttribute("name", conversationParamName);
            conversationIDElement.setAttribute("value", conversationId);
            root.appendChild(conversationIDElement);
        }
        String contextClass = facesContext.getClass().toString();
        root.setAttribute("context_type", contextClass);
        PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null);
        facesContext.getApplication().getViewHandler().writeState(facesContext);
        String userDefinedValue = root.getAttribute("onsubmit");
        if (userDefinedValue == null || userDefinedValue.equalsIgnoreCase("")) {
            root.setAttribute("onsubmit", "return false;");
        }
        FormRenderer.addHiddenField(facesContext, FOCUS_HIDDEN_FIELD);
        try {
            domContext.startNode(facesContext, uiComponent, root);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        domContext.stepInto(uiComponent);
    }

    private Text createJsfSetFunction(DOMContext domContext) {
        Text jsfSet = domContext.getDocument().createTextNode(jsfSetFunction);
        return jsfSet;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
        this.validateParameters(facesContext, uiComponent, UIForm.class);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UIForm.class);
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        FormRenderer.renderCommandLinkHiddenFields(facesContext, uiComponent);
        domContext.stepOver();
        domContext.endNode(facesContext, uiComponent, domContext.getRootNode());
    }

    private static void renderCommandLinkHiddenFields(FacesContext facesContext, UIComponent uiComponent) {
        Map commandLinkHiddenFields = FormRenderer.getCommandLinkFields(facesContext);
        if (commandLinkHiddenFields != null) {
            FormRenderer.removePreviousCommandLinkHiddenFields(uiComponent, facesContext);
            FormRenderer.renderRequiredCommandLinkHiddenFields(uiComponent, facesContext, commandLinkHiddenFields);
            FormRenderer.resetCommandLinkFieldsInRequestMap(facesContext);
        }
    }

    private static void resetCommandLinkFieldsInRequestMap(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.put(COMMAND_LINK_HIDDEN_FIELDS_KEY, null);
    }

    private static void renderRequiredCommandLinkHiddenFields(UIComponent uiComponent, FacesContext facesContext, Map map) {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element root = (Element)domContext.getRootNode();
        Iterator commandLinkFields = map.entrySet().iterator();
        while (commandLinkFields.hasNext()) {
            Map.Entry nextField = commandLinkFields.next();
            if (!COMMAND_LINK_HIDDEN_FIELD.equals(nextField.getValue())) continue;
            Element next = domContext.createElement("input");
            next.setAttribute("type", "hidden");
            next.setAttribute("name", nextField.getKey().toString());
            next.setAttribute(COMMAND_LINK_HIDDEN_FIELD, COMMAND_LINK_HIDDEN_FIELD);
            root.appendChild(next);
        }
    }

    private static void removePreviousCommandLinkHiddenFields(UIComponent uiComponent, FacesContext facesContext) {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element root = (Element)domContext.getRootNode();
        Node lastChild = root.getLastChild();
        while (lastChild != null) {
            Node previous = lastChild.getPreviousSibling();
            if (lastChild instanceof Element && ((Element)lastChild).getAttribute(COMMAND_LINK_HIDDEN_FIELD) != null && ((Element)lastChild).getAttribute(COMMAND_LINK_HIDDEN_FIELD).equalsIgnoreCase(COMMAND_LINK_HIDDEN_FIELD)) {
                root.removeChild(lastChild);
            }
            lastChild = previous;
        }
    }

    public static void addHiddenField(FacesContext facesContext, String fieldName) {
        FormRenderer.addHiddenField(facesContext, fieldName, COMMAND_LINK_HIDDEN_FIELD);
    }

    private static void addHiddenField(FacesContext facesContext, String fieldName, String value) {
        Map hiddenFieldMap = FormRenderer.getCommandLinkFields(facesContext);
        if (hiddenFieldMap == null) {
            hiddenFieldMap = FormRenderer.createCommandLinkFieldsOnRequestMap(facesContext);
        }
        if (!hiddenFieldMap.containsKey(fieldName)) {
            hiddenFieldMap.put(fieldName, value);
        }
    }

    private static Map getCommandLinkFields(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        HashMap hiddenFieldMap = (HashMap)requestMap.get(COMMAND_LINK_HIDDEN_FIELDS_KEY);
        if (hiddenFieldMap == null) {
            hiddenFieldMap = new HashMap();
            requestMap.put(COMMAND_LINK_HIDDEN_FIELDS_KEY, hiddenFieldMap);
        }
        return hiddenFieldMap;
    }

    private static Map createCommandLinkFieldsOnRequestMap(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        HashMap hiddenFieldMap = (HashMap)requestMap.get(COMMAND_LINK_HIDDEN_FIELDS_KEY);
        if (hiddenFieldMap == null) {
            hiddenFieldMap = new HashMap();
            requestMap.put(COMMAND_LINK_HIDDEN_FIELDS_KEY, hiddenFieldMap);
        }
        return hiddenFieldMap;
    }
}

