/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.SelectManyCheckboxListRenderer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class RadioRenderer
extends SelectManyCheckboxListRenderer {
    protected void renderOption(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean renderVertically, Element rootTR, int counter, Object componentValue) throws IOException {
        String itemLabel;
        Object selectItemValue;
        UISelectOne uiSelectOne = (UISelectOne)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, (UIComponent)uiSelectOne);
        Element rootTable = (Element)domContext.getRootNode();
        Object submittedValue = uiSelectOne.getSubmittedValue();
        if (submittedValue == null) {
            submittedValue = componentValue;
        }
        if (renderVertically) {
            rootTR = domContext.createElement("tr");
            rootTable.appendChild(rootTR);
        }
        String labelClass = null;
        boolean disabled = false;
        if (uiSelectOne.getAttributes().get("disabled") != null && uiSelectOne.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            disabled = true;
        }
        if (selectItem.isDisabled()) {
            disabled = true;
        }
        if ((labelClass = (String)uiSelectOne.getAttributes().get("styleClass")) != null && disabled) {
            labelClass = labelClass + "-dis";
        }
        Element td = domContext.createElement("td");
        rootTR.appendChild(td);
        Element input = domContext.createElement("input");
        td.appendChild(input);
        input.setAttribute("type", "radio");
        if (disabled) {
            input.setAttribute("disabled", "disabled");
        }
        HashSet<String> excludes = new HashSet<String>();
        String accesskey = (String)uiComponent.getAttributes().get("accesskey");
        if (accesskey != null) {
            input.setAttribute("accesskey", accesskey);
            excludes.add("accesskey");
        }
        if ((selectItemValue = selectItem.getValue()) != null && String.valueOf(selectItemValue).equals(String.valueOf(componentValue))) {
            input.setAttribute("checked", "checked");
        } else {
            input.removeAttribute("checked");
        }
        input.setAttribute("name", uiSelectOne.getClientId(facesContext));
        input.setAttribute("id", uiComponent.getClientId(facesContext) + ":_" + counter);
        input.setAttribute("value", this.formatComponentValue(facesContext, (UIComponent)uiSelectOne, selectItem.getValue()));
        this.addJavaScript(facesContext, (UIComponent)uiSelectOne, input, excludes);
        excludes.add("style");
        excludes.add("readonly");
        excludes.add("disabled");
        PassThruAttributeRenderer.renderAttributes(facesContext, (UIComponent)uiSelectOne, RadioRenderer.getExcludesArray(excludes));
        Element label = domContext.createElement("label");
        td.appendChild(label);
        if (labelClass != null) {
            label.setAttribute("class", labelClass);
        }
        if ((itemLabel = selectItem.getLabel()) != null) {
            Text labelText = domContext.getDocument().createTextNode(itemLabel);
            label.appendChild(labelText);
        }
    }

    protected void addJavaScript(FacesContext facesContext, UIComponent uiSelectOne, Element input, Set excludes) {
    }
}

