/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ejb.packaging.ExplodedJarVisitor;
import org.hibernate.ejb.packaging.FileZippedJarVisitor;
import org.hibernate.ejb.packaging.InputStreamZippedJarVisitor;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JarVisitor {
    private static Log log = LogFactory.getLog(JarVisitor.class);
    protected String unqualifiedJarName;
    protected URL jarUrl;
    private boolean done = false;
    private List<Filter> filters = new ArrayList<Filter>();
    private Set<FileFilter> fileFilters = new HashSet<FileFilter>();
    private Set<JavaElementFilter> classFilters = new HashSet<JavaElementFilter>();
    private Set<JavaElementFilter> packageFilters = new HashSet<JavaElementFilter>();
    private Set[] entries;

    public static final URL getJarURLFromURLEntry(URL url, String entry) throws IllegalArgumentException {
        URL jarUrl;
        String file = url.getFile();
        if (!entry.startsWith("/")) {
            entry = "/" + entry;
        }
        if ((file = file.substring(0, file.length() - entry.length())).endsWith("!")) {
            file = file.substring(0, file.length() - 1);
        }
        try {
            String protocol = url.getProtocol();
            jarUrl = "jar".equals(protocol) || "wsjar".equals(protocol) ? new URL(file) : ("zip".equals(protocol) ? new URL("file", null, file) : ("code-source".equals(url.getProtocol()) ? new File(file).toURL() : new URL(protocol, url.getHost(), url.getPort(), file)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to determine JAR Url from " + url + ". Cause: " + e.getMessage());
        }
        return jarUrl;
    }

    public static final JarVisitor getVisitor(URL jarUrl, Filter[] filters) throws IllegalArgumentException {
        String protocol = jarUrl.getProtocol();
        if ("jar".equals(protocol)) {
            return new InputStreamZippedJarVisitor(jarUrl, filters);
        }
        if (StringHelper.isEmpty((String)protocol) || "file".equals(protocol)) {
            File file;
            try {
                file = new File(jarUrl.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to visit JAR " + jarUrl + ". Cause: " + e.getMessage());
            }
            if (file.isDirectory()) {
                return new ExplodedJarVisitor(jarUrl, filters);
            }
            return new FileZippedJarVisitor(jarUrl, filters);
        }
        return new InputStreamZippedJarVisitor(jarUrl, filters);
    }

    private JarVisitor(String jarPath) {
        URL jarUrl;
        try {
            jarUrl = new URL(jarPath);
        }
        catch (MalformedURLException e) {
            try {
                jarUrl = new URL("file:" + jarPath);
            }
            catch (MalformedURLException ee) {
                throw new IllegalArgumentException("Unable to find jar:" + jarPath, ee);
            }
        }
        this.jarUrl = jarUrl;
        this.unqualify();
    }

    protected JarVisitor(String fileName, Filter[] filters) {
        this(fileName);
        this.initFilters(filters);
    }

    private void initFilters(Filter[] filters) {
        for (Filter filter : filters) {
            if (filter instanceof FileFilter) {
                this.fileFilters.add((FileFilter)filter);
            } else if (filter instanceof ClassFilter) {
                this.classFilters.add((ClassFilter)filter);
            } else if (filter instanceof PackageFilter) {
                this.packageFilters.add((PackageFilter)filter);
            } else {
                throw new AssertionError((Object)("Unknown filter type: " + filter.getClass().getName()));
            }
            this.filters.add(filter);
        }
        int size = this.filters.size();
        this.entries = new Set[size];
        for (int index = 0; index < size; ++index) {
            this.entries[index] = new HashSet();
        }
    }

    protected JarVisitor(URL url, Filter[] filters) {
        this(url);
        this.initFilters(filters);
    }

    public static final JarVisitor getVisitor(String jarPath, Filter[] filters) throws IllegalArgumentException {
        File file = new File(jarPath);
        if (file.isFile()) {
            return new InputStreamZippedJarVisitor(jarPath, filters);
        }
        return new ExplodedJarVisitor(jarPath, filters);
    }

    private JarVisitor(URL url) {
        this.jarUrl = url;
        this.unqualify();
    }

    protected void unqualify() {
        String fileName = this.jarUrl.getFile();
        int slash = fileName.lastIndexOf("/");
        if (slash != -1) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
        }
        if (fileName.length() > 4 && fileName.endsWith("ar") && fileName.charAt(fileName.length() - 4) == '.') {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        this.unqualifiedJarName = fileName;
        log.debug((Object)("Searching mapped entities in jar/par: " + this.jarUrl));
    }

    public String getUnqualifiedJarName() {
        return this.unqualifiedJarName;
    }

    public Filter[] getFilters() {
        return this.filters.toArray(new Filter[this.filters.size()]);
    }

    public final Set[] getMatchingEntries() throws IOException {
        if (!this.done) {
            if (this.filters.size() > 0) {
                this.doProcessElements();
            }
            this.done = true;
        }
        return this.entries;
    }

    protected abstract void doProcessElements() throws IOException;

    protected final void addElement(String entryName, InputStream is, InputStream secondIs) throws IOException {
        if (entryName.endsWith("package-info.class")) {
            String name = entryName.substring(0, entryName.length() - ".package-info.class".length()).replace('/', '.');
            this.executeJavaElementFilter(name, this.packageFilters, is, secondIs);
        } else if (entryName.endsWith(".class")) {
            String name = entryName.substring(0, entryName.length() - ".class".length()).replace('/', '.');
            log.debug((Object)("Filtering: " + name));
            this.executeJavaElementFilter(name, this.classFilters, is, secondIs);
        } else {
            String name = entryName;
            boolean accepted = false;
            for (FileFilter filter : this.fileFilters) {
                InputStream localIs;
                if (!filter.accept(name)) continue;
                accepted = true;
                if (filter.getStream()) {
                    localIs = secondIs;
                } else {
                    localIs = null;
                    secondIs.close();
                }
                is.close();
                log.debug((Object)("File Filter matched for " + name));
                Entry entry = new Entry(name, localIs);
                int index = this.filters.indexOf(filter);
                this.entries[index].add(entry);
            }
            if (!accepted) {
                is.close();
                secondIs.close();
            }
        }
    }

    private void executeJavaElementFilter(String name, Set<JavaElementFilter> filters, InputStream is, InputStream secondIs) throws IOException {
        boolean accepted = false;
        for (JavaElementFilter filter : filters) {
            InputStream localIs;
            boolean match;
            if (!filter.accept(name) || !(match = this.checkAnnotationMatching(is, filter))) continue;
            accepted = true;
            if (filter.getStream()) {
                localIs = secondIs;
            } else {
                localIs = null;
                secondIs.close();
            }
            log.debug((Object)("Java element filter matched for " + name));
            Entry entry = new Entry(name, localIs);
            int index = this.filters.indexOf(filter);
            this.entries[index].add(entry);
            break;
        }
        if (!accepted) {
            is.close();
            secondIs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAnnotationMatching(InputStream is, JavaElementFilter filter) throws IOException {
        if (filter.getAnnotations().length == 0) {
            is.close();
            return true;
        }
        DataInputStream dstream = new DataInputStream(is);
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
        }
        finally {
            dstream.close();
            is.close();
        }
        boolean match = false;
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null) {
            for (Class annotation : filter.getAnnotations()) {
                boolean bl = match = visible.getAnnotation(annotation.getName()) != null;
                if (match) break;
            }
        }
        return match;
    }

    public static class Entry {
        private String name;
        private InputStream is;

        public Entry(String name, InputStream is) {
            this.name = name;
            this.is = is;
        }

        public String getName() {
            return this.name;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.name.equals(entry.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static abstract class PackageFilter
    extends JavaElementFilter {
        protected PackageFilter(boolean retrieveStream, Class[] annotations) {
            super(retrieveStream, annotations);
        }
    }

    public static abstract class ClassFilter
    extends JavaElementFilter {
        protected ClassFilter(boolean retrieveStream, Class[] annotations) {
            super(retrieveStream, annotations);
        }
    }

    public static abstract class JavaElementFilter
    extends Filter {
        private Class[] annotations;

        protected JavaElementFilter(boolean retrieveStream, Class[] annotations) {
            super(retrieveStream);
            this.annotations = annotations == null ? new Class[]{} : annotations;
        }

        public Class[] getAnnotations() {
            return this.annotations;
        }

        public abstract boolean accept(String var1);
    }

    public static abstract class FileFilter
    extends Filter {
        public FileFilter(boolean retrieveStream) {
            super(retrieveStream);
        }

        public abstract boolean accept(String var1);
    }

    public static abstract class Filter {
        private boolean retrieveStream;

        protected Filter(boolean retrieveStream) {
            this.retrieveStream = retrieveStream;
        }

        public boolean getStream() {
            return this.retrieveStream;
        }
    }
}

