/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import com.sun.tools.javah.Main;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Javah
extends Task {
    private static final String FAIL_MSG = "Compile failed, messages should have been provided.";
    private Vector classes = new Vector(2);
    private String cls;
    private File destDir;
    private Path classpath = null;
    private File outputFile = null;
    private boolean verbose = false;
    private boolean force = false;
    private boolean old = false;
    private boolean stubs = false;
    private Path bootclasspath;
    private static String lSep;

    public void setClass(String cls) {
        this.cls = cls;
    }

    public ClassArgument createClass() {
        ClassArgument ga = new ClassArgument();
        this.classes.addElement(ga);
        return ga;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setClasspath(Path src) {
        if (this.classpath == null) {
            this.classpath = src;
        } else {
            this.classpath.append(src);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setBootclasspath(Path src) {
        if (this.bootclasspath == null) {
            this.bootclasspath = src;
        } else {
            this.bootclasspath.append(src);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.project);
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference r) {
        this.createBootclasspath().setRefid(r);
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setOld(boolean old) {
        this.old = old;
    }

    public void setStubs(boolean stubs) {
        this.stubs = stubs;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void execute() throws BuildException {
        String compiler;
        if (this.cls == null && this.classes.size() == 0) {
            throw new BuildException("class attribute must be set!", this.location);
        }
        if (this.cls != null && this.classes.size() > 0) {
            throw new BuildException("set class attribute or class element, not both.", this.location);
        }
        if (this.destDir != null) {
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.location);
            }
            if (this.outputFile != null) {
                throw new BuildException("destdir and outputFile are mutually exclusive", this.location);
            }
        }
        if (this.classpath == null) {
            this.classpath = Path.systemClasspath;
        }
        if ((compiler = this.project.getProperty("build.compiler")) == null) {
            compiler = !JavaEnvUtils.isJavaVersion((String)"1.1") && !JavaEnvUtils.isJavaVersion((String)"1.2") ? "modern" : "classic";
        }
        this.doClassicCompile();
    }

    private void doClassicCompile() throws BuildException {
        Commandline cmd = this.setupJavahCommand();
        try {
            Main main = new Main(cmd.getArguments());
            main.run();
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)((Object)ex);
            }
            throw new BuildException("Error starting javah: " + ex, (Throwable)ex, this.location);
        }
    }

    private Commandline setupJavahCommand() {
        Commandline cmd = new Commandline();
        if (this.destDir != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.destDir);
        }
        if (this.outputFile != null) {
            cmd.createArgument().setValue("-o");
            cmd.createArgument().setFile(this.outputFile);
        }
        if (this.classpath != null) {
            cmd.createArgument().setValue("-classpath");
            cmd.createArgument().setPath(this.classpath);
        }
        if (JavaEnvUtils.isJavaVersion((String)"1.1")) {
            if (this.verbose) {
                cmd.createArgument().setValue("-v");
            }
        } else {
            if (this.verbose) {
                cmd.createArgument().setValue("-verbose");
            }
            if (this.old) {
                cmd.createArgument().setValue("-old");
            }
            if (this.force) {
                cmd.createArgument().setValue("-force");
            }
        }
        if (this.stubs) {
            if (!this.old) {
                throw new BuildException("stubs only available in old mode.", this.location);
            }
            cmd.createArgument().setValue("-stubs");
        }
        if (this.bootclasspath != null) {
            cmd.createArgument().setValue("-bootclasspath");
            cmd.createArgument().setPath(this.bootclasspath);
        }
        this.logAndAddFilesToCompile(cmd);
        return cmd;
    }

    protected void logAndAddFilesToCompile(Commandline cmd) {
        int n = 0;
        this.log("Compilation " + cmd.describeArguments(), 3);
        StringBuffer niceClassList = new StringBuffer();
        if (this.cls != null) {
            StringTokenizer tok = new StringTokenizer(this.cls, ",", false);
            while (tok.hasMoreTokens()) {
                String aClass = tok.nextToken().trim();
                cmd.createArgument().setValue(aClass);
                niceClassList.append("    " + aClass + lSep);
                ++n;
            }
        }
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            ClassArgument arg = (ClassArgument)enumeration.nextElement();
            String aClass = arg.getName();
            cmd.createArgument().setValue(aClass);
            niceClassList.append("    " + aClass + lSep);
            ++n;
        }
        StringBuffer prefix = new StringBuffer("Class");
        if (n > 1) {
            prefix.append("es");
        }
        prefix.append(" to be compiled:");
        prefix.append(lSep);
        this.log(prefix.toString() + niceClassList.toString(), 3);
    }

    static {
        FAIL_MSG = FAIL_MSG;
        lSep = System.getProperty("line.separator");
    }

    public class ClassArgument {
        private String name;

        public void setName(String name) {
            this.name = name;
            Javah.this.log("ClassArgument.name=" + name);
        }

        public String getName() {
            return this.name;
        }
    }
}

