/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.jaxws;

import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxws.handler.GenericSOAPHandler;
import org.jboss.ws.extensions.addressing.soap.SOAPAddressingPropertiesImpl;

public class WSAddressingClientHandler
extends GenericSOAPHandler {
    private static Logger log = Logger.getLogger(WSAddressingClientHandler.class);
    private AddressingBuilder addrBuilder = AddressingBuilder.getAddressingBuilder();
    private boolean normalize;

    protected boolean handleOutbound(MessageContext msgContext) {
        SOAPAddressingProperties addrProps;
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleOutbound");
        }
        if ((addrProps = (SOAPAddressingProperties)msgContext.get((Object)"javax.xml.ws.addressing.context.outbound")) != null) {
            if (this.normalize) {
                this.normalizeRequest(msgContext, addrProps);
            }
            SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
            addrProps.writeHeaders(soapMessage);
        } else {
            addrProps = (SOAPAddressingPropertiesImpl)this.addrBuilder.newAddressingProperties();
            msgContext.put((Object)"javax.xml.ws.addressing.context.outbound", (Object)addrProps);
            msgContext.setScope("javax.xml.ws.addressing.context.outbound", MessageContext.Scope.APPLICATION);
            if (this.normalize) {
                this.normalizeRequest(msgContext, addrProps);
            }
        }
        return true;
    }

    protected boolean handleInbound(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"handleInbound");
        }
        try {
            SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
            if (soapMessage.getSOAPPart().getEnvelope() != null) {
                SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
                SOAPAddressingProperties addrProps = (SOAPAddressingProperties)builder.newAddressingProperties();
                addrProps.readHeaders(soapMessage);
                msgContext.put((Object)"javax.xml.ws.addressing.context.inbound", (Object)addrProps);
                msgContext.setScope("javax.xml.ws.addressing.context.inbound", MessageContext.Scope.APPLICATION);
            }
        }
        catch (SOAPException ex) {
            throw new AddressingException("Cannot handle response", (Throwable)ex);
        }
        return true;
    }

    private void normalizeRequest(MessageContext msgContext, SOAPAddressingProperties addrProps) {
    }
}

