/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.j2ee.serviceref;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.ws.integration.ServiceRefElement;
import org.jboss.ws.metadata.j2ee.serviceref.ServiceRefMetaDataParser;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedHandlerMetaData
extends ServiceRefElement {
    private UnifiedHandlerChainMetaData handlerChain;
    private String handlerName;
    private String handlerClass;
    private List<UnifiedInitParamMetaData> initParams = new ArrayList<UnifiedInitParamMetaData>();
    private Set<QName> soapHeaders = new HashSet<QName>();
    private Set<String> soapRoles = new HashSet<String>();
    private Set<String> portNames = new HashSet<String>();

    public UnifiedHandlerMetaData(UnifiedHandlerChainMetaData handlerChain) {
        this.handlerChain = handlerChain;
    }

    public UnifiedHandlerMetaData() {
    }

    public void setHandlerName(String value) {
        this.handlerName = value;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void setHandlerClass(String handlerClass) {
        this.handlerClass = handlerClass;
    }

    public String getHandlerClass() {
        return this.handlerClass;
    }

    public void addInitParam(UnifiedInitParamMetaData param) {
        this.initParams.add(param);
    }

    public List<UnifiedInitParamMetaData> getInitParams() {
        return this.initParams;
    }

    public void addSoapHeader(QName qName) {
        this.soapHeaders.add(qName);
    }

    public Set<QName> getSoapHeaders() {
        return this.soapHeaders;
    }

    public void addSoapRole(String value) {
        this.soapRoles.add(value);
    }

    public Set<String> getSoapRoles() {
        return this.soapRoles;
    }

    public Set<String> getPortNames() {
        return this.portNames;
    }

    public void addPortName(String value) {
        this.portNames.add(value);
    }

    public HandlerMetaDataJAXRPC getHandlerMetaDataJAXRPC(HandlerMetaData.HandlerType type) {
        HandlerMetaDataJAXRPC hmd = new HandlerMetaDataJAXRPC(type);
        hmd.setHandlerName(this.getHandlerName());
        hmd.setHandlerClassName(this.getHandlerClass());
        hmd.setInitParams(this.getInitParams());
        hmd.setSoapHeaders(this.getSoapHeaders());
        hmd.setSoapRoles(this.getSoapRoles());
        hmd.setPortNames(this.getPortNames());
        return hmd;
    }

    public HandlerMetaDataJAXWS getHandlerMetaDataJAXWS(HandlerMetaData.HandlerType type) {
        HandlerMetaDataJAXWS hmd = new HandlerMetaDataJAXWS(type);
        hmd.setHandlerName(this.getHandlerName());
        hmd.setHandlerClassName(this.getHandlerClass());
        hmd.setInitParams(this.getInitParams());
        if (this.handlerChain != null) {
            hmd.setProtocolBindings(this.handlerChain.getProtocolBindings());
            hmd.setServiceNamePattern(this.handlerChain.getServiceNamePattern());
            hmd.setPortNamePattern(this.handlerChain.getPortNamePattern());
        }
        return hmd;
    }

    public void importStandardXml(Element root) {
        new ServiceRefMetaDataParser().importStandardXml(root, this);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nUnifiedHandlerMetaData");
        str.append("\n handlerName=" + this.handlerName);
        str.append("\n handlerClass=" + this.handlerClass);
        str.append("\n soapHeaders=" + this.soapHeaders);
        str.append("\n soapRoles=" + this.soapRoles);
        str.append("\n portNames=" + this.portNames);
        str.append("\n initParams=" + this.initParams);
        return str.toString();
    }
}

