/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.endpointref;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.bpel.endpointref.EndpointReference;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.jbpm.util.ClassLoaderUtil;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class EndpointReferenceFactory {
    public static final String RESOURCE_ENDPOINT_FACTORIES = "resource.endpoint.factories";
    private static final Log log = LogFactory.getLog((Class)EndpointReferenceFactory.class);
    private static final List endpointFactories = EndpointReferenceFactory.readEndpointFactories();

    protected EndpointReferenceFactory() {
    }

    public abstract EndpointReference createEndpointReference();

    public abstract boolean acceptsReference(QName var1, String var2);

    public static EndpointReferenceFactory getInstance(QName endpointRefName, String refScheme) {
        int n = endpointFactories.size();
        for (int i = 0; i < n; ++i) {
            EndpointReferenceFactory factory = (EndpointReferenceFactory)endpointFactories.get(i);
            if (!factory.acceptsReference(endpointRefName, refScheme)) continue;
            return factory;
        }
        return null;
    }

    private static List readEndpointFactories() {
        Element factoriesElem;
        String resource = JbpmConfiguration.Configs.getString((String)RESOURCE_ENDPOINT_FACTORIES);
        try {
            factoriesElem = XmlUtil.parseResource(resource);
        }
        catch (SAXException e) {
            log.error((Object)("endpoint factories document contains invalid xml: " + resource), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        catch (IOException e) {
            log.error((Object)("could not read endpoint factories document: " + resource), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        ArrayList<EndpointReferenceFactory> endpointFactories = new ArrayList<EndpointReferenceFactory>();
        Iterator factoryElemIt = XmlUtil.getElements(factoriesElem, null, "endpointFactory");
        while (factoryElemIt.hasNext()) {
            Element factoryElem;
            String factoryClassName;
            Class factoryClass;
            if (!(class$org$jbpm$bpel$endpointref$EndpointReferenceFactory == null ? EndpointReferenceFactory.class$("org.jbpm.bpel.endpointref.EndpointReferenceFactory") : class$org$jbpm$bpel$endpointref$EndpointReferenceFactory).isAssignableFrom(factoryClass = ClassLoaderUtil.loadClass((String)(factoryClassName = (factoryElem = (Element)factoryElemIt.next()).getAttribute("class"))))) {
                log.warn((Object)("not an endpoint factory: " + factoryClassName));
                continue;
            }
            try {
                EndpointReferenceFactory factory = (EndpointReferenceFactory)factoryClass.newInstance();
                endpointFactories.add(factory);
                log.debug((Object)("registered endpoint factory: " + factoryClassName));
            }
            catch (InstantiationException e) {
                log.warn((Object)("endpoint factory class not instantiable: " + factoryClassName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("endpoint factory class or constructor not public: " + factoryClassName), (Throwable)e);
            }
        }
        return endpointFactories;
    }
}

