/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.sublang.xpath;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.BaseXPath;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.Function;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.SimpleFunctionContext;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.expr.CommentNodeStep;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.ProcessingInstructionNodeStep;
import org.jaxen.expr.Step;
import org.jaxen.expr.TextNodeStep;
import org.jbpm.JbpmConfiguration;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.jbpm.util.ClassLoaderUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XPathEvaluator
extends BaseXPath {
    private static final FunctionContext EMPTY_FUNCTION_CONTEXT = new SimpleFunctionContext();
    private static final Log log = LogFactory.getLog((Class)XPathEvaluator.class);
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$org$jaxen$Function;

    protected XPathEvaluator(String text) throws JaxenException {
        super(text, DocumentNavigator.getInstance());
    }

    protected List selectOrCreateNodes(LocationPath location, Context context) throws JaxenException {
        List<Node> contextNodes = context.getNodeSet();
        if (contextNodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ContextSupport support = context.getContextSupport();
        if (location.isAbsolute()) {
            Object rootNode = support.getNavigator().getDocumentNode(contextNodes.get(0));
            contextNodes = Collections.singletonList(rootNode);
        }
        Iterator stepIter = location.getSteps().iterator();
        while (stepIter.hasNext()) {
            Context stepContext = new Context(support);
            stepContext.setNodeSet(contextNodes);
            Step step = (Step)stepIter.next();
            contextNodes = step.evaluate(stepContext);
            if (!contextNodes.isEmpty()) continue;
            Node newNode = this.createNode(step, stepContext);
            contextNodes = Collections.singletonList(newNode);
        }
        return contextNodes;
    }

    protected Node createNode(Step step, Context context) {
        Node newNode;
        List nodeset = context.getNodeSet();
        if (!step.getPredicates().isEmpty()) {
            throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
        }
        if (nodeset.size() != 1) {
            throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
        }
        Object node = nodeset.get(0);
        if (!(node instanceof Element)) {
            throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
        }
        Element parent = (Element)node;
        Document doc = parent.getOwnerDocument();
        int axis = step.getAxis();
        switch (axis) {
            case 9: {
                if (!(step instanceof NameStep)) {
                    throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
                }
                NameStep nameStep = (NameStep)step;
                String localName = nameStep.getLocalName();
                if ("*".equals(localName)) {
                    throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
                }
                String prefix = nameStep.getPrefix();
                Attr attribute = StringUtils.isEmpty((String)prefix) ? doc.createAttributeNS(null, localName) : doc.createAttributeNS(context.translateNamespacePrefixToUri(prefix), prefix + ':' + localName);
                parent.setAttributeNodeNS(attribute);
                newNode = attribute;
                break;
            }
            case 1: {
                if (step instanceof NameStep) {
                    NameStep nameStep = (NameStep)step;
                    String localName = nameStep.getLocalName();
                    if ("*".equals(localName)) {
                        throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
                    }
                    String prefix = nameStep.getPrefix();
                    newNode = StringUtils.isEmpty((String)prefix) ? doc.createElementNS(null, localName) : doc.createElementNS(context.translateNamespacePrefixToUri(prefix), prefix + ':' + localName);
                } else if (step instanceof TextNodeStep) {
                    newNode = doc.createTextNode("");
                } else if (step instanceof ProcessingInstructionNodeStep) {
                    newNode = doc.createProcessingInstruction(((ProcessingInstructionNodeStep)step).getName(), "");
                } else if (step instanceof CommentNodeStep) {
                    newNode = doc.createComment("");
                } else {
                    throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
                }
                parent.appendChild(newNode);
                break;
            }
            default: {
                throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
            }
        }
        return newNode;
    }

    protected Node getSingleNode(List nodeset) {
        if (nodeset == null || nodeset.size() != 1) {
            throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
        }
        Object singleResult = nodeset.get(0);
        if (!(singleResult instanceof Node)) {
            throw new BpelFaultException(BpelConstants.FAULT_SELECTION_FAILURE);
        }
        return (Node)singleResult;
    }

    protected static FunctionContext readFunctionLibrary(String configName) {
        FunctionContext functionContext;
        Element functionsElem;
        String resource = JbpmConfiguration.Configs.getString((String)configName);
        try {
            functionsElem = XmlUtil.parseResource(resource);
        }
        catch (SAXException e) {
            log.error((Object)("functions document contains invalid xml: " + resource), (Throwable)e);
            return EMPTY_FUNCTION_CONTEXT;
        }
        catch (IOException e) {
            log.error((Object)("could not read functions document: " + resource), (Throwable)e);
            return EMPTY_FUNCTION_CONTEXT;
        }
        String functionContextClassName = functionsElem.getAttribute("class");
        Class functionContextClass = ClassLoaderUtil.loadClass((String)functionContextClassName);
        try {
            functionContext = (FunctionContext)functionContextClass.newInstance();
        }
        catch (InstantiationException e) {
            log.warn((Object)("function context class not instantiable: " + functionContextClassName), (Throwable)e);
            return EMPTY_FUNCTION_CONTEXT;
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("function context class or constructor not public: " + functionContextClassName), (Throwable)e);
            return EMPTY_FUNCTION_CONTEXT;
        }
        Iterator functionElemIt = XmlUtil.getElements(functionsElem, null, "function");
        if (functionElemIt.hasNext()) {
            if (!SimpleFunctionContext.class.isAssignableFrom(functionContextClass)) {
                log.warn((Object)("unknown function context implementation, cannot add functions to it: " + functionContextClassName));
                return functionContext;
            }
            SimpleFunctionContext simpleContext = (SimpleFunctionContext)functionContext;
            while (functionElemIt.hasNext()) {
                String functionClassName;
                Class functionClass;
                Element functionElem = (Element)functionElemIt.next();
                String functionPrefixedName = functionElem.getAttribute("name");
                QName functionName = XmlUtil.parseQName(functionPrefixedName, functionElem);
                if (!(class$org$jaxen$Function == null ? XPathEvaluator.class$("org.jaxen.Function") : class$org$jaxen$Function).isAssignableFrom(functionClass = ClassLoaderUtil.loadClass((String)(functionClassName = functionElem.getAttribute("class"))))) {
                    log.warn((Object)("not a function: " + functionClassName));
                    continue;
                }
                try {
                    Function function = (Function)functionClass.newInstance();
                    simpleContext.registerFunction(functionName.getNamespaceURI(), functionName.getLocalPart(), function);
                    log.debug((Object)("registered function: name=" + functionPrefixedName + ", class=" + functionClassName));
                }
                catch (InstantiationException e) {
                    log.warn((Object)("function class not instantiable: " + functionClassName), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.warn((Object)("function class or constructor not public: " + functionClassName), (Throwable)e);
                }
            }
        }
        return functionContext;
    }
}

