/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml.util;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocalEntityResolver
implements EntityResolver {
    private static final Log log = LogFactory.getLog((Class)LocalEntityResolver.class);
    private static Map entityRegistry = new Hashtable();

    public static void registerEntity(String publicId, String fileName) {
        entityRegistry.put(publicId, fileName);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (publicId == null && systemId == null) {
            return null;
        }
        String entityResource = this.getResourceForEntity(publicId, systemId);
        if (entityResource == null) {
            return null;
        }
        URL entityURL = this.getClass().getResource(entityResource);
        if (entityURL == null) {
            return null;
        }
        return new InputSource(entityURL.toExternalForm());
    }

    private String getResourceForEntity(String publicId, String systemId) {
        String resource = null;
        if (publicId != null) {
            resource = (String)entityRegistry.get(publicId);
            log.debug((Object)("public id '" + publicId + "' maps to resource: " + resource));
        }
        if (resource == null && systemId != null) {
            resource = (String)entityRegistry.get(systemId);
            log.debug((Object)("system id '" + systemId + "' maps to resource: " + resource));
        }
        return resource;
    }

    static {
        LocalEntityResolver.registerEntity("http://jbpm.org/bpel/bpel_definition_1_0.xsd", "bpel_definition_1_0.xsd");
        LocalEntityResolver.registerEntity("http://jbpm.org/bpel/bpel_application_1_0.xsd", "bpel_application_1_0.xsd");
        LocalEntityResolver.registerEntity("http://schemas.xmlsoap.org/wsdl/", "wsdl.xsd");
        LocalEntityResolver.registerEntity("http://www.w3.org/2001/xml.xsd", "namespace.xsd");
        LocalEntityResolver.registerEntity("http://schemas.xmlsoap.org/ws/2004/03/business-process/", "bpel_2_0.xsd");
        LocalEntityResolver.registerEntity("http://schemas.xmlsoap.org/ws/2004/03/partner-link/", "plink_2_0.xsd");
        LocalEntityResolver.registerEntity("http://schemas.xmlsoap.org/ws/2004/03/business-process/property", "vprop_2_0.xsd");
        LocalEntityResolver.registerEntity("http://schemas.xmlsoap.org/ws/2003/03/business-process/", "bpel_1_1.xsd");
        LocalEntityResolver.registerEntity("http://schemas.xmlsoap.org/ws/2003/05/partner-link/", "plink_1_1.xsd");
        LocalEntityResolver.registerEntity("-//W3C//DTD XMLSCHEMA 200102//EN", "XMLSchema.dtd");
        LocalEntityResolver.registerEntity("datatypes", "datatypes.dtd");
    }
}

