/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.rule.And;
import org.drools.rule.Column;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.FixedDuration;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.LogicTransformer;
import org.drools.spi.Consequence;
import org.drools.spi.Duration;

public class Rule
implements Serializable {
    private static final long serialVersionUID = 7952983928232702826L;
    private String pkg;
    private final String name;
    private int salience;
    private final Map declarations = new HashMap();
    private Declaration[] declarationArray;
    private final And lhsRoot = new And();
    private String agendaGroup;
    private Consequence consequence;
    private Duration duration;
    private long loadOrder;
    private boolean noLoop;
    private boolean autoFocus;
    private String ActivationGroup;
    private boolean semanticallyValid = true;

    public Rule(String string, String string2, String string3) {
        this.name = string;
        this.pkg = string2;
        this.agendaGroup = string3;
    }

    public Rule(String string, String string2) {
        this.name = string;
        this.pkg = null;
        this.agendaGroup = string2;
    }

    public Rule(String string) {
        this.name = string;
        this.pkg = null;
        this.agendaGroup = "MAIN";
    }

    public void setDuration(long l) {
        this.duration = new FixedDuration(l);
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean isValid() {
        return this.consequence != null && this.isSemanticallyValid();
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public int getSalience() {
        return this.salience;
    }

    public void setSalience(int n) {
        this.salience = n;
    }

    public String getAgendaGroup() {
        return this.agendaGroup;
    }

    public void setAgendaGroup(String string) {
        this.agendaGroup = string;
    }

    public boolean getNoLoop() {
        return this.noLoop;
    }

    public void setNoLoop(boolean bl) {
        this.noLoop = bl;
    }

    public boolean getAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean bl) {
        this.autoFocus = bl;
    }

    public String getActivationGroup() {
        return this.ActivationGroup;
    }

    public void setXorGroup(String string) {
        this.ActivationGroup = string;
    }

    public Declaration getDeclaration(String string) {
        return (Declaration)this.declarations.get(string);
    }

    public Declaration[] getDeclarations() {
        if (this.declarationArray == null) {
            this.declarationArray = this.declarations.values().toArray(new Declaration[this.declarations.values().size()]);
        }
        return this.declarationArray;
    }

    public void addPattern(ConditionalElement conditionalElement) {
        if (conditionalElement instanceof GroupElement) {
            this.addDeclarations((GroupElement)conditionalElement);
        }
        this.lhsRoot.addChild(conditionalElement);
    }

    public void addPattern(Column column) {
        this.addDeclarations(column);
        this.lhsRoot.addChild(column);
    }

    private void addDeclarations(Column column) {
        Object object;
        if (column.isBound()) {
            object = column.getDeclaration();
            this.declarations.put(((Declaration)object).getIdentifier(), object);
        }
        object = column.getConstraints().iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!(e instanceof Declaration)) continue;
            Declaration declaration = (Declaration)e;
            this.declarations.put(declaration.getIdentifier(), declaration);
        }
    }

    private void addDeclarations(GroupElement groupElement) {
        Iterator iterator = groupElement.getChildren().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Column) {
                this.addDeclarations((Column)e);
                continue;
            }
            if (!(e instanceof GroupElement)) continue;
            this.addDeclarations((GroupElement)e);
        }
    }

    public And getLhs() {
        return this.lhsRoot;
    }

    public And[] getTransformedLhs() throws InvalidPatternException {
        return LogicTransformer.getInstance().transform(this.lhsRoot);
    }

    public int getSpecifity() {
        return this.getSpecifity(this.lhsRoot);
    }

    private int getSpecifity(GroupElement groupElement) {
        int n = 0;
        Iterator iterator = groupElement.getChildren().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Column) {
                n += this.getSpecifity((Column)e);
                continue;
            }
            if (!(e instanceof GroupElement)) continue;
            n += this.getSpecifity((GroupElement)e);
        }
        return n;
    }

    private int getSpecifity(Column column) {
        int n = 0;
        Iterator iterator = column.getConstraints().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Declaration) continue;
            ++n;
        }
        return n;
    }

    public void setConsequence(Consequence consequence) {
        this.consequence = consequence;
    }

    public Consequence getConsequence() {
        return this.consequence;
    }

    public long getLoadOrder() {
        return this.loadOrder;
    }

    void setLoadOrder(long l) {
        this.loadOrder = l;
    }

    public String toString() {
        return "[Rule name=" + this.name + ", agendaGroup=" + this.agendaGroup + ", salience=" + this.salience + ", no-loop=" + this.noLoop + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != Rule.class) {
            return false;
        }
        Rule rule = (Rule)object;
        return this.name.equals(rule.name) && this.agendaGroup.equals(rule.agendaGroup) && (this.ActivationGroup == null && rule.ActivationGroup == null || this.ActivationGroup != null && this.ActivationGroup.equals(rule.ActivationGroup)) && this.salience == rule.salience && this.noLoop == rule.noLoop;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setSemanticallyValid(boolean bl) {
        this.semanticallyValid = bl;
    }

    public boolean isSemanticallyValid() {
        return this.semanticallyValid;
    }
}

