/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.MappingException;
import cirrus.hibernate.engine.Cascades;
import cirrus.hibernate.helpers.JoinedIterator;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.map.Collection;
import cirrus.hibernate.map.Column;
import cirrus.hibernate.map.ManyToOne;
import cirrus.hibernate.map.OneToOne;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.map.Property;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.map.Value;
import cirrus.hibernate.type.ComponentType;
import cirrus.hibernate.type.Type;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Component
extends Value {
    private ArrayList properties = new ArrayList();
    private final Class componentClass;
    private final boolean embedded;
    private String parentProperty;

    public String toString() {
        return "Component: " + this.componentClass.getName();
    }

    public int getPropertySpan() {
        return this.properties.size();
    }

    public Iterator getPropertyIterator() {
        return this.properties.iterator();
    }

    public void addProperty(Property p) {
        this.properties.add(p);
    }

    public void addColumn(Column column) {
        throw new UnsupportedOperationException("Cant add a column to a component");
    }

    public int getColumnSpan() {
        int n = 0;
        Iterator iter = this.getPropertyIterator();
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            n += p.getColumnSpan();
        }
        return n;
    }

    public Iterator getColumnIterator() {
        Iterator[] iters = new Iterator[this.getPropertySpan()];
        Iterator iter = this.getPropertyIterator();
        int i = 0;
        while (iter.hasNext()) {
            iters[i++] = ((Property)iter.next()).getColumnIterator();
        }
        return new JoinedIterator(iters);
    }

    public Component(Node node, Class reflectedClass, String path, PersistentClass owner, boolean isNullable, Table table, Root root) throws MappingException {
        String className;
        this.setTable(table);
        Node classNode = node.getAttributes().getNamedItem("class");
        if (classNode != null) {
            className = classNode.getNodeValue();
            try {
                this.componentClass = ReflectHelper.classForName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("component class not found", cnfe);
            }
            this.embedded = false;
        } else if (reflectedClass != null) {
            this.componentClass = reflectedClass;
            className = this.componentClass.getName();
            this.embedded = false;
        } else {
            this.componentClass = owner.getPersistentClass();
            className = owner.getName();
            this.embedded = true;
        }
        if (this.componentClass == null) {
            throw new MappingException("Could not determine class of a component");
        }
        path = path + '/' + StringHelper.unqualify(className);
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node subnode = list.item(i);
            String name = subnode.getNodeName();
            String propertyName = Property.getPropertyName(subnode);
            Root.CollectionType collectType = Root.CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(list.item(i), path, owner, root);
                root.addCollection(collection);
                value = new Value(subnode, path, isNullable, table, root);
            } else if ("many-to-one".equals(name) || "key-many-to-one".equals(name)) {
                value = new ManyToOne(subnode, path, propertyName, isNullable, table, root);
            } else if ("one-to-one".equals(name)) {
                value = new OneToOne(subnode, owner.getIdentifier(), path, isNullable, table, root);
            } else if ("property".equals(name) || "key-property".equals(name)) {
                value = new Value(subnode, "", propertyName, isNullable, table, root);
            } else if ("collection".equals(name)) {
                value = new Value(subnode, "", propertyName, isNullable, table, root);
            } else if ("component".equals(name) || "nested-composite-element".equals(name)) {
                Class subreflectedClass = ReflectHelper.getGetter(this.componentClass, propertyName).getReturnType();
                value = new Component(subnode, subreflectedClass, path, owner, isNullable, table, root);
            } else if ("parent".equals(name)) {
                this.parentProperty = propertyName;
            }
            if (value != null) {
                ((Value)value).setTypeByReflection(this.componentClass, propertyName);
                ((Value)value).createForeignKeys(root, table);
                this.addProperty(new Property(subnode, value, root));
            }
            ++i;
        }
        int span = this.getPropertySpan();
        String[] names = new String[span];
        Type[] types = new Type[span];
        Cascades.CascadeStyle[] cascade = new Cascades.CascadeStyle[span];
        int[] joinedFetch = new int[span];
        Iterator iter = this.getPropertyIterator();
        int i2 = 0;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            names[i2] = prop.getName();
            types[i2] = prop.getType();
            cascade[i2] = prop.cascade();
            joinedFetch[i2] = prop.getValue().enableJoinedFetch();
            ++i2;
        }
        this.setType(new ComponentType(this.componentClass, types, names, joinedFetch, cascade, this.parentProperty, this.embedded));
    }

    public Class getComponentClass() {
        return this.componentClass;
    }

    public void setTypeByReflection(Class propertyClass, String propertyName) throws MappingException {
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isComposite() {
        return true;
    }
}

