/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContexts;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.entity.InjectedEntityManager;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.injection.EntityManagerFieldInjector;
import org.jboss.ejb3.injection.EntityManagerMethodInjector;
import org.jboss.ejb3.injection.InjectionUtil;
import org.jboss.ejb3.injection.PersistenceUnitHandler;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextHandler {
    private static final Logger log = Logger.getLogger(PersistenceContextHandler.class);

    private static void loadResourcesAnnotation(Container container, Class clazz, boolean isContainer) throws Exception {
        PersistenceContexts resources = (PersistenceContexts)InjectionUtil.getAnnotation(PersistenceContexts.class, (EJBContainer)container, clazz, isContainer);
        if (resources == null) {
            return;
        }
        for (PersistenceContext ref : resources.value()) {
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceContext");
            }
            ManagedEntityManagerFactory factory = PersistenceContextHandler.getManagedEntityManagerFactory(ref, container);
            PersistenceContextHandler.bindEntityManagerToEnc(container, factory, encName, container.getBeanClass());
        }
        PersistenceContext pc = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, (EJBContainer)container, clazz, isContainer);
        if (pc != null) {
            String encName = pc.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceContext");
            }
            ManagedEntityManagerFactory factory = PersistenceContextHandler.getManagedEntityManagerFactory(pc, container);
            PersistenceContextHandler.bindEntityManagerToEnc(container, factory, encName, container.getBeanClass());
        }
    }

    private static void loadClassPUDependencies(Container container, Class clazz, boolean isContainer) {
        PersistenceContexts resources = (PersistenceContexts)InjectionUtil.getAnnotation(PersistenceContexts.class, (EJBContainer)container, clazz, isContainer);
        if (resources == null) {
            return;
        }
        for (PersistenceContext ref : resources.value()) {
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            PersistenceUnitHandler.addPUDependency(ref.unitName(), (EJBContainer)container);
        }
        PersistenceContext pu = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, (EJBContainer)container, clazz, isContainer);
        if (pu != null) {
            String encName = pu.name();
            if (encName == null || encName.equals("")) {
                throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
            }
            PersistenceUnitHandler.addPUDependency(pu.unitName(), (EJBContainer)container);
        }
    }

    public static void loadMethodDependencies(HashSet<String> visitedMethods, EJBContainer container, Class clazz, boolean isContainer) {
        if (clazz != null && !clazz.equals(Object.class)) {
            PersistenceContextHandler.loadMethodDependencies(visitedMethods, container, clazz.getSuperclass(), isContainer);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            PersistenceContext ref = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, container, methods[i], isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
        }
    }

    private static void loadFieldDependencies(Class clazz, EJBContainer container, boolean isContainer) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        PersistenceContextHandler.loadFieldDependencies(clazz.getSuperclass(), container, isContainer);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            PersistenceContext ref = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, container, fields[i], isContainer);
            if (ref == null) continue;
            PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
        }
    }

    public static void loadDependencies(EJBContainer container, Class clazz, boolean isContainer) {
        PersistenceContextHandler.loadClassPUDependencies(container, clazz, isContainer);
        HashSet<String> visitedMethods = new HashSet<String>();
        PersistenceContextHandler.loadMethodDependencies(visitedMethods, container, clazz, isContainer);
        PersistenceContextHandler.loadFieldDependencies(clazz, container, isContainer);
    }

    private static ManagedEntityManagerFactory getManagedEntityManagerFactory(PersistenceContext ref, Container container) throws NamingException {
        return PersistenceUnitHandler.getManagedEntityManagerFactory(container, ref.unitName());
    }

    public static List loadInjectors(Container container) throws Exception {
        Class clazz = container.getBeanClass();
        return PersistenceContextHandler.loadInjectors(container, clazz, true);
    }

    public static List loadInjectors(InterceptorInjector injector) throws Exception {
        return PersistenceContextHandler.loadInjectors(injector.getContainer(), injector.getClazz(), false);
    }

    private static List loadInjectors(Container container, Class clazz, boolean isContainer) throws Exception {
        ArrayList list = new ArrayList();
        HashSet<String> visitedMethods = new HashSet<String>();
        Context resourceCtx = Util.createSubcontext((Context)container.getInitialContext(), (String)"java:comp.ejb3/env");
        PersistenceContextHandler.loadResourcesAnnotation(container, clazz, isContainer);
        PersistenceContextHandler.loadMethodInjectors(visitedMethods, container, clazz, list, resourceCtx, isContainer);
        PersistenceContextHandler.loadFieldInjectors(clazz, container, list, resourceCtx, isContainer);
        return list;
    }

    private static void loadMethodInjectors(HashSet<String> visitedMethods, Container container, Class clazz, ArrayList list, Context resourceCtx, boolean isContainer) throws Exception {
        if (clazz != null && !clazz.equals(Object.class)) {
            PersistenceContextHandler.loadMethodInjectors(visitedMethods, container, clazz.getSuperclass(), list, resourceCtx, isContainer);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            PersistenceContext ref = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, (EJBContainer)container, methods[i], isContainer);
            if (ref == null) continue;
            if (!Modifier.isPrivate(methods[i].getModifiers())) {
                if (visitedMethods.contains(methods[i].getName())) continue;
                visitedMethods.add(methods[i].getName());
            }
            if (!methods[i].getName().startsWith("set")) {
                throw new RuntimeException("@PersistenceContext can only be used with a set method: " + methods[i]);
            }
            if (methods[i].getParameterTypes().length != 1) {
                throw new RuntimeException("@PersistenceContext can only be used with a set method of one parameter: " + methods[i]);
            }
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                encName = InjectionUtil.getEncName(methods[i]);
            }
            ManagedEntityManagerFactory factory = PersistenceContextHandler.getManagedEntityManagerFactory(ref, container);
            list.add(new EntityManagerMethodInjector(methods[i], container, factory, ref.type()));
            PersistenceContextHandler.bindEntityManagerToEnc(container, factory, encName, methods[i]);
        }
    }

    private static void bindEntityManagerToEnc(Container container, ManagedEntityManagerFactory factory, String encName, Object where) throws NamingException {
        InjectedEntityManager entityManager = new InjectedEntityManager(factory, container.getInitialContextProperties());
        try {
            Util.bind((Context)container.getEnc(), (String)encName, (Object)entityManager);
        }
        catch (NameAlreadyBoundException e) {
            throw new RuntimeException("Error trying to bind EntityManager to name " + encName + " declared on " + where, e);
        }
    }

    private static void loadFieldInjectors(Class clazz, Container container, ArrayList list, Context resourceCtx, boolean isContainer) throws Exception {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        PersistenceContextHandler.loadFieldInjectors(clazz.getSuperclass(), container, list, resourceCtx, isContainer);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            PersistenceContext ref = (PersistenceContext)InjectionUtil.getAnnotation(PersistenceContext.class, (EJBContainer)container, fields[i], isContainer);
            if (ref == null) continue;
            fields[i].setAccessible(true);
            String encName = ref.name();
            if (encName == null || encName.equals("")) {
                encName = InjectionUtil.getEncName(fields[i]);
            }
            ManagedEntityManagerFactory factory = PersistenceContextHandler.getManagedEntityManagerFactory(ref, container);
            list.add(new EntityManagerFieldInjector(fields[i], container, factory, ref.type()));
            PersistenceContextHandler.bindEntityManagerToEnc(container, factory, encName, fields[i]);
        }
    }
}

