/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TreeCache;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.NodeData;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jgroups.blocks.MethodCall;

public class DataGravitatorInterceptor
extends BaseRpcInterceptor {
    private BuddyManager buddyManager;
    private boolean syncCommunications = false;
    private Log log = LogFactory.getLog((Class)DataGravitatorInterceptor.class);
    private Map transactionMods = new ConcurrentHashMap();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.buddyManager = cache.getBuddyManager();
        this.syncCommunications = cache.getCacheModeInternal() == 3;
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Invoked with method call " + (Object)((Object)m)));
        }
        if (!this.isTransactionLifecycleMethod(m)) {
            if (this.isGravitationEnabled(this.getInvocationContext()) && MethodDeclarations.isGetMethod(m.getMethodId())) {
                Fqn fqn = this.extractFqn(m.getMethodId(), m.getArgs());
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Checking local existence of fqn " + fqn));
                }
                if (BuddyManager.isBackupFqn(fqn)) {
                    this.log.info((Object)"Is call for a backup Fqn, not performing any gravitation.  Direct calls on internal backup nodes are *not* supported.");
                } else if (!this.cache.exists(fqn)) {
                    BackupData data = null;
                    if (this.localBackupExists(fqn)) {
                        this.log.trace((Object)"Gravitating from local backup tree");
                        data = this.localBackupGet(fqn);
                    } else {
                        this.log.trace((Object)"Gravitating from remote backup tree");
                        data = this.remoteBackupGet(fqn);
                    }
                    if (data != null) {
                        this.createNode(true, data.backupData);
                        this.log.trace((Object)"Passing the put call locally to make sure state is persisted and ownership is correctly established.");
                        this.createNode(false, data.backupData);
                        this.lock(data.primaryFqn);
                        this.cleanBackupData(data);
                    }
                }
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Suppressing data gravitation for this call.");
            }
        } else {
            try {
                switch (m.getMethodId()) {
                    case 10: 
                    case 18: {
                        Object o = super.invoke(m);
                        this.doPrepare(this.getInvocationContext().getGlobalTransaction());
                        return o;
                    }
                    case 12: {
                        this.transactionMods.remove(this.getInvocationContext().getGlobalTransaction());
                        return super.invoke(m);
                    }
                    case 11: {
                        this.doCommit(this.getInvocationContext().getGlobalTransaction());
                        this.transactionMods.remove(this.getInvocationContext().getGlobalTransaction());
                        return super.invoke(m);
                    }
                }
            }
            catch (Throwable throwable) {
                this.transactionMods.remove(this.getInvocationContext().getGlobalTransaction());
                throw throwable;
            }
        }
        return super.invoke(m);
    }

    protected void lock(Fqn fqn) throws Throwable {
        if (this.cache.isNodeLockingOptimistic()) {
            return;
        }
        JBCMethodCall meth = MethodCallFactory.create(MethodDeclarations.lockMethodLocal, new Object[]{fqn, new Integer(2), Boolean.FALSE});
        ((Interceptor)this.cache.getInterceptors().get(0)).invoke(meth);
    }

    private boolean isGravitationEnabled(InvocationContext ctx) {
        boolean enabled = ctx.isOriginLocal();
        if (enabled && !this.buddyManager.isAutoDataGravitation()) {
            Option opt = ctx.getOptionOverrides();
            enabled = opt != null && opt.getForceDataGravitation();
        }
        return enabled;
    }

    private void doPrepare(GlobalTransaction gtx) throws Throwable {
        MethodCall cleanup = (MethodCall)this.transactionMods.get(gtx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Broadcasting prepare for cleanup ops " + cleanup));
        }
        if (cleanup != null) {
            ArrayList<MethodCall> mods = new ArrayList<MethodCall>(1);
            mods.add(cleanup);
            JBCMethodCall prepare = this.cache.isNodeLockingOptimistic() ? MethodCallFactory.create(MethodDeclarations.optimisticPrepareMethod, new Object[]{gtx, mods, null, this.cache.getLocalAddress(), Boolean.FALSE}) : MethodCallFactory.create(MethodDeclarations.prepareMethod, new Object[]{gtx, mods, this.cache.getLocalAddress(), this.cache.getCacheModeInternal() == 3 || this.cache.getCacheModeInternal() == 5 ? Boolean.FALSE : Boolean.TRUE});
            this.replicateCall(this.getMembersOutsideBuddyGroup(), prepare, this.syncCommunications);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Nothing to broadcast in prepare phase for gtx " + gtx));
        }
    }

    private void doCommit(GlobalTransaction gtx) throws Throwable {
        if (this.transactionMods.containsKey(gtx)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Broadcasting commit for gtx " + gtx));
            }
            this.replicateCall(this.getMembersOutsideBuddyGroup(), MethodCallFactory.create(MethodDeclarations.commitMethod, new Object[]{gtx}), this.syncCommunications);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Nothing to broadcast in commit phase for gtx " + gtx));
        }
    }

    private List getMembersOutsideBuddyGroup() {
        ArrayList members = new ArrayList(this.cache.getMembers());
        members.remove(this.cache.getLocalAddress());
        members.removeAll(this.buddyManager.getBuddyAddresses());
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackupData remoteBackupGet(Fqn name) throws Exception {
        BackupData result = null;
        Object[] resp = this.gravitateData(name);
        if (resp[0] != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Got response " + resp[0]));
            }
            List nodes = null;
            if (this.cache.getUseRegionBasedMarshalling()) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    this.cache.getRegionManager().setUnmarshallingClassLoader(name);
                    byte[] nodeData = (byte[])resp[0];
                    ByteArrayInputStream bais = new ByteArrayInputStream(nodeData);
                    MarshalledValueInputStream mais = new MarshalledValueInputStream((InputStream)bais);
                    nodes = (List)mais.readObject();
                    mais.close();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            } else {
                nodes = (List)resp[0];
            }
            Fqn bkup = (Fqn)resp[1];
            result = new BackupData(name, bkup, nodes);
        }
        return result;
    }

    private void cleanBackupData(BackupData backup) throws Throwable {
        GlobalTransaction gtx;
        JBCMethodCall cleanup = MethodCallFactory.create(MethodDeclarations.dataGravitationCleanupMethod, new Object[]{this.getInvocationContext().getGlobalTransaction(), backup.primaryFqn, backup.backupFqn});
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Performing cleanup on [" + backup.primaryFqn + "]"));
        }
        if ((gtx = this.getInvocationContext().getGlobalTransaction()) == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Performing cleanup on [" + backup.backupFqn + "]"));
            }
            this.replicateCall(this.cache.getMembers(), cleanup, this.syncCommunications);
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Data gravitation performed under global transaction " + gtx + ".  Not broadcasting cleanups until the tx commits.  Adding to tx mod list instead."));
            }
            this.transactionMods.put(gtx, cleanup);
            TransactionEntry te = this.getTransactionEntry(gtx);
            te.addModification(cleanup);
        }
    }

    private Object[] gravitateData(Fqn fqn) throws Exception {
        Boolean marshal;
        Boolean searchSubtrees;
        JBCMethodCall dGrav;
        Vector mbrs;
        List resps;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("cache=" + this.cache.getLocalAddress() + "; requesting data gravitation for Fqn " + fqn));
        }
        if ((resps = this.cache.callRemoteMethods((List)(mbrs = this.cache.getMembers()), (MethodCall)(dGrav = MethodCallFactory.create(MethodDeclarations.dataGravitationMethod, new Object[]{fqn, searchSubtrees = this.buddyManager.isDataGravitationSearchBackupTrees() ? Boolean.TRUE : Boolean.FALSE, marshal = this.cache.getUseRegionBasedMarshalling() ? Boolean.TRUE : Boolean.FALSE})), 1, true, (long)this.buddyManager.getBuddyCommunicationTimeout())) == null) {
            this.log.error((Object)("No replies to call " + (Object)((Object)dGrav) + ".  Perhaps we're alone in the cluster?"));
            return new Object[]{null, null};
        }
        Iterator i = resps.iterator();
        Object result = null;
        Object backupFqn = null;
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Throwable) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"Found remote Throwable among responses - removing from responses list", (Throwable)((Exception)o));
                continue;
            }
            if (o != null) {
                List dGravResp = (List)o;
                if (!((Boolean)dGravResp.get(0)).booleanValue()) continue;
                result = dGravResp.get(1);
                backupFqn = dGravResp.get(2);
                break;
            }
            if (this.cache.getUseRegionBasedMarshalling()) continue;
            this.log.error((Object)("Unexpected null response to call " + (Object)((Object)dGrav) + "."));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("got responses " + resps));
        }
        return new Object[]{result, backupFqn};
    }

    private void createNode(boolean localOnly, List nodeData) throws CacheException {
        Iterator nodes = nodeData.iterator();
        GlobalTransaction gtx = this.getInvocationContext().getGlobalTransaction();
        while (nodes.hasNext()) {
            NodeData data = (NodeData)nodes.next();
            if (localOnly) {
                if (this.cache.exists(data.getFqn())) continue;
                this.createNodes(gtx, data.getFqn(), data.getAttributes());
                continue;
            }
            this.cache.put(data.getFqn(), data.getAttributes());
        }
    }

    private void createNodes(GlobalTransaction gtx, Fqn fqn, Map data) throws CacheException {
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        DataNode n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize; ++i) {
            Object child_name = fqn.get(i);
            DataNode child_node = (DataNode)n.getOrCreateChild(child_name, gtx, true);
            if (child_node == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n.getFqn()));
                }
                return;
            }
            if (i == treeNodeSize - 1) {
                this.cache._put(gtx, fqn, data, true);
            }
            n = child_node;
        }
    }

    private TransactionEntry getTransactionEntry(GlobalTransaction gtx) {
        return this.cache.getTransactionTable().get(gtx);
    }

    private Fqn extractFqn(int methodId, Object[] args) {
        return (Fqn)args[MethodDeclarations.isCrudMethod(methodId) ? 1 : 0];
    }

    private boolean localBackupExists(Fqn fqn) {
        DataNode node;
        Fqn newSearchFqn;
        Iterator backupRoots = this.getBackupRootIterator();
        boolean exists = false;
        while (backupRoots.hasNext() && !(exists = this.cache.exists(newSearchFqn = new Fqn((node = (DataNode)backupRoots.next()).getFqn(), fqn)))) {
        }
        return exists;
    }

    private BackupData localBackupGet(Fqn fqn) throws CacheException {
        List gravitatedData = this.cache._gravitateData(fqn, true, false);
        boolean found = (Boolean)gravitatedData.get(0);
        BackupData data = null;
        if (found) {
            Fqn backupFqn = (Fqn)gravitatedData.get(2);
            List nodeData = (List)gravitatedData.get(1);
            data = new BackupData(fqn, backupFqn, nodeData);
            if (this.buddyManager.isDataGravitationRemoveOnFind()) {
                Option opt = new Option();
                opt.setCacheModeLocal(true);
                this.cache.remove(backupFqn, opt);
            } else {
                this.cache.evict(backupFqn);
            }
        }
        return data;
    }

    private Iterator getBackupRootIterator() {
        DataNode backupRoot = this.cache.peek(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN);
        return backupRoot == null ? Collections.EMPTY_SET.iterator() : backupRoot.getChildren().values().iterator();
    }

    private class BackupData {
        Fqn primaryFqn;
        Fqn backupFqn;
        List backupData;

        BackupData(Fqn primary, Fqn backup, List data) {
            this.primaryFqn = primary;
            this.backupFqn = backup;
            this.backupData = data;
        }
    }
}

