DnD.SimpleDropZone  = Class.create();
Object.extend(DnD.SimpleDropZone.prototype, DnD.Dropzone.prototype);
Object.extend(DnD.SimpleDropZone.prototype, {
	initialize: function(id, options) {
		this.id = id;
		var element = $(id);
		this.element = element;
		if (options.acceptedTypes) {
			this.acceptedTypes = options.acceptedTypes;
		} else {
			this.acceptedTypes = [];
		}
	
		if (options.typeMapping) {
			this.typeMapping = options.typeMapping;
		} else {
			this.typeMapping = {};
		}
		
		this.mouseoverBound = this.mouseover.bindAsEventListener(this);
		this.mouseoutBound = this.mouseout.bindAsEventListener(this);
		this.mouseupBound = this.mouseup.bindAsEventListener(this);
		
		//Event.observe(element, "mouseover", this.mouseoverBound);
		Event.observe(element, "mouseout", this.mouseoutBound);
		Event.observe(element, "mouseup", this.mouseupBound);
		
		this.options = options || {};
		
	},

	getDnDDropParams: function() {
		if (this.options.dndParams) {
			return this.options.dndParams.parseJSON();
		}
		
		return null;
	},

	mouseover: function(event) {
		if (window.drag){
			this.dragEnter(event);
			if (this.options.ondragenter) {
				this.options.ondragenter.call(this, event);
			}
		}
	},

	mouseup: function(event) {
		this.dragUp(event);
	},

	mouseout: function(event) {
		if (window.drag){
			this.dragLeave(event);
			if (this.options.ondragexit) {
				this.options.ondragexit.call(this, event);
			}
		}
	},
	getAcceptedTypes: function() {
		return this.acceptedTypes;
	},
	getTypeMapping: function() {
		return this.typeMapping;
	},
	drop: function(event, drag){
		alert('I drop');	
	},
	onafterdrag: function(drag) {
		if (this.options.onafterdrag) {
			this.options.onafterdrag.call(this, drag);
		}
	}
});