if (!Exadel) var Exadel = {};
var Suggestion = {};
Suggestion.Base = function() {
};
Suggestion.Base.prototype = {
    baseInitialize: function(element, update, options) {
    	this.isOpera = (RichFaces.navigatorType() =="OPERA"?true:false);
        this.element = $(element);
        this.update = $(update);
        this.hasFocus = false;
        this.changed = false;
        this.active = false;
        this.index = 0;
        this.prevIndex = -1;
        this.entryCount = 0;
        this.keyEvent = false;

        var needIframe = (RichFaces.navigatorType() == "MSIE");

        if (needIframe) {
            options.iframeId = update + "_iframe";
        }

        if (this.setOptions)
            this.setOptions(options);
        else
            this.options = options || {};

        this.options.param = this.options.param || this.element.name;
        this.options.selectedClass = this.options.selectedClass || "dr-sb-int-sel";
        this.options.tokens = $A(options.tokens) || [];
        this.options.frequency = this.options.frequency || 0.4;
        this.options.minChars = parseInt(this.options.minChars) || 1;
        this.options.onShow = this.options.onShow ||
                              function(element, update, options) {
                                  if (!update.style.position || update.style.position == 'absolute') {
                                      update.style.position = 'absolute';
                                      Exadel.Position.smartClone(element, update, options);
                                  }
                                  Effect.Appear(update, {duration:0.15});
                                  if (options.iframeId) {
                                      Effect.Appear($(options.iframeId), {duration:0.15});
                                  }
                              };
        this.options.onHide = this.options.onHide ||
                              function(element, update, options) {
                                  if (options.iframeId) {
                                      new Effect.Fade($(options.iframeId), {duration:0.15});
                                  }
                                  new Effect.Fade(update, {duration:0.15});
                              };

        this.options.width = this.options.width || "auto";

        if (typeof(this.options.tokens) == 'string')
            this.options.tokens = new Array(this.options.tokens);
        for (var i = 0; i < this.options.tokens.length; i++) {
            var token = this.options.tokens[i];
            if (token.charAt[0] == "'" && token.charAt[token.length - 1] == "'")
                this.options.tokens[i] = token.substring(1, -1);
        }

        this.observerHandle = null;

        this.element.setAttribute('autocomplete', 'off');

        Element.hide(this.update);

        this.onBlurListener = this.onBlur.bindAsEventListener(this);
        Event.observe(this.element, "blur", this.onBlurListener);

        this.onKeyPressListener = this.onKeyPress.bindAsEventListener(this);
        Event.observe(this.element, "keypress", this.onKeyPressListener);
        
        if (this.isOpera) {
	        this.onKeyUpListener = this.onKeyUp.bindAsEventListener(this);
	        Event.observe(this.element, "keyup", this.onKeyUpListener);
	        this.upDown = 0;
        }
    },

	onBoxKeyPress: function(event) {
		if (this.upDown == 1) {
	        this.keyEvent = true;
			this.markPrevious();
	        this.render();
		} else if (this.upDown == 2) {
	        this.keyEvent = true;
			this.markNext();
	        this.render();
		}
	},

	cancelSubmit: function(event) {
		Event.stop(event);
	},
	
	disableSubmit: function() {
		if (this.isOpera) {
		    var el = this.element;
		    while (el.parentNode && (!el.tagName || (el.tagName.toUpperCase() != 'FORM')))
		      el = el.parentNode;
		    if (el.tagName && (el.tagName.toUpperCase() == 'FORM')) {
		    	this.parentForm = el;
		        this.onSubmitListener = this.cancelSubmit.bindAsEventListener(this);
		        Event.observe(el, "submit", this.onSubmitListener);
		    }
		}
	},
	
	enableSubmit: function() {
		if (this.isOpera) {
			if (this.parentForm) {
			    Event.stopObserving(this.parentForm, "submit", this.onSubmitListener);
			}
		}
	},

	onKeyUp: function(event) {
		if (this.upDown > 0) {
			this.element.onkeypress=this.prevOnKeyPress;
		}
		this.upDown = 0;
	},

    show: function() {
        if (Element.getStyle(this.update, 'display') == 'none') this.options.onShow(this.element, this.update, this.options);
        this.disableSubmit();
    },

    hide: function() {
        this.stopIndicator();
        if (Element.getStyle(this.update, 'display') != 'none') this.options.onHide(this.element, this.update, this.options);
        this.enableSubmit();
    },

    startIndicator: function() {
        if (this.options.indicator) Element.show(this.options.indicator);
    },

    stopIndicator: function() {
        if (this.options.indicator) Element.hide(this.options.indicator);
    },

    isUnloaded: function() {
        if (this.element.parentNode && this.update.parentNode) {
            return false;
        }
        LOG.info("Element unloaded from DOM");
        if (this.element) {
            Event.stopObserving(this.element, "blur", this.onBlurListener);
            Event.stopObserving(this.element, "keypress", this.onKeyPressListener);
        }
        return true;
    },

    onKeyPress: function(event) {
        if (this.isUnloaded()) return;
        if (!this.initialized) {
            if (this.options.iframeId) {
                var iFrame = $(this.options.iframeId);
                var iTemp = iFrame.cloneNode(true);
                iFrame.parentNode.removeChild(iFrame);
                document.body.insertBefore(iTemp, document.body.firstChild);
            }
            var temp = this.update.cloneNode(true);
            this.update.parentNode.removeChild(this.update);
            this.update = temp;
            document.body.insertBefore(this.update, document.body.firstChild);
            this.initialized = true;
        }
        if (this.active)
            switch (event.keyCode) {
                case Event.KEY_TAB:
                case Event.KEY_RETURN:
                    this.selectEntry(event);
                    Event.stop(event);
                case Event.KEY_ESC:
                    this.hide();
                    this.active = false;
                    Event.stop(event);
                    return;
                case Event.KEY_LEFT:
                case Event.KEY_RIGHT:
                    return;
                case Event.KEY_UP:
                    this.keyEvent = true;
                    this.markPrevious();
                    this.render();
                    if (navigator.appVersion.indexOf('AppleWebKit') > 0) Event.stop(event);
                	if (this.isOpera) {
	                	this.upDown = 1;
	                	this.prevOnKeyPress = this.element.onkeypress;
	                	this.element.onkeypress = this.onBoxKeyPress.bindAsEventListener(this);
                	} 
                    return;
                case Event.KEY_DOWN:
                    this.keyEvent = true;
                    this.markNext();
                    this.render();
                    if (navigator.appVersion.indexOf('AppleWebKit') > 0) Event.stop(event);
                	if (this.isOpera) {
	                	this.upDown = 2;
	                	this.prevOnKeyPress = this.element.onkeypress;
	                	this.element.onkeypress = this.onBoxKeyPress.bindAsEventListener(this);
                	} 
                    return;
            }
        else
            if (event.keyCode == Event.KEY_TAB || event.keyCode == Event.KEY_RETURN)
                return;

        this.changed = true;
        this.hasFocus = true;

        if (this.observerHandle) {
            LOG.debug("clear existing observer");
            window.clearTimeout(this.observerHandle)
        }
        ;
        LOG.debug("set timeout for request suggestion");
        // Clone event. after call in timeout handdler, original event is unaccesible.
        var domEvt = {};
        try {
            domEvt.target = event.target;
            domEvt.srcElement = event.srcElement;
            domEvt.type = event.type;
            domEvt.altKey = event.altKey;
            domEvt.button = event.button;
            domEvt.clientX = event.clientX;
            domEvt.clientY = event.clientY;
            domEvt.ctrlKey = event.ctrlKey;
            domEvt.keyCode = event.keyCode;
            domEvt.modifiers = event.modifiers;
            domEvt.pageX = event.pageX;
            domEvt.pageY = event.pageY;
            domEvt.screenX = event.screenX;
            domEvt.screenY = event.screenY;
            domEvt.shiftKey = event.shiftKey;
            domEvt.which = event.which;
        } catch(e) {
            LOG.warn("Exception on clone event");
        }
        this.observerHandle =
        window.setTimeout(this.onObserverEvent.bind(this, domEvt), this.options.frequency * 1000);
    },

    onHover: function(event) {
        var element = Event.findElement(event, 'TR');
        if (this.index != element.autocompleteIndex) {
            this.index = element.autocompleteIndex;
            this.render();
        }
        Event.stop(event);
    },

    onClick: function(event) {
        var element = Event.findElement(event, 'TR');
        this.index = element.autocompleteIndex;
        this.selectEntry(event);
        this.hide();
    },

    onBlur: function(event) {
        if (this.isUnloaded()) return;
        var offsets = Exadel.Position.calcOffsets(this.update);
        if (RichFaces.navigatorType() != "MSIE") {
            offsets["x"] = 0;
            offsets["y"] = 0;
        }
        if (event.clientX > offsets["x"] && event.clientX < (this.update.clientWidth + offsets["x"])) {
            if (event.clientY > (offsets["y"] - this.update.clientHeight) && event.clientY < offsets["y"]) {
                this.element.focus();
                return;
            }
        }
        // needed to make click events working
        setTimeout(this.hide.bind(this), 250);
        this.hasFocus = false;
        this.active = false;
    },

    render: function() {
        if (this.entryCount > 0) {
            LOG.debug('render for index ' + this.index + " and old index " + this.prevIndex);
            if (this.prevIndex != this.index) {
                var entry = this.getEntry(this.index);
                Element.addClassName(entry, this.options.selectedClass);
                // Calc scroll position :
                var scroll = document.getElementsByClassName("_suggestion_size_", this.update)[0] || this.update;
                var item = entry;
                var realOffset = 0;
                while (item && (item != scroll)) {
                    realOffset += item.offsetTop;
                    if (item.parentNode == scroll) break;
                    item = item.offsetParent;
                }
                if (this.keyEvent) {
                    this.keyEvent = false;
                    LOG.debug("Scroll = " + scroll.scrollTop + " , reallOffset= " + realOffset + " scrollHeight= " + scroll.offsetHeight);
                    var minScroll = realOffset - (scroll.clientHeight / 2) - (scroll.clientHeight / 2) % entry.offsetHeight;
                    var maxScroll = realOffset - (scroll.clientHeight * 2 / 3) + (scroll.clientHeight * 2 / 3) % (entry.offsetHeight) ;
                    if (scroll.scrollTop > minScroll) {
                        scroll.scrollTop = minScroll;
                    } else if (scroll.scrollTop < maxScroll) {
                        scroll.scrollTop = maxScroll;
                    }
                }
                // remove hightliit from inactive entry
                if (this.prevIndex >= 0) {
                    var prevEntry = this.getEntry(this.prevIndex);
                    if (prevEntry) {
                        Element.removeClassName(prevEntry, this.options.selectedClass);
                    }
                }
            }
            this.prevIndex = this.index;
            if (this.hasFocus) {
                this.show();
                this.active = true;
            }
        } else {
            this.active = false;
            this.hide();
        }
    },

    markPrevious: function() {
        if (this.index > 0) this.index--;
        //else this.index = this.entryCount - 1;
    },

    markNext: function() {
        if (this.index < this.entryCount - 1) this.index++;
        //else this.index = 0;
    },

    getEntry: function(index) {
        if (this.options.entryClass) {
            return document.getElementsByClassName(this.options.entryClass, this.update)[index];
        } else {
            return this.update.firstChild.firstChild.childNodes[index];
        }
    },

    getCurrentEntry: function() {
        return this.getEntry(this.index);
    },

    selectEntry: function(event) {
        this.active = false;
        this.updateElement(this.getCurrentEntry());
        if (this.options.onselect) {
            this.options.onselect(this, event);
        }
        if (this.update.onselect) {
            this.update.onselect(this, event);
        }
    },

    updateElement: function(selectedElement) {
        if (this.options.updateElement) {
            this.options.updateElement(selectedElement);
            return;
        }
        var value = '';
        if (this.options.select) {
            var nodes = document.getElementsByClassName(this.options.select, selectedElement) || [];
            if (nodes.length > 0) value = Element.collectTextNodes(nodes[0], this.options.select);
        } else
            value = Element.collectTextNodesIgnoreClass(selectedElement, 'informal');

        var lastTokenPos = this.findLastToken();
        if (lastTokenPos != -1) {
            var newValue = this.element.value.substr(0, lastTokenPos + 1);
            var whitespace = this.element.value.substr(lastTokenPos + 1).match(/^\s+/);
            if (whitespace)
                newValue += whitespace[0];
            this.element.value = newValue + value;
        } else {
            this.element.value = value;
        }
        this.element.focus();

        if (this.options.afterUpdateElement)
            this.options.afterUpdateElement(this.element, selectedElement);
    },

    updateChoices: function(choices) {
        if (!this.changed && this.hasFocus) {
            if (choices) {
                this.update.firstChild.replaceChild(choices, this.update.firstChild.firstChild);
            }
            // TODO - get entry elements by tag name or class
            var entryes = [];
            if (this.options.entryClass) {
                entryes = document.getElementsByClassName(this.options.entryClass, this.update) || [];
            } else if (this.update.firstChild && this.update.firstChild.firstChild && this.update.firstChild.firstChild.childNodes) {
                Element.cleanWhitespace(this.update);
                Element.cleanWhitespace(this.update.firstChild);
                Element.cleanWhitespace(this.update.firstChild.firstChild);
                entryes = this.update.firstChild.firstChild.childNodes;
            }
            this.entryCount = entryes.length;
            for (var i = 0; i < this.entryCount; i++) {
                var entry = entryes[i];
                //          var entry = this.getEntry(i);
                entry.autocompleteIndex = i;
                this.addObservers(entry);
//                if (this.options.cellpadding)
//                entry.lastChild.style.padding=this.options.cellpadding;
            }

            this.stopIndicator();
            var scroll = document.getElementsByClassName("_suggestion_size_", this.update)[0] || this.update;
            scroll.scrollTop = -1;
            scroll.scrollLeft = -1;
            this.index = 0;
            this.prevIndex = -1;
            this.render();
        }
    },

    addObservers: function(element) {
        Event.observe(element, "mouseover", this.onHover.bindAsEventListener(this));
        Event.observe(element, "click", this.onClick.bindAsEventListener(this));
    },

    onObserverEvent: function(event) {
        LOG.debug("Observer event occurs");
        this.changed = false;
        if (this.getToken().length >= this.options.minChars) {
            LOG.debug("Call data for update choices");
            this.startIndicator();
            this.getUpdatedChoices(event);
        } else {
            this.active = false;
            this.hide();
        }
        this.observerHandle = null;
    },

    getToken: function() {
        var tokenPos = this.findLastToken();
        if (tokenPos != -1)
            var ret = this.element.value.substr(tokenPos + 1).replace(/^\s+/, '').replace(/\s+$/, '');
        else
            var ret = this.element.value;

        return /\n/.test(ret) ? '' : ret;
    },

    findLastToken: function() {
        var lastTokenPos = -1;

        for (var i = 0; i < this.options.tokens.length; i++) {
            var thisTokenPos = this.element.value.lastIndexOf(this.options.tokens[i]);
            if (thisTokenPos > lastTokenPos)
                lastTokenPos = thisTokenPos;
        }
        return lastTokenPos;
    }
}


Exadel.Suggestion = Class.create();
Object.extend(Object.extend(Exadel.Suggestion.prototype, Suggestion.Base.prototype), {
    initialize: function(containerId, actionUrl, element, content, options) {
        var update = options.popup || 'ac1update';
        if (!$(update)) this.create(element, update, content, options);
        this.baseInitialize(element, update, options);
        this.options.asynchronous = true;
        this.options.onajaxcomplete = options.oncomplete;
        this.options.oncomplete = this.onComplete.bind(this);
        this.options.defaultParams = this.options.parameters || null;
        this.content = content;
        this.containerId = containerId;
        this.actionUrl = actionUrl;
        return this;
    },

    getUpdatedChoices: function(event) {
        this.options.parameters[this.options.param] = this.getToken();

        A4J.AJAX.Submit(this.containerId, this.actionUrl, event, this.options);
        return;
    },

    onComplete: function(request, event) {
        LOG.debug("AJAX response  complete - updateChoices");
        // Calculate height of choices window
        if (!this.update.style.position || this.update.style.position == 'absolute') {
            this.update.style.position = 'absolute';
            Exadel.Position.smartClone(this.element, this.update, this.options);
        }
        this.updateChoices();
        LOG.debug("Choices updated");
        if (this.options.onajaxcomplete) {
            this.options.onajaxcomplete(request, event);
        }
    },

    create: function(element, suggestion, content, options) {
        if (!$(element)) return;
        var style = "display:none;" + ( options.popupStyle || "border:1px solid black;position:absolute; background-color:white;");
        var styleClass = options.popupClass ? ' class="' + options.popupClass + '" ':'';
        new Insertion.Top($(element).ownerDocument.body,
                '<div id="' + suggestion + '"' + styleClass + ' style="' + style + '">' +
                '<table id="' + content + '" cellspacing="0" cellpadding="0">' +
                '<tbody></tbody>' +
                '</table>' +
                '</div>'
                );
    }

});

Exadel.Position = {
    source: null,
    target: null,
    smartClone: function(source, target, options) {
        this.options = Object.extend({
            width: "auto"
        }, options || {});

        this.source = $(source);
        this.target = $(target);

        var targetStyle = {};
        /*
        http://jira.exadel.com/browse/RFA-236

        var pos = Exadel.SmartPosition.getPosition(this.source, this.target, options);

        if (RichFaces.navigatorType() == "MSIE") {
            var offsets = this.calcOffsets(this.source);
            Element.setStyle(this.target, Object.extend({"left": offsets["x"] + "px", "top": offsets["y"] + "px"}, targetStyle));
        } else {
            Element.setStyle(this.target, Object.extend({"left": pos[0] + "px", "top": pos[1] + "px"}, targetStyle));
        }
        */
        var offsets = this.calcOffsets(this.source);
        Element.setStyle(this.target, Object.extend({"left": offsets["x"] + "px", "top": offsets["y"] + "px"}, targetStyle));

        if (options.iframeId) {
            var iframe = $(options.iframeId);
            Position.clone(this.target, iframe);
            Element.setStyle(this.target, {zIndex: 100});

            Element.setStyle(iframe, {zIndex: 0});
            iframe.style.position = "absolute";
            iframe.style.top = this.target.style.top;
            iframe.style.left = this.target.style.left;
            iframe.style.width = this.target.style.width;
            iframe.style.height = this.target.style.height;
        }
    },

    calcOffsets : function(element) {
        var x = 0,y = 0,ret = new Object(),prevPos, pos;

        if (element.currentStyle) {
            prevPos = element.currentStyle['position'];
        } else {
            prevPos = document.defaultView.getComputedStyle(element, null).getPropertyValue('position');
        }

        //prevPos = element.currentStyle.position;
        element.style.position = "absolute";

        pos = Position.cumulativeOffset(element);
        y = Number(pos[1] + element.clientHeight);
        x = Number(pos[0]);
        element.style.position = prevPos;
        ret["x"] = x;
        ret["y"] = y;

        return ret;
    },

    _removePx : function(str) {
        str += "";
        if (str.indexOf("px") != -1) {
            return str.substr(0, str.indexOf("px"));
        }
        return str;
    },

    calcHeight: function() {
        return this.options.height == "auto" ? "" :this.options.height;
    },

    calcTop: function(targetHeight) {
        var sourceOffset = Position.cumulativeOffset(this.source);
        var sourceTop = sourceOffset[1];
        var sourceHeight = this.source.offsetHeight;
        var body = this.getBody();
        //		if (sourceTop + sourceHeight + targetHeight <= body.clientHeight) {
        return sourceTop + sourceHeight - 1;
    },

    calcWidth: function() {
        if (this.options.width == "auto") {
            return "";
        } else {
            if (this.options.width.indexOf("%") >= 0) {
                // Count persents to pixels
                var percent = parseInt(this.options.width.substring(0, this.options.width.indexOf("%")));
                var sizeInPixels = parseInt(this.source.offsetWidth) * percent / 100;
                this.options.width = sizeInPixels + "px";
            }

            return this.options.width;
        }
        //		return this.source.offsetWidth;
    },

    calcLeft: function(targetWidth) {
        //		Position.prepare();
        var sourceOffset = Position.cumulativeOffset(this.source);
        var sourceLeft = sourceOffset[0];
        var sourceWidth = this.source.offsetWidth;
        var body = this.getBody();
        var width = parseInt(sourceLeft) + parseInt(sourceWidth) + parseInt(targetWidth);
        if (width <= parseInt(body.clientWidth)) {
            return sourceLeft;
        } else {
            return width;
        }
    },

    getBody: function() {
        return this.source.ownerDocument.body;
    }
}
