/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;

public abstract class JAXBContext {
    public static final String JAXB_CONTEXT_FACTORY = "javax.xml.bind.context.factory";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public abstract Marshaller createMarshaller() throws JAXBException;

    public abstract Unmarshaller createUnmarshaller() throws JAXBException;

    public abstract Validator createValidator() throws JAXBException;

    public static JAXBContext newInstance(String contextPath) throws JAXBException {
        return JAXBContext.newInstance(contextPath, Thread.currentThread().getContextClassLoader());
    }

    public static JAXBContext newInstance(String contextPath, ClassLoader classLoader) throws JAXBException {
        JAXBContext jaxbContext = null;
        String jaxbContextFactory = null;
        if (contextPath == null) {
            throw new JAXBException("Invalid contextPath: " + contextPath);
        }
        try {
            StringTokenizer st = new StringTokenizer(contextPath, ":");
            while (st.hasMoreTokens()) {
                String path = st.nextToken().replace('.', '/');
                String jaxbPropFile = path + "/jaxb.properties";
                InputStream is = classLoader.getResourceAsStream(jaxbPropFile);
                if (is == null) {
                    throw new JAXBException("Cannot load resource: " + jaxbPropFile);
                }
                Properties jaxbProps = new Properties();
                jaxbProps.load(is);
                is.close();
                String nextContextName = jaxbProps.getProperty(JAXB_CONTEXT_FACTORY);
                if (nextContextName == null) {
                    throw new JAXBException("Cannot read property 'javax.xml.bind.context.factory' from: " + jaxbPropFile);
                }
                if (jaxbContextFactory != null && !jaxbContextFactory.equals(nextContextName)) {
                    throw new JAXBException("JAXB provider collision: " + jaxbContextFactory + "," + nextContextName);
                }
                jaxbContextFactory = nextContextName;
            }
            Class<?> contextFactoryClass = classLoader.loadClass(jaxbContextFactory);
            Method createMethod = contextFactoryClass.getMethod("createContext", class$java$lang$String == null ? (class$java$lang$String = JAXBContext.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = JAXBContext.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            jaxbContext = (JAXBContext)createMethod.invoke(contextFactoryClass, contextPath, classLoader);
        }
        catch (InvocationTargetException ite) {
            Throwable targetException = ite.getTargetException();
            throw new JAXBException("Failed to create JAXBContext: " + jaxbContextFactory, targetException);
        }
        catch (Throwable t) {
            throw new JAXBException("Failed to create JAXBContext: " + jaxbContextFactory, t);
        }
        return jaxbContext;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

