/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.ws.core.server.ServiceEndpointDTO;
import org.jboss.ws.core.server.ServiceEndpointManager;

public abstract class CommonContextServlet
extends HttpServlet {
    protected final Logger log = Logger.getLogger(CommonContextServlet.class);
    protected ServiceEndpointManager epManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initServiceEndpointManager();
    }

    protected abstract void initServiceEndpointManager();

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter writer = res.getWriter();
        res.setContentType("text/html");
        writer.print("<html>");
        this.setupHTMLResponseHeader(writer);
        URL requestURL = new URL(req.getRequestURL().toString());
        writer.print("<body>");
        writer.print("<div class='pageHeader'>JBossWS/Services</div>");
        writer.print("<div class='pageSection'>");
        writer.print("<fieldset>");
        writer.print("<legend><b>Registered Service Endpoints</b></legend>");
        writer.print("<table>");
        List<ServiceEndpointDTO> endpoints = this.epManager.getRegisteredEndpoints(requestURL);
        if (endpoints.isEmpty()) {
            writer.print("<tr>");
            writer.print("\t<td><h3>There are currently no endpoints deployed</h3></td>");
            writer.print("</tr>");
        }
        for (ServiceEndpointDTO ep : endpoints) {
            writer.print("<tr>");
            writer.print("\t<td>ServiceEndpointID</td>");
            writer.print("\t<td>" + ep.getSepID() + "</td>");
            writer.print("</tr>");
            writer.print("<tr>");
            writer.print("\t<td>ServiceEndpointAddress</td>");
            writer.print("\t<td><a href='" + ep.getAddress() + "?wsdl'>" + ep.getAddress() + "?wsdl</a></td>");
            writer.print("</tr>");
            writer.print("<tr>");
            writer.print("\t<td colspan=2>");
            writer.print("\t");
            writer.print("");
            writer.print("<table class='metrics'>");
            writer.print("<tr>");
            writer.print("\t<td>StartTime</td>");
            writer.print("\t<td>StopTime</td>");
            writer.print("\t<td></td>");
            writer.print("</tr>");
            writer.print("<tr>");
            writer.print("\t<td>" + ep.getSeMetrics().getStartTime() + "</td>");
            String stopTime = ep.getSeMetrics().getStopTime() != null ? ep.getSeMetrics().getStopTime().toString() : "";
            writer.print("\t<td>" + stopTime + "</td>");
            writer.print("\t<td></td>");
            writer.print("</tr>");
            writer.print("<tr>");
            writer.print("\t<td>RequestCount</td>");
            writer.print("\t<td>ResponseCount</td>");
            writer.print("\t<td>FaultCount</td>");
            writer.print("</tr>");
            writer.print("<tr>");
            writer.print("\t<td>" + ep.getSeMetrics().getRequestCount() + "</td>");
            writer.print("\t<td>" + ep.getSeMetrics().getResponseCount() + "</td>");
            writer.print("\t<td>" + ep.getSeMetrics().getFaultCount() + "</td>");
            writer.print("</tr>");
            writer.print("<tr>");
            writer.print("\t<td>MinProcessingTime</td>");
            writer.print("\t<td>MaxProcessingTime</td>");
            writer.print("\t<td>AvgProcessingTime</td>");
            writer.print("</tr>");
            writer.print("<tr>");
            writer.print("\t<td>" + ep.getSeMetrics().getMinProcessingTime() + "</td>");
            writer.print("\t<td>" + ep.getSeMetrics().getMaxProcessingTime() + "</td>");
            writer.print("\t<td>" + ep.getSeMetrics().getAverageProcessingTime() + "</td>");
            writer.print("</tr>");
            writer.print("");
            writer.print("");
            writer.print("</table>");
            writer.print("");
            writer.print("\t</td>");
            writer.print("</tr>");
            writer.print("<tr><td colspan='3'>&nbsp;</td></tr>");
        }
        writer.print("</table>");
        writer.print("");
        writer.print("</fieldset>");
        writer.print("</div>");
        writer.print("</body>");
        writer.print("</html>");
        writer.close();
    }

    private void setupHTMLResponseHeader(PrintWriter writer) {
        Package wsPackage = Package.getPackage("org.jboss.ws");
        writer.println("<head>");
        writer.println("<meta http-equiv='Content-Type content='text/html; charset=iso-8859-1'>");
        writer.println("<title>JBossWS / " + wsPackage.getImplementationVersion() + "</title>");
        writer.println("<link rel='stylesheet' href='./styles.css'>");
        writer.println("</head>");
    }
}

